static void add_to_pathlist(tmdy_struct_ex_t * tmdy_struct, char *s);
static void clean_up_pathlist(tmdy_struct_ex_t * tmdy_struct);
static struct timidity_file *open_file(tmdy_struct_ex_t * tmdy_struct, char *name,
				       int decompress, int noise_mode);
static struct timidity_file *open_with_mem(tmdy_struct_ex_t * tmdy_struct, char *mem, int32 memlen,
					   int noise_mode);
static void close_file(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf);
static void skip(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf, size_t len);
static int tf_getc(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf);
static char *tf_gets(tmdy_struct_ex_t * tmdy_struct, char *buff, int n, struct timidity_file *tf);
static long tf_read(tmdy_struct_ex_t * tmdy_struct, void *buff, int32 size, int32 nitems,
		    struct timidity_file *tf);
static long tf_seek(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf, long offset, int whence);
static long tf_tell(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf);
static int int_rand(tmdy_struct_ex_t * tmdy_struct, int n);	/* random [0..n-1] */
static int check_file_extension(tmdy_struct_ex_t * tmdy_struct, char *filename, char *ext, int decompress);

static void *safe_malloc(tmdy_struct_ex_t * tmdy_struct, size_t count);
static void *safe_realloc(tmdy_struct_ex_t * tmdy_struct, void *old_ptr, size_t new_size);
static void *safe_large_malloc(tmdy_struct_ex_t * tmdy_struct, size_t count);
static char *safe_strdup(tmdy_struct_ex_t * tmdy_struct, const char *s);
static void free_ptr_list(tmdy_struct_ex_t * tmdy_struct, void *ptr_list, int count);
static char **expand_file_archives(tmdy_struct_ex_t * tmdy_struct, char **files, int *nfiles_in_out);
static void randomize_string_list(tmdy_struct_ex_t * tmdy_struct, char **strlist, int nstr);
static int pathcmp(tmdy_struct_ex_t * tmdy_struct, const char *path1, const char *path2, int ignore_case);
static void sort_pathname(tmdy_struct_ex_t * tmdy_struct, char **files, int nfiles);
static int  load_table(tmdy_struct_ex_t * tmdy_struct, char *file);
static char *pathsep_strrchr(tmdy_struct_ex_t * tmdy_struct, const char *path);
extern char *pathsep_strchr(tmdy_struct_ex_t * tmdy_struct, const char *path);
static int str2mID(tmdy_struct_ex_t * tmdy_struct, char *str);

/* code:
 * "EUC"	- Extended Unix Code
 * NULL		- Auto conversion
 * "JIS"	- Japanese Industrial Standard code
 * "SJIS"	- shift-JIS code
 */
static void code_convert(tmdy_struct_ex_t * tmdy_struct, char *in, char *out, int outsiz,
			 char *in_code, char *out_code);

static void safe_exit(tmdy_struct_ex_t * tmdy_struct, int status);

/*
#undef timidity_mutex_lock
#undef timidity_mutex_unlock
#define timidity_mutex_lock(_m) 
#define timidity_mutex_unlock(_m) 
*/

