/*
 * Interfaces
 */

extern char **expand_archive_names(tmdy_struct_ex_t *tmdy_struct, int *nfiles_in_out, char **files);
/* Regist all archive files in `files_in_out', and expand the archive */

extern URL url_arc_open(tmdy_struct_ex_t *tmdy_struct, char *name);
/* Open input stream from archive.  `name' format must be "filename#entry".
 */

extern void free_archive_files(tmdy_struct_ex_t *tmdy_struct);
/* Call once at the last */

/* utilities */
extern int skip_gzip_header(tmdy_struct_ex_t *tmdy_struct, URL url);
extern int parse_gzip_header_bytes(tmdy_struct_ex_t *tmdy_struct, char *gz, long maxparse, int *hdrsiz);
extern int get_archive_type(tmdy_struct_ex_t *tmdy_struct, char *archive_name);
extern void *arc_compress(tmdy_struct_ex_t *tmdy_struct, void *buff, long bufsiz,
			  int compress_level, long *compressed_size);
extern void *arc_decompress(tmdy_struct_ex_t *tmdy_struct, void *buff, long bufsiz, long *decompressed_size);
extern int arc_case_wildmat(tmdy_struct_ex_t *tmdy_struct, char *text, char *p);
extern int arc_wildmat(tmdy_struct_ex_t *tmdy_struct, char *text, char *p);
extern void (* arc_error_handler)(tmdy_struct_ex_t *tmdy_struct, char *error_message);

/*
#undef timidity_mutex_lock
#undef timidity_mutex_unlock
#define timidity_mutex_lock(_m)
#define timidity_mutex_unlock(_m)
*/
