/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    In case you haven't heard, this program is free software;
    you can redistribute it and/or modify it under the terms of the
    GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    mix.h

*/

#ifndef ___MIX_H_
#define ___MIX_H_

	/**** private definitions ****/
#if OPT_MODE != 0
#define VOICE_LPF
#define VOICE_LPF_TRANSITION
#endif

#ifdef VOICE_LPF
	typedef int32 mix_t;
#else
	typedef sample_t mix_t;
#endif

struct s_mix_ex_t {
	timidity_mutex_t  busy;
	void (*mix_voice)(tmdy_struct_ex_t * tmdy_struct, int32 *, int, int32);
	int (*recompute_envelope)(tmdy_struct_ex_t * tmdy_struct, int);
	int (*apply_envelope_to_amp)(tmdy_struct_ex_t * tmdy_struct, int);
	int (*recompute_modulation_envelope)(tmdy_struct_ex_t * tmdy_struct, int);
	int (*apply_modulation_envelope)(tmdy_struct_ex_t * tmdy_struct, int);
	/* time (ms) for full vol note to sustain */
	int min_sustain_time;

	/**** private variables ****/
#ifdef VOICE_LPF
	mix_t mix_voice_lp[AUDIO_BUFFER_SIZE];
#else
	mix_t *mix_voice_lp;
#endif
};


mix_ex_t* new_mix(tmdy_struct_ex_t *tmdy_struct);
void destroy_mix(mix_ex_t* mix);
#endif /* ___MIX_H_ */
