/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ___MIDITRACE_H_
#define ___MIDITRACE_H_

typedef struct s_MidiTrace
{
    int offset;		/* sample offset */
    int flush_flag;	/* True while in trace_flush() */

    void (* trace_loop_hook)(tmdy_struct_ex_t *tmdy_struct);	/* Hook function for extension */

    /* Delayed event list  (The member is only access in miditrace.c) */
    struct s_MidiTraceList *head;
    struct s_MidiTraceList *tail;

    /* Memory buffer */
    struct s_MidiTraceList *free_list;
    MBlockList pool;
} MidiTrace;


struct s_miditrace_ex_t {
	timidity_mutex_t  busy;

MidiTrace midi_trace;

void (*init_midi_trace)(tmdy_struct_ex_t *tmdy_struct);

void (*push_midi_trace0)(tmdy_struct_ex_t *tmdy_struct, void (*f)(tmdy_struct_ex_t*));
void (*push_midi_trace1)(tmdy_struct_ex_t *tmdy_struct, void (*f)(tmdy_struct_ex_t*, int), int arg1);
void (*push_midi_trace2)(tmdy_struct_ex_t *tmdy_struct, void (*f)(tmdy_struct_ex_t*, int, int), int arg1, int arg2);
void (*push_midi_trace_ce)(tmdy_struct_ex_t *tmdy_struct, void (*f)(tmdy_struct_ex_t*, CtlEvent *), CtlEvent *ce);
void (*push_midi_time_vp)(tmdy_struct_ex_t *tmdy_struct, int32 start, void (*f)(tmdy_struct_ex_t *tmdy_struct, void *), void *vp);

int32 (*trace_loop)(tmdy_struct_ex_t *tmdy_struct);
void (*trace_flush)(tmdy_struct_ex_t *tmdy_struct);
void (*trace_offset)(tmdy_struct_ex_t *tmdy_struct, int offset);
//void (*trace_nodelay)(tmdy_struct_ex_t *tmdy_struct, int nodelay);
void (*set_trace_loop_hook)(tmdy_struct_ex_t *tmdy_struct, void (* f)(tmdy_struct_ex_t *tmdy_struct));
int32 (*current_trace_samples)(tmdy_struct_ex_t *tmdy_struct);
int32 (*trace_wait_samples)(tmdy_struct_ex_t *tmdy_struct);

/**** private ****/
int trace_loop_lasttime;
	
};


miditrace_ex_t* new_miditrace(tmdy_struct_ex_t *tmdy_struct);
void destroy_miditrace(miditrace_ex_t* miditrace);

#endif /* ___MIDITRACE_H_ */
