/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2003 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#include <stdio.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <ctype.h>
#include <stddef.h>
#endif
#ifndef NO_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#ifdef __W32__
#include <windows.h>
#include <io.h>
#include <shlobj.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <fcntl.h> /* for open */

#ifdef HAVE_STDBOOL_H
#include <stdbool.h>
#endif

#ifndef __bool_true_false_are_defined
# ifdef bool
#  undef bool
# endif
# ifdef ture
#  undef ture
# endif
# ifdef false
#  undef false
# endif
# define bool int
# define false ((bool)0)
# define true (!false)
# define __bool_true_false_are_defined true
#endif /* C99 _Bool hack */

#ifdef BORLANDC_EXCEPTION
#include <excpt.h>
#endif /* BORLANDC_EXCEPTION */
#include <signal.h>

#if defined(__FreeBSD__) && !defined(__alpha__)
#include <floatingpoint.h> /* For FP exceptions */
#endif
#if defined(__NetBSD__) || defined(__OpenBSD__)
#include <ieeefp.h> /* For FP exceptions */
#endif


#include "interface.h"
#include "timidity.h"
#include "utils/tmdy_getopt.h"
#include "common.h"
#include "instrum.h"
#include "playmidi.h"
#include "readmidi.h"
#include "output.h"
#include "controls.h"
#include "tables.h"
#include "miditrace.h"
#include "reverb.h"
#ifdef SUPPORT_SOUNDSPEC
#include "soundspec.h"
#endif /* SUPPORT_SOUNDSPEC */
#include "resample.h"
#include "recache.h"
#include "arc.h"
#include "strtab.h"
#include "wrd.h"
#define DEFINE_GLOBALS
//#include "mid.defs" guha
#include "aq.h"
#include "mix.h"
#include "../libunimod/unimod.h"
#include "quantity.h"

#ifdef IA_W32GUI
#include "w32g.h"
#include "w32g_utl.h"
#endif

#ifndef __GNUC__
#define __attribute__(x) /* ignore */
#endif

#include "timidity_main.h"
/*
#if defined(main) || defined(ANOTHER_MAIN)
#define MAIN_INTERFACE
#else
#define MAIN_INTERFACE static
#endif * main *
*/
//#include "timidity_main_prv.h"

//tmdy_struct_ex_t * tmdy_struct;  //guha

extern int SecondMode;

static int first=0;

#ifdef IA_W32GUI
int w32gSecondTiMidity(int opt, int argc, char **argv);
int w32gSecondTiMidityExit(void);
int w32gLoadDefaultPlaylist(void);
int w32gSaveDefaultPlaylist(void);
extern int volatile save_playlist_once_before_exit_flag;
#endif /* IA_W32GUI */

#ifndef __MACOS__
#ifdef __W32__ /* Windows */
#if ( (!defined(IA_W32GUI) || defined(__CYGWIN32__) || defined(__MINGW32__)) && !defined(IA_W32G_SYN) )
/* Cygwin or Console */
int __cdecl main(int argc, char **argv)
#else
/* _MSC_VER, _BORLANDC_ */
int win_main(int argc, char **argv)
#endif
#else /* UNIX */
int main(int argc, char **argv)
#endif
{
    int c, err;
    int nfiles;
    char **files;
    int main_ret;
    int longind;
	tmdy_struct_ex_t * tmdy_struct;  //guha

#if defined(DANGEROUS_RENICE) && !defined(__W32__) && !defined(main)
    /*
     * THIS CODES MUST EXECUT BEGINNING OF MAIN FOR SECURITY.
     * DONT PUT ANY CODES ABOVE.
     */
#include <sys/resource.h>
    int uid;
#ifdef sun
    extern int setpriority(int which, id_t who, int prio);
    extern int setreuid(int ruid, int euid);
#endif /* sun */

    uid = getuid();
    if(setpriority(PRIO_PROCESS, 0, DANGEROUS_RENICE) < 0)
    {
	perror("setpriority");
	fprintf(stderr, "Couldn't set priority to %d.", DANGEROUS_RENICE);
    }
    setreuid(uid, uid);
#endif /* defined(DANGEROUS_RENICE) && !defined(__W32__) && !defined(main) */

	if(first==0){
		tmdy_base_init();
	}
	tmdy_struct=new_tmdy_struct();
	first++;
	
#if defined(REDIRECT_STDOUT)
    memcpy(stdout, fopen(REDIRECT_STDOUT, "a+"), sizeof(FILE));
    printf("TiMidity++ start\n");fflush(stdout);
#endif

#ifdef main
    {
//	static int maincnt = 0;
	if(TMDY_MAIN->maincnt++ > 0)
	{
	    argv++;
	    argc--;
	    while(argv[0][0] == '-') {
		argv++;
		argc--;
	    }
	    (TMDY_CONTROLS->ctl)->pass_playing_list(tmdy_struct, argc, argv);
	    return 0;
	}
    }
#endif

#ifdef IA_DYNAMIC
    {
#ifdef XP_UNIX
	argv[0] = "netscape";
#endif /* XP_UNIX */
	TMDY_MAIN->dynamic_interface_id = 0;
	dl_init(argc, argv);
    }
#endif /* IA_DYNAMIC */

    if(((TMDY_COMMON->program_name)=TMDY_COMMON->pathsep_strrchr(tmdy_struct, argv[0]))) (TMDY_COMMON->program_name)++;
    else (TMDY_COMMON->program_name)=argv[0];

    if(strncmp((TMDY_COMMON->program_name),"timidity",8) == 0);
    else if(strncmp((TMDY_COMMON->program_name),"kmidi",5) == 0) TMDY_MAIN->set_ctl(tmdy_struct,"q");
    else if(strncmp((TMDY_COMMON->program_name),"tkmidi",6) == 0) TMDY_MAIN->set_ctl(tmdy_struct,"k");
    else if(strncmp((TMDY_COMMON->program_name),"gtkmidi",6) == 0) TMDY_MAIN->set_ctl(tmdy_struct,"g");
    else if(strncmp((TMDY_COMMON->program_name),"xmmidi",6) == 0) TMDY_MAIN->set_ctl(tmdy_struct,"m");
    else if(strncmp((TMDY_COMMON->program_name),"xawmidi",7) == 0) TMDY_MAIN->set_ctl(tmdy_struct,"a");
    else if(strncmp((TMDY_COMMON->program_name),"xskinmidi",9) == 0) TMDY_MAIN->set_ctl(tmdy_struct,"i");

    if(argc == 1 && !strchr(INTERACTIVE_INTERFACE_IDS, (TMDY_CONTROLS->ctl)->id_character))
    {
	TMDY_MAIN->interesting_message(tmdy_struct);
	return 0;
    }
	
    TMDY_MAIN->timidity_start_initialize(tmdy_struct);
#if defined ( IA_W32GUI ) || defined ( IA_W32G_SYN )
    if(CoInitialize(NULL)==S_OK)
      TMDY_MAIN->CoInitializeOK = 1;
    w32g_initialize(tmdy_struct);

#ifdef IA_W32GUI
	/* Secondary TiMidity Execute */
	/*	FirstLoadIniFile(); */
	if(w32gSecondTiMidity(SecondMode,argc,argv)==FALSE){
		return 0;
	}
#endif
	
    for(c = 1; c < argc; c++)
    {
	if(is_directory(argv[c]))
	{
	    char *p;
	    p = (char *)TMDY_COMMON->safe_malloc(tmdy_struct, strlen(argv[c]) + 2);
	    strcpy(p, argv[c]);
	    directory_form(p);
	    argv[c] = p;
	}
    }
#endif

    if((err = TMDY_MAIN->timidity_pre_load_configuration(tmdy_struct)) != 0)
	return err;
	
	optind = longind = 0;
	while ((c = getopt_long(argc, argv, TMDY_MAIN->optcommands, TMDY_MAIN->longopts, &longind)) > 0){
		if ((err = TMDY_MAIN->set_tim_opt_long(tmdy_struct, c, optarg, longind)) != 0)
			break;
	}
	
    TMDY_RESAMPLE->initialize_resampler_coeffs(tmdy_struct);

    err += TMDY_MAIN->timidity_post_load_configuration(tmdy_struct);
	
    /* If there were problems, give up now */
    if(err || (optind >= argc &&
	       !strchr(INTERACTIVE_INTERFACE_IDS, (TMDY_CONTROLS->ctl)->id_character)))
    {
	if(!(TMDY_MAIN->got_a_configuration))
	{
#ifdef __W32__
	    char config1[1024];
	    char config2[1024];

	    memset(config1, 0, sizeof(config1));
	    memset(config2, 0, sizeof(config2));
#if defined ( IA_W32GUI ) || defined ( IA_W32G_SYN )
	    {
		extern char *ConfigFile;
		strncpy(config1, ConfigFile, sizeof(config1) - 1);
	    }
#else
	    /* !IA_W32GUI */
	    GetWindowsDirectory(config1, 1023 - 13);
	    strcat(config1, "\\TIMIDITY.CFG");
#endif

	    if(GetModuleFileName(NULL, config2, 1023))
	    {
		char *strp;
		config2[1023] = '\0';
		if(strp = strrchr(config2, '\\'))
		{
		    *(++strp)='\0';
		    strcat(config2,"TIMIDITY.CFG");
		}
	    }

	    (TMDY_CONTROLS->ctl)->cmsg(tmdy_struct, CMSG_FATAL, VERB_NORMAL,
		      "%s: Can't read any configuration file.\nPlease check "
		      "%s or %s", (TMDY_COMMON->program_name), config1, config2);
#else
	    (TMDY_CONTROLS->ctl)->cmsg(tmdy_struct, CMSG_FATAL, VERB_NORMAL,
		      "%s: Can't read any configuration file.\nPlease check "
		      CONFIG_FILE, (TMDY_COMMON->program_name));
#endif /* __W32__ */
	}
	else
	{
	    (TMDY_CONTROLS->ctl)->cmsg(tmdy_struct, CMSG_ERROR, VERB_NORMAL,
		      "Try %s -h for help", (TMDY_COMMON->program_name));
	}

#if !defined ( IA_W32GUI ) && !defined ( IA_W32G_SYN ) /* Try to continue if it is Windows version */
	return 1; /* problems with command line */
#endif
    }

    TMDY_MAIN->timidity_init_player(tmdy_struct);

    nfiles = argc - optind;
    files  = argv + optind;
    if(nfiles > 0 && (TMDY_CONTROLS->ctl)->id_character != 'r' && (TMDY_CONTROLS->ctl)->id_character != 'A' && (TMDY_CONTROLS->ctl)->id_character != 'W' && (TMDY_CONTROLS->ctl)->id_character != 'P')
	files = TMDY_COMMON->expand_file_archives(tmdy_struct, files, &nfiles);
#ifdef HAVE_SLEEP
	sleep(1); //to avoid dumb interface error
#endif

#ifndef IA_W32GUI
    main_ret = TMDY_MAIN->timidity_play_main(tmdy_struct,nfiles, files);
#ifdef IA_W32G_SYN
    if(TMDY_MAIN->CoInitializeOK)
      CoUninitialize();
#endif /* IA_W32G_SYN */
#else
	w32gLoadDefaultPlaylist();
    main_ret = TMDY_MAIN->timidity_play_main(tmdy_struct,nfiles, files);
	if(save_playlist_once_before_exit_flag) {
		save_playlist_once_before_exit_flag = 0;
		w32gSaveDefaultPlaylist();
	}
    w32gSecondTiMidityExit();
    if(TMDY_MAIN->CoInitializeOK)
      CoUninitialize();
#endif /* IA_W32GUI */

    TMDY_INSTRUM->free_instruments(tmdy_struct, 0);
    TMDY_UTILS->mblock->free_global_mblock(tmdy_struct);
    TMDY_READMIDI->free_all_midi_file_info(tmdy_struct);
	TMDY_READMIDI->free_userdrum(tmdy_struct);
	TMDY_READMIDI->free_userinst(tmdy_struct);
    TMDY_MAIN->tmdy_free_config(tmdy_struct);
	TMDY_REVERB->free_effect_buffers(tmdy_struct);
	
	destroy_tmdy_struct(tmdy_struct);
	first--;
	if(first==0){
		tmdy_base_close();
	}
	
    return main_ret;
}
#endif /* __MACOS__ */



