/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _WINDOW_H_
#define _WINDOW_H_

#include "x_mag.h"
extern void WinEvent(tmdy_struct_ex_t *tmdy_struct);
extern void EndWin(tmdy_struct_ex_t *tmdy_struct);
extern void WinFlush(tmdy_struct_ex_t *tmdy_struct);
extern void AddLine(tmdy_struct_ex_t *tmdy_struct, const unsigned char *,int);
extern int OpenWRDWindow(tmdy_struct_ex_t *tmdy_struct, char *opt);
extern void CloseWRDWindow(tmdy_struct_ex_t *tmdy_struct);
extern void x_RedrawControl(tmdy_struct_ex_t *tmdy_struct, int flag);
extern void x_Gcls(tmdy_struct_ex_t *tmdy_struct, int);
extern void x_Gline(tmdy_struct_ex_t *tmdy_struct, int *,int);
extern void x_GCircle(tmdy_struct_ex_t *tmdy_struct, int *,int);
extern void x_Pal(tmdy_struct_ex_t *tmdy_struct, int *,int);
extern void x_Palrev(tmdy_struct_ex_t *tmdy_struct, int pallet);
extern void x_Gscreen(tmdy_struct_ex_t *tmdy_struct, int active,int appear);
extern void x_Fade(tmdy_struct_ex_t *tmdy_struct, int *,int,int,int);
extern void x_Mag(tmdy_struct_ex_t *tmdy_struct, magdata *,int32,int32,int32,int32);
extern void x_PLoad(tmdy_struct_ex_t *tmdy_struct, char *filename);
extern void x_GMove(tmdy_struct_ex_t *tmdy_struct, int,int,int,int,int,int,int,int,int);
extern void x_GMode(tmdy_struct_ex_t *tmdy_struct, int mode);
extern void x_Ton(tmdy_struct_ex_t *tmdy_struct, int param);
extern void x_Gon(tmdy_struct_ex_t *tmdy_struct, int param);
extern void x_Startup(tmdy_struct_ex_t *tmdy_struct, int version);
extern void x_VSget(tmdy_struct_ex_t *tmdy_struct, int *,int);
extern void x_VRel(tmdy_struct_ex_t *tmdy_struct);
extern void x_VCopy(tmdy_struct_ex_t *tmdy_struct, int,int,int,int,int,int,int,int,int);
extern void x_XCopy(tmdy_struct_ex_t *tmdy_struct, int sx1, int sy1, int sx2, int sy2,
			 int tx, int ty, int ss, int ts, int method, int *opts, int npots);
#endif
