/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    w32_a.h - Audio queue.
	   Written by Masanao Izumo <mo@goice.co.jp>
*/

#ifndef ___W32_A_H_
#define ___W32_A_H_

struct MMBuffer
{
    int                 Number;
    int                 Prepared;   // Non-zero if this buffer has been prepared.

    HGLOBAL             hData;
    void *              Data;

    HGLOBAL             hHead;
    WAVEHDR *           Head;

    struct MMBuffer *   Next;
};


struct s_w32_a_ex_t {
timidity_mutex_t  busy;

/**  local variables **/
struct MMBuffer *            Buffers;
volatile struct MMBuffer *   FreeBuffers;
volatile int                 NumBuffersInUse;
HWAVEOUT                     hDevice;
int                          BufferDelay;                    // in milliseconds
int                    AllowSynchronousWaveforms;
};


w32_a_ex_t* new_w32_a(tmdy_struct_ex_t *tmdy_struct);
void destroy_w32_a(w32_a_ex_t* w32_a);

#endif /* ___W32_A_H_ */
