#include "timidity.h"
#include "common.h"
#include "utils_export.h"
#include "memb.h"
#include "mblock.h"
#include "strtab.h"
#include "timer.h"
#ifdef SUPPORT_SOUNDSPEC
#include "fft.h"
#endif
#include "fft4g.h"
#ifdef JAPANESE
#include "nkflib.h"
#endif
#ifdef SUPPORT_SOCKET
#include "net.h"
#endif
#include "bitset.h"

utils_ex_t* new_utils(tmdy_struct_ex_t *tmdy_struct){

	utils_ex_t* utils_ex;

	utils_ex=(utils_ex_t *)malloc(sizeof(utils_ex_t));

	

	utils_ex->memb=new_memb(tmdy_struct);
	utils_ex->mblock=new_mblock(tmdy_struct);
	utils_ex->strtab=new_strtab(tmdy_struct);
	utils_ex->timer=new_timer(tmdy_struct);
#ifdef SUPPORT_SOUNDSPEC
	utils_ex->fft=new_fft(tmdy_struct);
#endif
	utils_ex->fft4g=new_fft4g(tmdy_struct);
#ifdef JAPANESE
	utils_ex->nkflib=new_nkflib(tmdy_struct);
#endif

#ifdef SUPPORT_SOCKET
	utils_ex->net=new_net(tmdy_struct);
#endif
	utils_ex->bitset=new_bitset(tmdy_struct);
	
	return utils_ex;
}
void destroy_utils(utils_ex_t* utils){
	destroy_memb(utils->memb);
	destroy_mblock(utils->mblock);

	destroy_strtab(utils->strtab);

	destroy_timer(utils->timer);
#ifdef SUPPORT_SOUNDSPEC

	destroy_fft(utils->fft);
#endif

	destroy_fft4g(utils->fft4g);
#ifdef JAPANESE

	destroy_nkflib(utils->nkflib);

#endif
#ifdef SUPPORT_SOCKET
	destroy_net(utils->net);

#endif	
	destroy_bitset(utils->bitset);

	
	free(utils);
}
/*
if NEEDGETOPT
GETOPT_OBJS = getopt.o
endif

if ENABLE_NETWORK
NET_OBJS = net.o
endif

if ENABLE_SOUND_SPEC
SOUND_SPEC_OBJS = fft.o
endif
#define SUPPORT_SOUNDSPEC

if W32READDIR
W32READDIR_OBJS = readdir_win.o
endif
*/
