/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    rtsyn.h
        Copyright (c) 2003  Keishi Suenaga <s_keishi@mutt.freemail.ne.jp>

    I referenced following sources.
        alsaseq_c.c - ALSA sequencer server interface
            Copyright (c) 2000  Takashi Iwai <tiwai@suse.de>
        readmidi.c
*/
#ifndef __RTSYN_H
#define __RTSYN_H 1


#include "interface.h"

#include <stdio.h>

#include <stdarg.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#endif
#ifndef NO_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <math.h>
#include <signal.h>

#include "server_defs.h"

#ifdef __W32__
#include <windows.h>
#include <mmsystem.h>
#endif

#if defined(HAVE_PTHREAD_H) || defined(__W32__)
#define USE_WINSYN_TIMER_I 1
#endif

#ifdef HAVE_PTHREAD_H
#include <pthread.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif


#ifdef IA_PORTMIDISYN
#include <portmidi.h>
#include <porttime.h>
#endif

#include "tmdy_struct.h"
#include "timidity.h"
#include "common.h"
#include "controls.h"
#include "instrum.h"
#include "playmidi.h"
#include "readmidi.h"
#include "recache.h"
#include "output.h"
#include "aq.h"
#include "timer.h"
#include "timidity_main.h"


/**** global definitions *****/

/* How often calcurate data. */
#define TICKTIME_HZ 100
#define MAX_PORT 4

/**** local definitions ****/
/* rtsyn_winmm.c */
#if defined(IA_WINSYN) || defined(IA_W32G_SYN)
#define MAX_EXBUF 20
#define BUFF_SIZE 512
struct evbuf_t{
//	int status;
	UINT wMsg;
	UINT	port;
	DWORD	dwParam1;
	DWORD	dwParam2;
};
#define EVBUFF_SIZE 512
enum{B_OK, B_WORK, B_END};

typedef struct _call_data_t {
	UINT port;
	tmdy_struct_ex_t *tmdy_struct;
}call_data_t;
#endif 
/* rtsyn_portmidi.c */
#ifdef IA_PORTMIDISYN
#define PMSYN_MAX_EXBUF 20
#define PMSYN_BUFF_SIZE 512
#define PMSYN_PMBUFF_SIZE 8192
#define PMSYN_EXBUFF_SIZE 512
struct midistream_t{
	PortMidiStream* stream;
};

#endif 
/**** main struct ****/

struct _rtsyn_ex_t {
	timidity_mutex_t  busy;

/* rtsyn_common.c */
double rtsyn_reachtime;
int rtsyn_system_mode;
/* rtsyn_(interface).c */
int portID[MAX_PORT];
char rtsyn_portlist[32][80];
int rtsyn_nportlist;

/******************************************************************************/
/*                                                                            */
/*  Interface independent functions (see rtsyn_common.c)                      */
/*                                                                            */
/******************************************************************************/
/* reset synth    */
void (*rtsyn_gm_reset)(tmdy_struct_ex_t *tmdy_struct);
void (*rtsyn_gs_reset)(tmdy_struct_ex_t *tmdy_struct);
void (*rtsyn_xg_reset)(tmdy_struct_ex_t *tmdy_struct);
void (*rtsyn_normal_reset)(tmdy_struct_ex_t *tmdy_struct);

/* mode change                                            *
 * only in nomalmode program can accept reset(sysex) data */
void (*rtsyn_gm_modeset)(tmdy_struct_ex_t *tmdy_struct);
void (*rtsyn_gs_modeset)(tmdy_struct_ex_t *tmdy_struct);
void (*rtsyn_xg_modeset)(tmdy_struct_ex_t *tmdy_struct);
void (*rtsyn_normal_modeset)(tmdy_struct_ex_t *tmdy_struct);

void (*rtsyn_init)(tmdy_struct_ex_t *tmdy_struct);
void (*rtsyn_close)(tmdy_struct_ex_t *tmdy_struct);
void (*rtsyn_play_event)(tmdy_struct_ex_t *tmdy_struct, MidiEvent *ev);
void (*rtsyn_server_reset)(tmdy_struct_ex_t *tmdy_struct);
void (*rtsyn_stop_playing)(tmdy_struct_ex_t *tmdy_struct);
int (*rtsyn_play_one_data )(tmdy_struct_ex_t *tmdy_struct, int port, int32 dwParam1);
void (*rtsyn_play_one_sysex )(tmdy_struct_ex_t *tmdy_struct, char *sysexbuffer, int exlen );
void (*rtsyn_play_calculate)(tmdy_struct_ex_t *tmdy_struct);

int (*rtsyn_add_midi_port)(tmdy_struct_ex_t *tmdy_struct, int port_id);
void (*rtsyn_delete_midi_port)(tmdy_struct_ex_t *tmdy_struct, int port_id);

/******************************************************************************/
/*                                                                            */
/*  Interface dependent functions (see rtsyn_winmm.c rtsyn_portmidi.c)        */
/*                                                                            */
/******************************************************************************/
void (*rtsyn_get_port_list)(tmdy_struct_ex_t *tmdy_struct);
int (*rtsyn_synth_start)(tmdy_struct_ex_t *tmdy_struct);
void (*rtsyn_synth_stop)(tmdy_struct_ex_t *tmdy_struct);
int (*rtsyn_play_some_data )(tmdy_struct_ex_t *tmdy_struct);
#if defined(IA_WINSYN) || defined(IA_W32G_SYN)
int (*rtsyn_buf_check)(tmdy_struct_ex_t *tmdy_struct);
#endif
void (*rtsyn_midiports_close)(tmdy_struct_ex_t *tmdy_struct);

/**** private variables ****/
/* rtsyn_common.c */
double starttime;
//acitive sensing
int active_sensing_flag;
double active_sensing_time;

//timer interrupt
#ifdef USE_WINSYN_TIMER_I
#ifdef __W32__
MMRESULT timerID;
#else 
pthread_t timer_thread;
int thread_on_f;
#endif
#endif
/* rtsyn_winmm.c */
#if defined(IA_WINSYN) || defined(IA_W32G_SYN)
timidity_mutex_t midi_mutex;
UINT InNum;
HMIDIIN  hMidiIn[MAX_PORT];
MIDIHDR *IMidiHdr[MAX_PORT][MAX_EXBUF];
call_data_t call_data[MAX_PORT];

char sIMidiHdr[MAX_PORT][MAX_EXBUF][sizeof(MIDIHDR)];
char sImidiHdr_data[MAX_PORT][MAX_EXBUF][BUFF_SIZE];
struct evbuf_t evbuf[EVBUFF_SIZE];
UINT  evbwpoint;
UINT  evbrpoint;
UINT evbsysexpoint;
//UINT  mvbuse;
#endif
/* rtsyn_portmidi.c */
#ifdef IA_PORTMIDISYN
unsigned int InNum;
struct midistream_t  midistream[MAX_PORT];
PmEvent pmbuffer[PMSYN_PMBUFF_SIZE];
char    sysexbuffer[PMSYN_EXBUFF_SIZE];
#endif

};

rtsyn_ex_t* new_rtsyn(tmdy_struct_ex_t *tmdy_struct);
void destroy_rtsyn(rtsyn_ex_t* rtsyn);

#endif /* __RTSYN_H */
