/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *    TestSetProducer.java
 *    Copyright (C) 2002 Mark Hall
 *
 */

package weka.gui.beans;

import weka.core.Instance;
import weka.core.Instances;

/**
 * Interface to something that can produce test sets
 *
 * @author <a href="mailto:mhall@cs.waikato.ac.nz">Mark Hall</a>
 * @version $Revision: 1.2 $
 */
public interface TestSetProducer {

  /**
   * Add a listener for test set events
   *
   * @param tsl a <code>TestSetListener</code> value
   */
  void addTestSetListener(TestSetListener tsl);

  /**
   * Remove a listener for test set events
   *
   * @param tsl a <code>TestSetListener</code> value
   */
  void removeTestSetListener(TestSetListener tsl);

}
