/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import weka.LocalString;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.clusterers.EM;
import weka.core.Attribute;
import weka.core.Drawable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.InstancesSummaryPanel;
import weka.gui.ListSelectorDialog;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyPanel;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.SetInstancesPanel;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class ClustererPanel
extends JPanel {
    public static String MODEL_FILE_EXTENSION = ".model";
    protected GenericObjectEditor m_ClustererEditor = new GenericObjectEditor();
    protected PropertyPanel m_CLPanel = new PropertyPanel(this.m_ClustererEditor);
    protected JTextArea m_OutText = new JTextArea(20, 40);
    protected Logger m_Log = new SysErrLog();
    SaveBuffer m_SaveOut = new SaveBuffer(this.m_Log, this);
    protected ResultHistoryPanel m_History = new ResultHistoryPanel(this.m_OutText);
    protected JRadioButton m_PercentBut = new JRadioButton(LocalString.get("Percentage split"));
    protected JRadioButton m_TrainBut = new JRadioButton(LocalString.get("Use training set"));
    protected JRadioButton m_TestSplitBut = new JRadioButton(LocalString.get("Supplied test set"));
    protected JRadioButton m_ClassesToClustersBut = new JRadioButton(LocalString.get("Classes to clusters evaluation"));
    protected JComboBox m_ClassCombo = new JComboBox();
    protected JLabel m_PercentLab = new JLabel("%", 4);
    protected JTextField m_PercentText = new JTextField("66");
    protected JButton m_SetTestBut = new JButton(LocalString.get("Set..."));
    protected JFrame m_SetTestFrame;
    protected JButton m_ignoreBut = new JButton(LocalString.get("Ignore attributes"));
    protected DefaultListModel m_ignoreKeyModel = new DefaultListModel();
    protected JList m_ignoreKeyList = new JList(this.m_ignoreKeyModel);
    ActionListener m_RadioListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ClustererPanel.this.updateRadioLinks();
        }
    };
    protected JButton m_StartBut = new JButton(LocalString.get("Start"));
    private Dimension COMBO_SIZE;
    protected JButton m_StopBut;
    protected Instances m_Instances;
    protected Instances m_TestInstances;
    protected VisualizePanel m_CurrentVis;
    protected JCheckBox m_StorePredictionsBut;
    protected Thread m_RunThread;
    protected InstancesSummaryPanel m_Summary;
    protected FileFilter m_ModelFilter;
    protected JFileChooser m_FileChooser;
    static /* synthetic */ Class class$weka$core$SelectedTag;
    static /* synthetic */ Class class$weka$gui$SelectedTagEditor;
    static /* synthetic */ Class class$weka$clusterers$Clusterer;
    static /* synthetic */ Class class$weka$gui$GenericObjectEditor;
    static /* synthetic */ Class class$weka$clusterers$DensityBasedClusterer;
    static /* synthetic */ Class class$weka$attributeSelection$UnsupervisedSubsetEvaluator;

    public ClustererPanel() {
        this.COMBO_SIZE = new Dimension(250, this.m_StartBut.getPreferredSize().height);
        this.m_StopBut = new JButton(LocalString.get("Stop"));
        this.m_CurrentVis = null;
        this.m_StorePredictionsBut = new JCheckBox(LocalString.get("Store clusters for visualization"));
        this.m_ModelFilter = new ExtensionFileFilter(MODEL_FILE_EXTENSION, LocalString.get("Model object files"));
        this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_OutText.setEditable(false);
        this.m_OutText.setFont(new Font(LocalString.get("Monospaced"), 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 16) {
                    ClustererPanel.this.m_OutText.selectAll();
                }
            }
        });
        this.m_History.setBorder(BorderFactory.createTitledBorder(LocalString.get("Result list (right-click for options)")));
        this.m_ClustererEditor.setClassType(class$weka$clusterers$Clusterer == null ? (class$weka$clusterers$Clusterer = ClustererPanel.class$("weka.clusterers.Clusterer")) : class$weka$clusterers$Clusterer);
        this.m_ClustererEditor.setValue(new EM());
        this.m_ClustererEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ClustererPanel.this.repaint();
            }
        });
        this.m_TrainBut.setToolTipText(LocalString.get("Cluster the same set that the clusterer") + LocalString.get(" is trained on"));
        this.m_PercentBut.setToolTipText(LocalString.get("Train on a percentage of the data and") + LocalString.get(" cluster the remainder"));
        this.m_TestSplitBut.setToolTipText(LocalString.get("Cluster a user-specified dataset"));
        this.m_ClassesToClustersBut.setToolTipText(LocalString.get("Evaluate clusters with respect to a") + LocalString.get(" class"));
        this.m_ClassCombo.setToolTipText(LocalString.get("Select the class attribute for class based") + LocalString.get(" evaluation"));
        this.m_StartBut.setToolTipText(LocalString.get("Starts the clustering"));
        this.m_StopBut.setToolTipText(LocalString.get("Stops a running clusterer"));
        this.m_StorePredictionsBut.setToolTipText(LocalString.get("Store predictions in the result list for later ") + LocalString.get("visualization"));
        this.m_ignoreBut.setToolTipText(LocalString.get("Ignore attributes during clustering"));
        this.m_FileChooser.setFileFilter(this.m_ModelFilter);
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_ClassCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setEnabled(false);
        this.m_TrainBut.setSelected(true);
        this.m_StorePredictionsBut.setSelected(true);
        this.updateRadioLinks();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_TrainBut);
        buttonGroup.add(this.m_PercentBut);
        buttonGroup.add(this.m_TestSplitBut);
        buttonGroup.add(this.m_ClassesToClustersBut);
        this.m_TrainBut.addActionListener(this.m_RadioListener);
        this.m_PercentBut.addActionListener(this.m_RadioListener);
        this.m_TestSplitBut.addActionListener(this.m_RadioListener);
        this.m_ClassesToClustersBut.addActionListener(this.m_RadioListener);
        this.m_SetTestBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClustererPanel.this.setTestSet();
            }
        });
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_ignoreBut.setEnabled(false);
        this.m_StartBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClustererPanel.this.startClusterer();
            }
        });
        this.m_StopBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClustererPanel.this.stopClusterer();
            }
        });
        this.m_ignoreBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClustererPanel.this.setIgnoreColumns();
            }
        });
        this.m_History.setHandleRightClicks(false);
        this.m_History.getList().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 16 || mouseEvent.isAltDown()) {
                    int n = ClustererPanel.this.m_History.getList().locationToIndex(mouseEvent.getPoint());
                    if (n != -1) {
                        String string = ClustererPanel.this.m_History.getNameAtIndex(n);
                        ClustererPanel.this.visualizeClusterer(string, mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        ClustererPanel.this.visualizeClusterer(null, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(LocalString.get("Clusterer")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.m_CLPanel, "North");
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(LocalString.get("Cluster mode")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.m_TrainBut, gridBagConstraints);
        jPanel2.add(this.m_TrainBut);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.m_TestSplitBut, gridBagConstraints);
        jPanel2.add(this.m_TestSplitBut);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 10, 2, 0);
        gridBagLayout.setConstraints(this.m_SetTestBut, gridBagConstraints);
        jPanel2.add(this.m_SetTestBut);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.m_PercentBut, gridBagConstraints);
        jPanel2.add(this.m_PercentBut);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagLayout.setConstraints(this.m_PercentLab, gridBagConstraints);
        jPanel2.add(this.m_PercentLab);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.ipadx = 20;
        gridBagLayout.setConstraints(this.m_PercentText, gridBagConstraints);
        jPanel2.add(this.m_PercentText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.m_ClassesToClustersBut, gridBagConstraints);
        jPanel2.add(this.m_ClassesToClustersBut);
        this.m_ClassCombo.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.m_ClassCombo, gridBagConstraints);
        jPanel2.add(this.m_ClassCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.m_StorePredictionsBut, gridBagConstraints);
        jPanel2.add(this.m_StorePredictionsBut);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel4.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel4.add(this.m_StartBut);
        jPanel4.add(this.m_StopBut);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel5.setLayout(new GridLayout(1, 1, 5, 5));
        jPanel5.add(this.m_ignoreBut);
        jPanel3.add(jPanel5);
        jPanel3.add(jPanel4);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createTitledBorder(LocalString.get("Clusterer output")));
        jPanel6.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.m_OutText);
        jPanel6.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            public void stateChanged(ChangeEvent changeEvent) {
                JViewport jViewport = (JViewport)changeEvent.getSource();
                int n = jViewport.getViewSize().height;
                if (n != this.lastHeight) {
                    this.lastHeight = n;
                    int n2 = n - jViewport.getExtentSize().height;
                    jViewport.setViewPosition(new Point(0, n2));
                }
            }
        });
        JPanel jPanel7 = new JPanel();
        gridBagLayout = new GridBagLayout();
        jPanel7.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel7.add(jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel7.add(jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.m_History, gridBagConstraints);
        jPanel7.add(this.m_History);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        jPanel7.add(jPanel6);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel7, "Center");
    }

    protected void updateRadioLinks() {
        this.m_SetTestBut.setEnabled(this.m_TestSplitBut.isSelected());
        if (this.m_SetTestFrame != null && !this.m_TestSplitBut.isSelected()) {
            this.m_SetTestFrame.setVisible(false);
        }
        this.m_PercentText.setEnabled(this.m_PercentBut.isSelected());
        this.m_PercentLab.setEnabled(this.m_PercentBut.isSelected());
        this.m_ClassCombo.setEnabled(this.m_ClassesToClustersBut.isSelected());
    }

    public void setLog(Logger logger) {
        this.m_Log = logger;
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
        this.m_ignoreKeyModel.removeAllElements();
        String[] stringArray = new String[this.m_Instances.numAttributes()];
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            String string = this.m_Instances.attribute(i).name();
            this.m_ignoreKeyModel.addElement(string);
            String string2 = "";
            switch (this.m_Instances.attribute(i).type()) {
                case 1: {
                    string2 = LocalString.get("(Nom) ");
                    break;
                }
                case 0: {
                    string2 = LocalString.get("(Num) ");
                    break;
                }
                case 2: {
                    string2 = LocalString.get("(Str) ");
                    break;
                }
                default: {
                    string2 = "(???) ";
                }
            }
            String string3 = this.m_Instances.attribute(i).name();
            stringArray[i] = string2 + string3;
        }
        this.m_StartBut.setEnabled(this.m_RunThread == null);
        this.m_StopBut.setEnabled(this.m_RunThread != null);
        this.m_ignoreBut.setEnabled(true);
        this.m_ClassCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.m_ClassCombo.setSelectedIndex(stringArray.length - 1);
        this.updateRadioLinks();
    }

    protected void setTestSet() {
        if (this.m_SetTestFrame == null) {
            final SetInstancesPanel setInstancesPanel = new SetInstancesPanel();
            this.m_Summary = setInstancesPanel.getSummary();
            if (this.m_TestInstances != null) {
                setInstancesPanel.setInstances(this.m_TestInstances);
            }
            setInstancesPanel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ClustererPanel.this.m_TestInstances = setInstancesPanel.getInstances();
                }
            });
            this.m_SetTestFrame = new JFrame(LocalString.get("Test Instances"));
            this.m_SetTestFrame.getContentPane().setLayout(new BorderLayout());
            this.m_SetTestFrame.getContentPane().add((Component)setInstancesPanel, "Center");
            this.m_SetTestFrame.pack();
        }
        this.m_SetTestFrame.setVisible(true);
    }

    public static PlotData2D setUpVisualizableInstances(Instances instances, ClusterEvaluation clusterEvaluation) throws Exception {
        int n;
        int n2;
        int n3 = clusterEvaluation.getNumClusters();
        double[] dArray = clusterEvaluation.getClusterAssignments();
        FastVector fastVector = new FastVector();
        FastVector fastVector2 = new FastVector();
        for (n2 = 0; n2 < n3; ++n2) {
            fastVector2.addElement(LocalString.get("cluster") + n2);
        }
        Attribute attribute = new Attribute(LocalString.get("Cluster"), fastVector2);
        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
            fastVector.addElement(instances.attribute(n2).copy());
        }
        fastVector.addElement(attribute);
        Instances instances2 = new Instances(instances.relationName() + LocalString.get("_clustered"), fastVector, instances.numInstances());
        int[] nArray = null;
        int[] nArray2 = null;
        if (instances.classIndex() >= 0) {
            nArray2 = clusterEvaluation.getClassesToClusters();
            nArray = new int[instances.numInstances()];
            for (n = 0; n < instances.numInstances(); ++n) {
                nArray[n] = -1;
            }
        }
        for (n = 0; n < instances.numInstances(); ++n) {
            double[] dArray2 = new double[instances2.numAttributes()];
            for (int i = 0; i < instances.numAttributes(); ++i) {
                dArray2[i] = instances.instance(n).value(i);
            }
            dArray2[i] = dArray[n];
            instances2.add(new Instance(1.0, dArray2));
            if (nArray == null || (int)instances.instance(n).classValue() == nArray2[(int)dArray[n]]) continue;
            nArray[n] = 1000;
        }
        PlotData2D plotData2D = new PlotData2D(instances2);
        if (nArray != null) {
            plotData2D.setShapeType(nArray);
        }
        plotData2D.addInstanceNumberAttribute();
        return plotData2D;
    }

    protected void startClusterer() {
        if (this.m_RunThread == null) {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(true);
            this.m_ignoreBut.setEnabled(false);
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block74: {
                        String string;
                        String string2;
                        Clusterer clusterer;
                        Object[] objectArray;
                        String string3;
                        boolean bl;
                        PlotData2D plotData2D;
                        Instances instances;
                        block71: {
                            int n;
                            Object object;
                            ClustererPanel.this.m_Log.statusMessage(LocalString.get("Setting up..."));
                            instances = new Instances(ClustererPanel.this.m_Instances);
                            instances.setClassIndex(-1);
                            Instances instances2 = null;
                            plotData2D = null;
                            if (ClustererPanel.this.m_TestInstances != null) {
                                instances2 = new Instances(ClustererPanel.this.m_TestInstances);
                            }
                            bl = ClustererPanel.this.m_StorePredictionsBut.isSelected();
                            string3 = null;
                            objectArray = null;
                            int n2 = 0;
                            int n3 = 66;
                            Clusterer clusterer2 = (Clusterer)ClustererPanel.this.m_ClustererEditor.getValue();
                            clusterer = null;
                            StringBuffer stringBuffer = new StringBuffer();
                            string2 = new SimpleDateFormat(LocalString.get("HH:mm:ss - ")).format(new Date());
                            string = clusterer2.getClass().getName();
                            string2 = string.startsWith("weka.clusterers.") ? string2 + string.substring("weka.clusterers.".length()) : string2 + string;
                            ClustererPanel.this.m_Log.logMessage(LocalString.get("Started ") + string);
                            if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskStarted();
                            }
                            if (ClustererPanel.this.m_PercentBut.isSelected()) {
                                n2 = 2;
                                n3 = Integer.parseInt(ClustererPanel.this.m_PercentText.getText());
                                if (n3 <= 0 || n3 >= 100) {
                                    throw new Exception(LocalString.get("Percentage must be between 0 and 100"));
                                }
                            } else if (ClustererPanel.this.m_TrainBut.isSelected()) {
                                n2 = 3;
                            } else if (ClustererPanel.this.m_TestSplitBut.isSelected()) {
                                n2 = 4;
                                if (instances2 == null) {
                                    throw new Exception(LocalString.get("No user test set has been opened"));
                                }
                                if (!instances.equalHeaders(instances2)) {
                                    throw new Exception(LocalString.get("Train and test set are not compatible"));
                                }
                            } else if (ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                n2 = 5;
                            } else {
                                throw new Exception(LocalString.get("Unknown test mode"));
                            }
                            Instances instances3 = new Instances(instances);
                            if (ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                instances3.setClassIndex(ClustererPanel.this.m_ClassCombo.getSelectedIndex());
                                instances.setClassIndex(ClustererPanel.this.m_ClassCombo.getSelectedIndex());
                                if (instances.classAttribute().isNumeric()) {
                                    throw new Exception(LocalString.get("Class must be nominal for class based ") + LocalString.get("evaluation!"));
                                }
                            }
                            if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty()) {
                                instances3 = ClustererPanel.this.removeIgnoreCols(instances3);
                            }
                            stringBuffer.append(LocalString.get("=== Run information ===\n\n"));
                            stringBuffer.append(LocalString.get("Scheme:       ") + string);
                            if (clusterer2 instanceof OptionHandler) {
                                object = ((OptionHandler)((Object)clusterer2)).getOptions();
                                stringBuffer.append(" " + Utils.joinOptions((String[])object));
                            }
                            stringBuffer.append("\n");
                            stringBuffer.append(LocalString.get("Relation:     ") + instances.relationName() + '\n');
                            stringBuffer.append(LocalString.get("Instances:    ") + instances.numInstances() + '\n');
                            stringBuffer.append(LocalString.get("Attributes:   ") + instances.numAttributes() + '\n');
                            if (instances.numAttributes() < 100) {
                                int n4;
                                object = new boolean[instances.numAttributes()];
                                for (n4 = 0; n4 < instances.numAttributes(); ++n4) {
                                    object[n4] = (String)true;
                                }
                                if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty()) {
                                    int[] nArray = ClustererPanel.this.m_ignoreKeyList.getSelectedIndices();
                                    for (n = 0; n < nArray.length; ++n) {
                                        object[nArray[n]] = (String)false;
                                    }
                                }
                                if (ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                    object[ClustererPanel.this.m_ClassCombo.getSelectedIndex()] = (String)false;
                                }
                                for (n4 = 0; n4 < instances.numAttributes(); ++n4) {
                                    if (object[n4] == false) continue;
                                    stringBuffer.append("              " + instances.attribute(n4).name() + '\n');
                                }
                                if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty() || ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                    stringBuffer.append("Ignored:\n");
                                    for (n4 = 0; n4 < instances.numAttributes(); ++n4) {
                                        if (object[n4] != false) continue;
                                        stringBuffer.append("              " + instances.attribute(n4).name() + '\n');
                                    }
                                }
                            } else {
                                stringBuffer.append(LocalString.get("              [list of attributes omitted]\n"));
                            }
                            if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty()) {
                                objectArray = ClustererPanel.this.m_ignoreKeyList.getSelectedIndices();
                            }
                            if (ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                if (objectArray == null) {
                                    objectArray = new int[]{ClustererPanel.this.m_ClassCombo.getSelectedIndex()};
                                } else {
                                    object = new int[objectArray.length + 1];
                                    System.arraycopy(objectArray, 0, object, 0, objectArray.length);
                                    object[objectArray.length] = (String)ClustererPanel.this.m_ClassCombo.getSelectedIndex();
                                    objectArray = (Object[])object;
                                }
                            }
                            stringBuffer.append(LocalString.get("Test mode:    "));
                            switch (n2) {
                                case 3: {
                                    stringBuffer.append(LocalString.get("evaluate on training data\n"));
                                    break;
                                }
                                case 2: {
                                    stringBuffer.append(LocalString.get("split ") + n3 + LocalString.get("% train, remainder test\n"));
                                    break;
                                }
                                case 4: {
                                    stringBuffer.append(LocalString.get("user supplied test set: ") + instances2.numInstances() + LocalString.get(" instances\n"));
                                    break;
                                }
                                case 5: {
                                    stringBuffer.append(LocalString.get("Classes to clusters evaluation on training data"));
                                }
                            }
                            stringBuffer.append("\n");
                            ClustererPanel.this.m_History.addResult(string2, stringBuffer);
                            ClustererPanel.this.m_History.setSingle(string2);
                            ClustererPanel.this.m_Log.statusMessage(LocalString.get("Building model on training data..."));
                            clusterer2.buildClusterer(ClustererPanel.this.removeClass(instances3));
                            if (n2 == 2) {
                                stringBuffer.append(LocalString.get("\n=== Clustering model (full training set) ===\n\n"));
                                stringBuffer.append(clusterer2.toString() + '\n');
                            }
                            ClustererPanel.this.m_History.updateResult(string2);
                            if (clusterer2 instanceof Drawable) {
                                try {
                                    string3 = ((Drawable)((Object)clusterer2)).graph();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            object = new SerializedObject(clusterer2);
                            clusterer = (Clusterer)((SerializedObject)object).getObject();
                            ClusterEvaluation clusterEvaluation = new ClusterEvaluation();
                            clusterEvaluation.setClusterer(clusterer2);
                            switch (n2) {
                                case 3: 
                                case 5: {
                                    ClustererPanel.this.m_Log.statusMessage(LocalString.get("Clustering training data..."));
                                    clusterEvaluation.evaluateClusterer(instances3);
                                    plotData2D = ClustererPanel.setUpVisualizableInstances(instances, clusterEvaluation);
                                    stringBuffer.append(LocalString.get("=== Model and evaluation on training set ===\n\n"));
                                    break;
                                }
                                case 2: {
                                    ClustererPanel.this.m_Log.statusMessage(LocalString.get("Randomizing instances..."));
                                    instances.randomize(new Random(1L));
                                    instances3.randomize(new Random(1L));
                                    n = instances3.numInstances() * n3 / 100;
                                    int n5 = instances3.numInstances() - n;
                                    Instances instances4 = new Instances(instances3, 0, n);
                                    Instances instances5 = new Instances(instances3, n, n5);
                                    Instances instances6 = new Instances(instances, n, n5);
                                    ClustererPanel.this.m_Log.statusMessage(LocalString.get("Building model on training split..."));
                                    clusterer2.buildClusterer(instances4);
                                    ClustererPanel.this.m_Log.statusMessage(LocalString.get("Evaluating on test split..."));
                                    clusterEvaluation.evaluateClusterer(instances5);
                                    plotData2D = ClustererPanel.setUpVisualizableInstances(instances6, clusterEvaluation);
                                    stringBuffer.append(LocalString.get("=== Model and evaluation on test split ===\n"));
                                    break;
                                }
                                case 4: {
                                    ClustererPanel.this.m_Log.statusMessage(LocalString.get("Evaluating on test data..."));
                                    Instances instances7 = new Instances(instances2);
                                    if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty()) {
                                        instances7 = ClustererPanel.this.removeIgnoreCols(instances7);
                                    }
                                    clusterEvaluation.evaluateClusterer(instances7);
                                    plotData2D = ClustererPanel.setUpVisualizableInstances(instances2, clusterEvaluation);
                                    stringBuffer.append(LocalString.get("=== Model and evaluation on test set ===\n"));
                                    break;
                                }
                                default: {
                                    throw new Exception(LocalString.get("Test mode not implemented"));
                                }
                            }
                            stringBuffer.append(clusterEvaluation.clusterResultsToString());
                            stringBuffer.append("\n");
                            ClustererPanel.this.m_History.updateResult(string2);
                            ClustererPanel.this.m_Log.logMessage(LocalString.get("Finished ") + string);
                            ClustererPanel.this.m_Log.statusMessage("OK");
                            Object var24_27 = null;
                            if (plotData2D == null) break block71;
                            ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                            ClustererPanel.this.m_CurrentVis.setName(string2 + " (" + instances.relationName() + ")");
                            ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                            plotData2D.setPlotName(string2 + " (" + instances.relationName() + ")");
                            try {
                                ClustererPanel.this.m_CurrentVis.addPlot(plotData2D);
                            }
                            catch (Exception serializable) {
                                System.err.println(serializable);
                            }
                            serializable = new FastVector();
                            ((FastVector)serializable).addElement(clusterer);
                            Instances instances8 = new Instances(ClustererPanel.this.m_Instances, 0);
                            ((FastVector)serializable).addElement(instances8);
                            if (objectArray != null) {
                                ((FastVector)serializable).addElement(objectArray);
                            }
                            if (bl) {
                                ((FastVector)serializable).addElement(ClustererPanel.this.m_CurrentVis);
                                if (string3 != null) {
                                    ((FastVector)serializable).addElement(string3);
                                }
                            }
                            ClustererPanel.this.m_History.addObject(string2, serializable);
                        }
                        if (this.isInterrupted()) {
                            ClustererPanel.this.m_Log.logMessage(LocalString.get("Interrupted ") + string);
                            ClustererPanel.this.m_Log.statusMessage(LocalString.get("See error log"));
                        }
                        ClustererPanel.this.m_RunThread = null;
                        ClustererPanel.this.m_StartBut.setEnabled(true);
                        ClustererPanel.this.m_StopBut.setEnabled(false);
                        ClustererPanel.this.m_ignoreBut.setEnabled(true);
                        if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                        }
                        break block74;
                        {
                            catch (Exception exception) {
                                exception.printStackTrace();
                                ClustererPanel.this.m_Log.logMessage(exception.getMessage());
                                JOptionPane.showMessageDialog(ClustererPanel.this, LocalString.get("Problem evaluating clusterer:\n") + exception.getMessage(), LocalString.get("Evaluate clusterer"), 0);
                                ClustererPanel.this.m_Log.statusMessage(LocalString.get("Problem evaluating clusterer"));
                                Object var24_28 = null;
                                if (plotData2D != null) {
                                    ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                                    ClustererPanel.this.m_CurrentVis.setName(string2 + " (" + instances.relationName() + ")");
                                    ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                                    plotData2D.setPlotName(string2 + " (" + instances.relationName() + ")");
                                    try {
                                        ClustererPanel.this.m_CurrentVis.addPlot(plotData2D);
                                    }
                                    catch (Exception serializable) {
                                        System.err.println(serializable);
                                    }
                                    serializable = new FastVector();
                                    ((FastVector)serializable).addElement(clusterer);
                                    Instances instances9 = new Instances(ClustererPanel.this.m_Instances, 0);
                                    ((FastVector)serializable).addElement(instances9);
                                    if (objectArray != null) {
                                        ((FastVector)serializable).addElement(objectArray);
                                    }
                                    if (bl) {
                                        ((FastVector)serializable).addElement(ClustererPanel.this.m_CurrentVis);
                                        if (string3 != null) {
                                            ((FastVector)serializable).addElement(string3);
                                        }
                                    }
                                    ClustererPanel.this.m_History.addObject(string2, serializable);
                                }
                                if (this.isInterrupted()) {
                                    ClustererPanel.this.m_Log.logMessage(LocalString.get("Interrupted ") + string);
                                    ClustererPanel.this.m_Log.statusMessage(LocalString.get("See error log"));
                                }
                                ClustererPanel.this.m_RunThread = null;
                                ClustererPanel.this.m_StartBut.setEnabled(true);
                                ClustererPanel.this.m_StopBut.setEnabled(false);
                                ClustererPanel.this.m_ignoreBut.setEnabled(true);
                                if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                                    ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var24_29 = null;
                            if (plotData2D != null) {
                                ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                                ClustererPanel.this.m_CurrentVis.setName(string2 + " (" + instances.relationName() + ")");
                                ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                                plotData2D.setPlotName(string2 + " (" + instances.relationName() + ")");
                                try {
                                    ClustererPanel.this.m_CurrentVis.addPlot(plotData2D);
                                }
                                catch (Exception serializable) {
                                    System.err.println(serializable);
                                }
                                serializable = new FastVector();
                                ((FastVector)serializable).addElement(clusterer);
                                Instances instances10 = new Instances(ClustererPanel.this.m_Instances, 0);
                                ((FastVector)serializable).addElement(instances10);
                                if (objectArray != null) {
                                    ((FastVector)serializable).addElement(objectArray);
                                }
                                if (bl) {
                                    ((FastVector)serializable).addElement(ClustererPanel.this.m_CurrentVis);
                                    if (string3 != null) {
                                        ((FastVector)serializable).addElement(string3);
                                    }
                                }
                                ClustererPanel.this.m_History.addObject(string2, serializable);
                            }
                            if (this.isInterrupted()) {
                                ClustererPanel.this.m_Log.logMessage(LocalString.get("Interrupted ") + string);
                                ClustererPanel.this.m_Log.statusMessage(LocalString.get("See error log"));
                            }
                            ClustererPanel.this.m_RunThread = null;
                            ClustererPanel.this.m_StartBut.setEnabled(true);
                            ClustererPanel.this.m_StopBut.setEnabled(false);
                            ClustererPanel.this.m_ignoreBut.setEnabled(true);
                            if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                            }
                            throw throwable;
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    private Instances removeClass(Instances instances) {
        Remove remove = new Remove();
        Instances instances2 = null;
        try {
            if (instances.classIndex() < 0) {
                instances2 = instances;
            } else {
                remove.setAttributeIndices("" + (instances.classIndex() + 1));
                remove.setInvertSelection(false);
                remove.setInputFormat(instances);
                instances2 = Filter.useFilter(instances, remove);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return instances2;
    }

    private Instances removeIgnoreCols(Instances instances) {
        int n;
        if (this.m_ClassesToClustersBut.isSelected() && this.m_ignoreKeyList.isSelectedIndex(n = this.m_ClassCombo.getSelectedIndex())) {
            this.m_ignoreKeyList.removeSelectionInterval(n, n);
        }
        int[] nArray = this.m_ignoreKeyList.getSelectedIndices();
        Remove remove = new Remove();
        Instances instances2 = null;
        try {
            remove.setAttributeIndicesArray(nArray);
            remove.setInvertSelection(false);
            remove.setInputFormat(instances);
            instances2 = Filter.useFilter(instances, remove);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return instances2;
    }

    private Instances removeIgnoreCols(Instances instances, int[] nArray) {
        Remove remove = new Remove();
        Instances instances2 = null;
        try {
            remove.setAttributeIndicesArray(nArray);
            remove.setInvertSelection(false);
            remove.setInputFormat(instances);
            instances2 = Filter.useFilter(instances, remove);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return instances2;
    }

    protected void stopClusterer() {
        if (this.m_RunThread != null) {
            this.m_RunThread.interrupt();
            this.m_RunThread.stop();
        }
    }

    protected void visualizeTree(String string, String string2) {
        final JFrame jFrame = new JFrame(LocalString.get("Weka Classifier Tree Visualizer: ") + string2);
        jFrame.setSize(500, 400);
        jFrame.getContentPane().setLayout(new BorderLayout());
        TreeVisualizer treeVisualizer = new TreeVisualizer(null, string, (NodePlace)new PlaceNode2());
        jFrame.getContentPane().add((Component)treeVisualizer, "Center");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jFrame.dispose();
            }
        });
        jFrame.setVisible(true);
        treeVisualizer.fitToScreen();
    }

    protected void visualizeClusterAssignments(VisualizePanel visualizePanel) {
        if (visualizePanel != null) {
            String string = visualizePanel.getName();
            final JFrame jFrame = new JFrame(LocalString.get("Weka Clusterer Visualize: ") + string);
            jFrame.setSize(500, 400);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)visualizePanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                }
            });
            jFrame.setVisible(true);
        }
    }

    protected void visualizeClusterer(String string, int n, int n2) {
        Object object;
        final String string2 = string;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(LocalString.get("View in main window"));
        if (string2 != null) {
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClustererPanel.this.m_History.setSingle(string2);
                }
            });
        } else {
            jMenuItem.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(LocalString.get("View in separate window"));
        if (string2 != null) {
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClustererPanel.this.m_History.openFrame(string2);
                }
            });
        } else {
            jMenuItem2.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(LocalString.get("Save result buffer"));
        if (string2 != null) {
            jMenuItem3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClustererPanel.this.saveBuffer(string2);
                }
            });
        } else {
            jMenuItem3.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem(LocalString.get("Load model"));
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClustererPanel.this.loadClusterer();
            }
        });
        jPopupMenu.add(jMenuItem4);
        FastVector fastVector = null;
        if (string2 != null) {
            fastVector = (FastVector)this.m_History.getNamedObject(string2);
        }
        VisualizePanel visualizePanel = null;
        Object object2 = null;
        Clusterer clusterer = null;
        Instances instances = null;
        int[] nArray = null;
        if (fastVector != null) {
            for (int i = 0; i < fastVector.size(); ++i) {
                object = fastVector.elementAt(i);
                if (object instanceof Clusterer) {
                    clusterer = (Clusterer)object;
                    continue;
                }
                if (object instanceof Instances) {
                    instances = (Instances)object;
                    continue;
                }
                if (object instanceof int[]) {
                    nArray = (int[])object;
                    continue;
                }
                if (object instanceof VisualizePanel) {
                    visualizePanel = (VisualizePanel)object;
                    continue;
                }
                if (!(object instanceof String)) continue;
                object2 = (String)object;
            }
        }
        final VisualizePanel visualizePanel2 = visualizePanel;
        object = object2;
        final Clusterer clusterer2 = clusterer;
        final Instances instances2 = instances;
        final int[] nArray2 = nArray;
        JMenuItem jMenuItem5 = new JMenuItem(LocalString.get("Save model"));
        if (clusterer2 != null) {
            jMenuItem5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClustererPanel.this.saveClusterer(string2, clusterer2, instances2, nArray2);
                }
            });
        } else {
            jMenuItem5.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem(LocalString.get("Re-evaluate model on current test set"));
        if (clusterer2 != null && this.m_TestInstances != null) {
            jMenuItem6.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClustererPanel.this.reevaluateModel(string2, clusterer2, instances2, nArray2);
                }
            });
        } else {
            jMenuItem6.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem6);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem7 = new JMenuItem(LocalString.get("Visualize cluster assignments"));
        if (visualizePanel2 != null) {
            jMenuItem7.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClustererPanel.this.visualizeClusterAssignments(visualizePanel2);
                }
            });
        } else {
            jMenuItem7.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem(LocalString.get("Visualize tree"));
        if (object != null) {
            jMenuItem8.addActionListener(new ActionListener((String)object){
                private final /* synthetic */ String val$grph;
                {
                    this.val$grph = string22;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = visualizePanel2 != null ? visualizePanel2.getName() : string2;
                    ClustererPanel.this.visualizeTree(this.val$grph, string);
                }
            });
        } else {
            jMenuItem8.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem8);
        jPopupMenu.show(this.m_History.getList(), n, n2);
    }

    protected void saveBuffer(String string) {
        StringBuffer stringBuffer = this.m_History.getNamedBuffer(string);
        if (stringBuffer != null && this.m_SaveOut.save(stringBuffer)) {
            this.m_Log.logMessage(LocalString.get("Save successful."));
        }
    }

    private void setIgnoreColumns() {
        ListSelectorDialog listSelectorDialog = new ListSelectorDialog(null, this.m_ignoreKeyList);
        int n = listSelectorDialog.showDialog();
        if (n != 0) {
            this.m_ignoreKeyList.clearSelection();
        }
    }

    protected void saveClusterer(String string, Clusterer clusterer, Instances instances, int[] nArray) {
        File file = null;
        boolean bl = true;
        int n = this.m_FileChooser.showSaveDialog(this);
        if (n == 0) {
            file = this.m_FileChooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(MODEL_FILE_EXTENSION)) {
                file = new File(file.getParent(), file.getName() + MODEL_FILE_EXTENSION);
            }
            this.m_Log.statusMessage(LocalString.get("Saving model to file..."));
            try {
                OutputStream outputStream = new FileOutputStream(file);
                if (file.getName().endsWith(".gz")) {
                    outputStream = new GZIPOutputStream(outputStream);
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(clusterer);
                if (instances != null) {
                    objectOutputStream.writeObject(instances);
                }
                if (nArray != null) {
                    objectOutputStream.writeObject(nArray);
                }
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, exception, LocalString.get("Save Failed"), 0);
                bl = false;
            }
            if (bl) {
                this.m_Log.logMessage(LocalString.get("Saved model (") + string + LocalString.get(") to file '") + file.getName() + "'");
            }
            this.m_Log.statusMessage("OK");
        }
    }

    protected void loadClusterer() {
        int n = this.m_FileChooser.showOpenDialog(this);
        if (n == 0) {
            Object object;
            Object object2;
            File file = this.m_FileChooser.getSelectedFile();
            Clusterer clusterer = null;
            Instances instances = null;
            int[] nArray = null;
            this.m_Log.statusMessage(LocalString.get("Loading model from file..."));
            try {
                object2 = new FileInputStream(file);
                if (file.getName().endsWith(".gz")) {
                    object2 = new GZIPInputStream((InputStream)object2);
                }
                object = new ObjectInputStream((InputStream)object2);
                clusterer = (Clusterer)((ObjectInputStream)object).readObject();
                try {
                    instances = (Instances)((ObjectInputStream)object).readObject();
                    nArray = (int[])((ObjectInputStream)object).readObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((ObjectInputStream)object).close();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, exception, LocalString.get("Load Failed"), 0);
            }
            this.m_Log.statusMessage("OK");
            if (clusterer != null) {
                Object object3;
                this.m_Log.logMessage(LocalString.get("Loaded model from file '") + file.getName() + "'");
                object2 = new SimpleDateFormat(LocalString.get("HH:mm:ss - ")).format(new Date());
                object = clusterer.getClass().getName();
                if (((String)object).startsWith("weka.clusterers.")) {
                    object = ((String)object).substring("weka.clusterers.".length());
                }
                object2 = (String)object2 + (String)object + LocalString.get(" from file '") + file.getName() + "'";
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(LocalString.get("=== Model information ===\n\n"));
                stringBuffer.append(LocalString.get("Filename:     ") + file.getName() + "\n");
                stringBuffer.append(LocalString.get("Scheme:       ") + (String)object);
                if (clusterer instanceof OptionHandler) {
                    object3 = ((OptionHandler)((Object)clusterer)).getOptions();
                    stringBuffer.append(" " + Utils.joinOptions((String[])object3));
                }
                stringBuffer.append("\n");
                if (instances != null) {
                    stringBuffer.append(LocalString.get("Relation:     ") + instances.relationName() + '\n');
                    stringBuffer.append(LocalString.get("Attributes:   ") + instances.numAttributes() + '\n');
                    if (instances.numAttributes() < 100) {
                        int n2;
                        object3 = new boolean[instances.numAttributes()];
                        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
                            object3[n2] = true;
                        }
                        if (nArray != null) {
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                object3[nArray[n2]] = false;
                            }
                        }
                        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
                            if (object3[n2] == false) continue;
                            stringBuffer.append("              " + instances.attribute(n2).name() + '\n');
                        }
                        if (nArray != null) {
                            stringBuffer.append("Ignored:\n");
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                stringBuffer.append("              " + instances.attribute(nArray[n2]).name() + '\n');
                            }
                        }
                    } else {
                        stringBuffer.append(LocalString.get("              [list of attributes omitted]\n"));
                    }
                } else {
                    stringBuffer.append(LocalString.get("\nTraining data unknown\n"));
                }
                stringBuffer.append(LocalString.get("\n=== Clustering model ===\n\n"));
                stringBuffer.append(clusterer.toString() + "\n");
                this.m_History.addResult((String)object2, stringBuffer);
                this.m_History.setSingle((String)object2);
                object3 = new FastVector();
                ((FastVector)object3).addElement(clusterer);
                if (instances != null) {
                    ((FastVector)object3).addElement(instances);
                }
                if (nArray != null) {
                    ((FastVector)object3).addElement(nArray);
                }
                String string = null;
                if (clusterer instanceof Drawable) {
                    try {
                        string = ((Drawable)((Object)clusterer)).graph();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string != null) {
                    ((FastVector)object3).addElement(string);
                }
                this.m_History.addObject((String)object2, object3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void reevaluateModel(String string, Clusterer clusterer, Instances instances, int[] nArray) {
        block26: {
            StringBuffer stringBuffer = this.m_History.getNamedBuffer(string);
            Instances instances2 = null;
            PlotData2D plotData2D = null;
            if (this.m_TestInstances != null) {
                instances2 = new Instances(this.m_TestInstances);
            }
            boolean bl = this.m_StorePredictionsBut.isSelected();
            Object var9_9 = null;
            if (instances2 == null) {
                throw new Exception(LocalString.get("No user test set has been opened"));
            }
            if (instances != null && !instances.equalHeaders(instances2)) {
                throw new Exception(LocalString.get("Train and test set are not compatible"));
            }
            this.m_Log.statusMessage(LocalString.get("Evaluating on test data..."));
            this.m_Log.logMessage(LocalString.get("Re-evaluating clusterer (") + string + LocalString.get(") on test set"));
            ClusterEvaluation clusterEvaluation = new ClusterEvaluation();
            clusterEvaluation.setClusterer(clusterer);
            Instances instances3 = new Instances(instances2);
            if (nArray != null) {
                instances3 = this.removeIgnoreCols(instances3, nArray);
            }
            clusterEvaluation.evaluateClusterer(instances3);
            plotData2D = ClustererPanel.setUpVisualizableInstances(instances2, clusterEvaluation);
            stringBuffer.append(LocalString.get("\n=== Re-evaluation on test set ===\n\n"));
            stringBuffer.append(LocalString.get("User supplied test set\n"));
            stringBuffer.append(LocalString.get("Relation:     ") + instances2.relationName() + '\n');
            stringBuffer.append(LocalString.get("Instances:    ") + instances2.numInstances() + '\n');
            stringBuffer.append(LocalString.get("Attributes:   ") + instances2.numAttributes() + "\n\n");
            if (instances == null) {
                stringBuffer.append(LocalString.get("NOTE - if test set is not compatible then results are ") + LocalString.get("unpredictable\n\n"));
            }
            stringBuffer.append(clusterEvaluation.clusterResultsToString());
            stringBuffer.append("\n");
            this.m_History.updateResult(string);
            this.m_Log.logMessage(LocalString.get("Finished re-evaluation"));
            this.m_Log.statusMessage("OK");
            Object var13_13 = null;
            if (plotData2D == null) break block26;
            this.m_CurrentVis = new VisualizePanel();
            this.m_CurrentVis.setName(string + " (" + instances2.relationName() + ")");
            this.m_CurrentVis.setLog(this.m_Log);
            plotData2D.setPlotName(string + " (" + instances2.relationName() + ")");
            try {
                this.m_CurrentVis.addPlot(plotData2D);
            }
            catch (Exception serializable) {
                System.err.println(serializable);
            }
            serializable = new FastVector();
            ((FastVector)serializable).addElement(clusterer);
            if (instances != null) {
                ((FastVector)serializable).addElement(instances);
            }
            if (nArray != null) {
                ((FastVector)serializable).addElement(nArray);
            }
            if (bl) {
                ((FastVector)serializable).addElement(this.m_CurrentVis);
                if (var9_9 != null) {
                    ((FastVector)serializable).addElement(var9_9);
                }
            }
            this.m_History.addObject(string, serializable);
            {
                break block26;
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.m_Log.logMessage(exception.getMessage());
                    JOptionPane.showMessageDialog(this, LocalString.get("Problem evaluating clusterer:\n") + exception.getMessage(), LocalString.get("Evaluate clusterer"), 0);
                    this.m_Log.statusMessage(LocalString.get("Problem evaluating clusterer"));
                    Object var13_14 = null;
                    if (plotData2D == null) break block26;
                    this.m_CurrentVis = new VisualizePanel();
                    this.m_CurrentVis.setName(string + " (" + instances2.relationName() + ")");
                    this.m_CurrentVis.setLog(this.m_Log);
                    plotData2D.setPlotName(string + " (" + instances2.relationName() + ")");
                    try {
                        this.m_CurrentVis.addPlot(plotData2D);
                    }
                    catch (Exception serializable) {
                        System.err.println(serializable);
                    }
                    serializable = new FastVector();
                    ((FastVector)serializable).addElement(clusterer);
                    if (instances != null) {
                        ((FastVector)serializable).addElement(instances);
                    }
                    if (nArray != null) {
                        ((FastVector)serializable).addElement(nArray);
                    }
                    if (bl) {
                        ((FastVector)serializable).addElement(this.m_CurrentVis);
                        if (var9_9 != null) {
                            ((FastVector)serializable).addElement(var9_9);
                        }
                    }
                    this.m_History.addObject(string, serializable);
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (plotData2D != null) {
                    this.m_CurrentVis = new VisualizePanel();
                    this.m_CurrentVis.setName(string + " (" + instances2.relationName() + ")");
                    this.m_CurrentVis.setLog(this.m_Log);
                    plotData2D.setPlotName(string + " (" + instances2.relationName() + ")");
                    try {
                        this.m_CurrentVis.addPlot(plotData2D);
                    }
                    catch (Exception serializable) {
                        System.err.println(serializable);
                    }
                    serializable = new FastVector();
                    ((FastVector)serializable).addElement(clusterer);
                    if (instances != null) {
                        ((FastVector)serializable).addElement(instances);
                    }
                    if (nArray != null) {
                        ((FastVector)serializable).addElement(nArray);
                    }
                    if (bl) {
                        ((FastVector)serializable).addElement(this.m_CurrentVis);
                        if (var9_9 != null) {
                            ((FastVector)serializable).addElement(var9_9);
                        }
                    }
                    this.m_History.addObject(string, serializable);
                }
                throw throwable;
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame(LocalString.get("Weka Explorer: Cluster"));
            jFrame.getContentPane().setLayout(new BorderLayout());
            ClustererPanel clustererPanel = new ClustererPanel();
            jFrame.getContentPane().add((Component)clustererPanel, "Center");
            LogPanel logPanel = new LogPanel();
            clustererPanel.setLog(logPanel);
            jFrame.getContentPane().add((Component)logPanel, "South");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
            if (stringArray.length == 1) {
                System.err.println(LocalString.get("Loading instances from ") + stringArray[0]);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
                Instances instances = new Instances(bufferedReader);
                clustererPanel.setInstances(instances);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        PropertyEditorManager.registerEditor(class$weka$core$SelectedTag == null ? (class$weka$core$SelectedTag = ClustererPanel.class$("weka.core.SelectedTag")) : class$weka$core$SelectedTag, class$weka$gui$SelectedTagEditor == null ? (class$weka$gui$SelectedTagEditor = ClustererPanel.class$("weka.gui.SelectedTagEditor")) : class$weka$gui$SelectedTagEditor);
        PropertyEditorManager.registerEditor(class$weka$clusterers$Clusterer == null ? (class$weka$clusterers$Clusterer = ClustererPanel.class$("weka.clusterers.Clusterer")) : class$weka$clusterers$Clusterer, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = ClustererPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(class$weka$clusterers$DensityBasedClusterer == null ? (class$weka$clusterers$DensityBasedClusterer = ClustererPanel.class$("weka.clusterers.DensityBasedClusterer")) : class$weka$clusterers$DensityBasedClusterer, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = ClustererPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(class$weka$attributeSelection$UnsupervisedSubsetEvaluator == null ? (class$weka$attributeSelection$UnsupervisedSubsetEvaluator = ClustererPanel.class$("weka.attributeSelection.UnsupervisedSubsetEvaluator")) : class$weka$attributeSelection$UnsupervisedSubsetEvaluator, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = ClustererPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
    }
}

