/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import weka.LocalString;
import weka.experiment.RemoteExperiment;

public class HostListPanel
extends JPanel
implements ActionListener {
    protected RemoteExperiment m_Exp;
    protected JList m_List;
    protected JButton m_DeleteBut = new JButton(LocalString.get("Delete selected"));
    protected JTextField m_HostField = new JTextField(25);

    public HostListPanel(RemoteExperiment remoteExperiment) {
        this();
        this.setExperiment(remoteExperiment);
    }

    public HostListPanel() {
        this.m_List = new JList();
        this.m_List.setModel(new DefaultListModel());
        this.m_DeleteBut.setEnabled(false);
        this.m_DeleteBut.addActionListener(this);
        this.m_HostField.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(LocalString.get("Hosts")));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel.add((Component)this.m_DeleteBut, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.m_HostField, gridBagConstraints);
        this.add((Component)jPanel, "North");
        this.add((Component)new JScrollPane(this.m_List), "Center");
    }

    public void setExperiment(RemoteExperiment remoteExperiment) {
        this.m_Exp = remoteExperiment;
        this.m_List.setModel(this.m_Exp.getRemoteHosts());
        if (((DefaultListModel)this.m_List.getModel()).size() > 0) {
            this.m_DeleteBut.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_HostField) {
            ((DefaultListModel)this.m_List.getModel()).addElement(this.m_HostField.getText());
            this.m_DeleteBut.setEnabled(true);
        } else if (actionEvent.getSource() == this.m_DeleteBut) {
            int[] nArray = this.m_List.getSelectedIndices();
            if (nArray != null) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    int n = nArray[i];
                    ((DefaultListModel)this.m_List.getModel()).removeElementAt(n);
                    if (((DefaultListModel)this.m_List.getModel()).size() > n) {
                        this.m_List.setSelectedIndex(n);
                        continue;
                    }
                    this.m_List.setSelectedIndex(n - 1);
                }
            }
            if (((DefaultListModel)this.m_List.getModel()).size() == 0) {
                this.m_DeleteBut.setEnabled(false);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame(LocalString.get("Host List Editor"));
            jFrame.getContentPane().setLayout(new BorderLayout());
            HostListPanel hostListPanel = new HostListPanel();
            jFrame.getContentPane().add((Component)hostListPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

