/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import weka.LocalString;

public class JTableHelper {
    private JTable jtable;

    public JTableHelper(JTable jTable) {
        this.jtable = jTable;
    }

    public JTable getJTable() {
        return this.jtable;
    }

    public int calcColumnWidth(int n) {
        return JTableHelper.calcColumnWidth(this.getJTable(), n);
    }

    public static int calcColumnWidth(JTable jTable, int n) {
        int n2 = JTableHelper.calcHeaderWidth(jTable, n);
        if (n2 == -1) {
            return n2;
        }
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableModel tableModel = jTable.getModel();
        int n3 = tableModel.getRowCount();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        try {
            for (int i = n3 - 1; i >= 0; --i) {
                Component component = jTable.prepareRenderer(jTable.getCellRenderer(i, n), i, n);
                n2 = Math.max(n2, component.getPreferredSize().width + 10);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    public int calcHeaderWidth(int n) {
        return JTableHelper.calcHeaderWidth(this.getJTable(), n);
    }

    public static int calcHeaderWidth(JTable jTable, int n) {
        if (jTable == null) {
            return -1;
        }
        if (n < 0 || n > jTable.getColumnCount()) {
            System.out.println(LocalString.get("invalid col ") + n);
            return -1;
        }
        JTableHeader jTableHeader = jTable.getTableHeader();
        TableCellRenderer tableCellRenderer = null;
        if (jTableHeader != null) {
            tableCellRenderer = jTableHeader.getDefaultRenderer();
        }
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableModel tableModel = jTable.getModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        int n2 = -1;
        TableCellRenderer tableCellRenderer2 = tableColumn.getHeaderRenderer();
        if (tableCellRenderer2 == null) {
            tableCellRenderer2 = tableCellRenderer;
        }
        if (tableCellRenderer2 != null) {
            Component component = tableCellRenderer2.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, -1, n);
            n2 = component.getPreferredSize().width + 5;
        }
        return n2;
    }

    public void setOptimalColumnWidth(int n) {
        JTableHelper.setOptimalColumnWidth(this.getJTable(), n);
    }

    public static void setOptimalColumnWidth(JTable jTable, int n) {
        int n2;
        if (n >= 0 && n < jTable.getColumnModel().getColumnCount() && (n2 = JTableHelper.calcColumnWidth(jTable, n)) >= 0) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
            tableColumn.setPreferredWidth(n2);
            jTable.sizeColumnsToFit(-1);
            jTableHeader.repaint();
        }
    }

    public void setOptimalColumnWidth() {
        JTableHelper.setOptimalColumnWidth(this.getJTable());
    }

    public static void setOptimalColumnWidth(JTable jTable) {
        for (int i = 0; i < jTable.getColumnModel().getColumnCount(); ++i) {
            JTableHelper.setOptimalColumnWidth(jTable, i);
        }
    }

    public void setOptimalHeaderWidth(int n) {
        JTableHelper.setOptimalHeaderWidth(this.getJTable(), n);
    }

    public static void setOptimalHeaderWidth(JTable jTable, int n) {
        int n2;
        if (n >= 0 && n < jTable.getColumnModel().getColumnCount() && (n2 = JTableHelper.calcHeaderWidth(jTable, n)) >= 0) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
            tableColumn.setPreferredWidth(n2);
            jTable.sizeColumnsToFit(-1);
            jTableHeader.repaint();
        }
    }

    public void setOptimalHeaderWidth() {
        JTableHelper.setOptimalHeaderWidth(this.getJTable());
    }

    public static void setOptimalHeaderWidth(JTable jTable) {
        for (int i = 0; i < jTable.getColumnModel().getColumnCount(); ++i) {
            JTableHelper.setOptimalHeaderWidth(jTable, i);
        }
    }

    public void scrollToVisible(int n, int n2) {
        JTableHelper.scrollToVisible(this.getJTable(), n, n2);
    }

    public static void scrollToVisible(JTable jTable, int n, int n2) {
        if (!(jTable.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)jTable.getParent();
        Rectangle rectangle = jTable.getCellRect(n, n2, true);
        Point point = jViewport.getViewPosition();
        rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
        jViewport.scrollRectToVisible(rectangle);
    }
}

