/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.Remove;

public class RemoveType
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    protected Remove m_attributeFilter = new Remove();
    protected int m_attTypeToDelete = 2;
    protected boolean m_invert = false;
    public static final Tag[] TAGS_ATTRIBUTETYPE = new Tag[]{new Tag(1, LocalString.get("Delete nominal attributes")), new Tag(0, LocalString.get("Delete numeric attributes")), new Tag(2, LocalString.get("Delete string attributes")), new Tag(3, LocalString.get("Delete date attributes"))};

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        int[] nArray = new int[instances.numAttributes()];
        int n = 0;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (i == instances.classIndex() && !this.m_invert || instances.attribute(i).type() != this.m_attTypeToDelete) continue;
            nArray[n++] = i;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        this.m_attributeFilter.setAttributeIndicesArray(nArray2);
        this.m_attributeFilter.setInvertSelection(this.m_invert);
        boolean bl = this.m_attributeFilter.setInputFormat(instances);
        Instances instances2 = this.m_attributeFilter.getOutputFormat();
        instances2.setRelationName(instances.relationName());
        this.setOutputFormat(instances2);
        return bl;
    }

    public boolean input(Instance instance) {
        return this.m_attributeFilter.input(instance);
    }

    public boolean batchFinished() throws Exception {
        return this.m_attributeFilter.batchFinished();
    }

    public Instance output() {
        return this.m_attributeFilter.output();
    }

    public Instance outputPeek() {
        return this.m_attributeFilter.outputPeek();
    }

    public int numPendingOutput() {
        return this.m_attributeFilter.numPendingOutput();
    }

    public boolean isOutputFormatDefined() {
        return this.m_attributeFilter.isOutputFormatDefined();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option(LocalString.get("\tAttribute type to delete. Valid options are \"nominal\", ") + LocalString.get("\"numeric\", \"string\" and \"date\". (default \"string\")"), "T", 1, LocalString.get("-T <nominal|numeric|string|date>")));
        vector.addElement(new Option(LocalString.get("\tInvert matching sense (i.e. only keep specified columns)"), "V", 0, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('T', stringArray);
        if (string.length() != 0) {
            this.setAttributeTypeString(string);
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[3];
        int n = 0;
        if (this.getInvertSelection()) {
            stringArray[n++] = "-V";
        }
        stringArray[n++] = "-T";
        stringArray[n++] = this.getAttributeTypeString();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String globalInfo() {
        return LocalString.get("Removes attributes of a given type.");
    }

    public String attributeTypeTipText() {
        return LocalString.get("The type of attribute to remove.");
    }

    public void setAttributeType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_ATTRIBUTETYPE) {
            this.m_attTypeToDelete = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getAttributeType() {
        return new SelectedTag(this.m_attTypeToDelete, TAGS_ATTRIBUTETYPE);
    }

    public String invertSelectionTipText() {
        return LocalString.get("Determines whether action is to select or delete.") + LocalString.get(" If set to true, only the specified attributes will be kept;") + LocalString.get(" If set to false, specified attributes will be deleted.");
    }

    public boolean getInvertSelection() {
        return this.m_invert;
    }

    public void setInvertSelection(boolean bl) {
        this.m_invert = bl;
    }

    protected String getAttributeTypeString() {
        if (this.m_attTypeToDelete == 1) {
            return LocalString.get("nominal");
        }
        if (this.m_attTypeToDelete == 0) {
            return LocalString.get("numeric");
        }
        if (this.m_attTypeToDelete == 2) {
            return LocalString.get("string");
        }
        if (this.m_attTypeToDelete == 3) {
            return LocalString.get("date");
        }
        return LocalString.get("unknown");
    }

    protected void setAttributeTypeString(String string) {
        if ((string = string.toLowerCase()).equals(LocalString.get("nominal"))) {
            this.m_attTypeToDelete = 1;
        } else if (string.equals(LocalString.get("numeric"))) {
            this.m_attTypeToDelete = 0;
        } else if (string.equals(LocalString.get("string"))) {
            this.m_attTypeToDelete = 2;
        } else if (string.equals(LocalString.get("date"))) {
            this.m_attTypeToDelete = 3;
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new RemoveType(), stringArray);
            } else {
                Filter.filterFile(new RemoveType(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

