/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import weka.LocalString;
import weka.core.Utils;
import weka.core.matrix.Matrix;

public class LinearRegression {
    protected double[] m_Coefficients = null;

    public LinearRegression(Matrix matrix, Matrix matrix2, double d) {
        this.calculate(matrix, matrix2, d);
    }

    public LinearRegression(Matrix matrix, Matrix matrix2, double[] dArray, double d) {
        if (dArray.length != matrix.getRowDimension()) {
            throw new IllegalArgumentException(LocalString.get("Incorrect number of weights provided"));
        }
        Matrix matrix3 = new Matrix(matrix.getRowDimension(), matrix.getColumnDimension());
        Matrix matrix4 = new Matrix(matrix.getRowDimension(), 1);
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = Math.sqrt(dArray[i]);
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                matrix3.set(i, j, matrix.get(i, j) * d2);
            }
            matrix4.set(i, 0, matrix2.get(i, 0) * d2);
        }
        this.calculate(matrix3, matrix4, d);
    }

    protected void calculate(Matrix matrix, Matrix matrix2, double d) {
        if (matrix2.getColumnDimension() > 1) {
            throw new IllegalArgumentException(LocalString.get("Only one dependent variable allowed"));
        }
        int n = matrix.getColumnDimension();
        this.m_Coefficients = new double[n];
        Matrix matrix3 = matrix.transpose();
        boolean bl = true;
        do {
            int n2;
            Matrix matrix4 = matrix3.times(matrix);
            for (int i = 0; i < n; ++i) {
                matrix4.set(i, i, matrix4.get(i, i) + d);
            }
            Matrix matrix5 = matrix3.times(matrix2);
            for (n2 = 0; n2 < n; ++n2) {
                this.m_Coefficients[n2] = matrix5.get(n2, 0);
            }
            try {
                Matrix matrix6 = matrix4.solve(new Matrix(this.m_Coefficients, this.m_Coefficients.length));
                for (n2 = 0; n2 < n; ++n2) {
                    this.m_Coefficients[n2] = matrix6.get(n2, 0);
                }
                bl = true;
            }
            catch (Exception exception) {
                d *= 10.0;
                bl = false;
            }
        } while (!bl);
    }

    public final double[] getCoefficients() {
        return this.m_Coefficients;
    }

    public String toString() {
        return Utils.arrayToString(this.getCoefficients());
    }
}

