/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import weka.LocalString;
import weka.classifiers.trees.m5.Values;
import weka.core.Instances;

public final class Impurity {
    double n;
    int attr;
    double nl;
    double nr;
    double sl;
    double sr;
    double s2l;
    double s2r;
    double sdl;
    double sdr;
    double vl;
    double vr;
    double sd;
    double va;
    double impurity;
    int order;

    public Impurity(int n, int n2, Instances instances, int n3) {
        Values values = new Values(0, instances.numInstances() - 1, instances.classIndex(), instances);
        this.attr = n2;
        this.n = instances.numInstances();
        this.sd = values.sd;
        this.va = values.va;
        values = new Values(0, n, instances.classIndex(), instances);
        this.nl = n + 1;
        this.sl = values.sum;
        this.s2l = values.sqrSum;
        values = new Values(n + 1, instances.numInstances() - 1, instances.classIndex(), instances);
        this.nr = instances.numInstances() - n - 1;
        this.sr = values.sum;
        this.s2r = values.sqrSum;
        this.order = n3;
        this.incremental(0.0, 0);
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalString.get("Print impurity values:\n"));
        stringBuffer.append(LocalString.get("    Number of total instances:\t") + this.n + "\n");
        stringBuffer.append(LocalString.get("    Splitting attribute:\t\t") + this.attr + "\n");
        stringBuffer.append(LocalString.get("    Number of the instances in the left:\t") + this.nl + "\n");
        stringBuffer.append(LocalString.get("    Number of the instances in the right:\t") + this.nr + "\n");
        stringBuffer.append(LocalString.get("    Sum of the left:\t\t\t") + this.sl + "\n");
        stringBuffer.append(LocalString.get("    Sum of the right:\t\t\t") + this.sr + "\n");
        stringBuffer.append(LocalString.get("    Squared sum of the left:\t\t") + this.s2l + "\n");
        stringBuffer.append(LocalString.get("    Squared sum of the right:\t\t") + this.s2r + "\n");
        stringBuffer.append(LocalString.get("    Standard deviation of the left:\t") + this.sdl + "\n");
        stringBuffer.append(LocalString.get("    Standard deviation of the right:\t") + this.sdr + "\n");
        stringBuffer.append(LocalString.get("    Variance of the left:\t\t") + this.vr + "\n");
        stringBuffer.append(LocalString.get("    Variance of the right:\t\t") + this.vr + "\n");
        stringBuffer.append(LocalString.get("    Overall standard deviation:\t\t") + this.sd + "\n");
        stringBuffer.append(LocalString.get("    Overall variance:\t\t\t") + this.va + "\n");
        stringBuffer.append(LocalString.get("    Impurity (order ") + this.order + "):\t\t" + this.impurity + "\n");
        return stringBuffer.toString();
    }

    public final void incremental(double d, int n) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        switch (n) {
            case 1: {
                this.nl += 1.0;
                this.nr -= 1.0;
                this.sl += d;
                this.sr -= d;
                this.s2l += d * d;
                this.s2r -= d * d;
                break;
            }
            case -1: {
                this.nl -= 1.0;
                this.nr += 1.0;
                this.sl -= d;
                this.sr += d;
                this.s2l -= d * d;
                this.s2r += d * d;
                break;
            }
            case 0: {
                break;
            }
            default: {
                System.err.println(LocalString.get("wrong type in Impurity.incremental()."));
            }
        }
        if (this.nl <= 0.0) {
            this.vl = 0.0;
            this.sdl = 0.0;
        } else {
            this.vl = (this.nl * this.s2l - this.sl * this.sl) / (this.nl * this.nl);
            this.vl = Math.abs(this.vl);
            this.sdl = Math.sqrt(this.vl);
        }
        if (this.nr <= 0.0) {
            this.vr = 0.0;
            this.sdr = 0.0;
        } else {
            this.vr = (this.nr * this.s2r - this.sr * this.sr) / (this.nr * this.nr);
            this.vr = Math.abs(this.vr);
            this.sdr = Math.sqrt(this.vr);
        }
        if (this.order <= 0) {
            System.err.println(LocalString.get("Impurity order less than zero in Impurity.incremental()"));
        } else if (this.order == 1) {
            d2 = this.va;
            d3 = this.vl;
            d4 = this.vr;
        } else {
            d2 = Math.pow(this.va, 1.0 / (double)this.order);
            d3 = Math.pow(this.vl, 1.0 / (double)this.order);
            d4 = Math.pow(this.vr, 1.0 / (double)this.order);
        }
        this.impurity = this.nl <= 0.0 || this.nr <= 0.0 ? 0.0 : d2 - this.nl / this.n * d3 - this.nr / this.n * d4;
    }
}

