/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.trees.j48.NBTreeClassifierTree;
import weka.classifiers.trees.j48.NBTreeModelSelection;
import weka.core.AdditionalMeasureProducer;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Summarizable;
import weka.core.WeightedInstancesHandler;

public class NBTree
extends Classifier
implements WeightedInstancesHandler,
Drawable,
Summarizable,
AdditionalMeasureProducer {
    private int m_minNumObj = 30;
    private NBTreeClassifierTree m_root;

    public String globalInfo() {
        return LocalString.get("Class for generating a decision tree with naive Bayes classifiers at ") + LocalString.get("the leaves. For more information, see\n\nRon Kohavi (1996). Scaling up ") + LocalString.get("the accuracy of naive-Bayes classifiers: a decision tree hybrid. Procedings ") + LocalString.get("of the Second Internaltional Conference on Knoledge Discovery and Data Mining.");
    }

    public void buildClassifier(Instances instances) throws Exception {
        NBTreeModelSelection nBTreeModelSelection = new NBTreeModelSelection(this.m_minNumObj, instances);
        this.m_root = new NBTreeClassifierTree(nBTreeModelSelection);
        this.m_root.buildClassifier(instances);
    }

    public double classifyInstance(Instance instance) throws Exception {
        return this.m_root.classifyInstance(instance);
    }

    public final double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_root.distributionForInstance(instance, false);
    }

    public String toString() {
        if (this.m_root == null) {
            return LocalString.get("No classifier built");
        }
        return LocalString.get("NBTree\n------------------\n") + this.m_root.toString();
    }

    public int graphType() {
        return 1;
    }

    public String graph() throws Exception {
        return this.m_root.graph();
    }

    public String toSummaryString() {
        return LocalString.get("Number of leaves: ") + this.m_root.numLeaves() + "\n" + LocalString.get("Size of the tree: ") + this.m_root.numNodes() + "\n";
    }

    public double measureTreeSize() {
        return this.m_root.numNodes();
    }

    public double measureNumLeaves() {
        return this.m_root.numLeaves();
    }

    public double measureNumRules() {
        return this.m_root.numLeaves();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase(LocalString.get("measureNumRules")) == 0) {
            return this.measureNumRules();
        }
        if (string.compareToIgnoreCase(LocalString.get("measureTreeSize")) == 0) {
            return this.measureTreeSize();
        }
        if (string.compareToIgnoreCase(LocalString.get("measureNumLeaves")) == 0) {
            return this.measureNumLeaves();
        }
        throw new IllegalArgumentException(string + LocalString.get(" not supported (j48)"));
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(3);
        vector.addElement(LocalString.get("measureTreeSize"));
        vector.addElement(LocalString.get("measureNumLeaves"));
        vector.addElement(LocalString.get("measureNumRules"));
        return vector.elements();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new NBTree(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

