/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.UpdateableClassifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;

public class NNge
extends Classifier
implements UpdateableClassifier,
OptionHandler {
    private Instances m_Train;
    private Exemplar m_Exemplars;
    private Exemplar[] m_ExemplarsByClass;
    double[] m_MinArray;
    double[] m_MaxArray;
    private int m_NumAttemptsOfGene = 5;
    private int m_NumFoldersMI = 5;
    private double[] m_MissingVector;
    private int[][][] m_MI_NumAttrClassInter;
    private int[][] m_MI_NumAttrInter;
    private double[] m_MI_MaxArray;
    private double[] m_MI_MinArray;
    private int[][][] m_MI_NumAttrClassValue;
    private int[][] m_MI_NumAttrValue;
    private int[] m_MI_NumClass;
    private int m_MI_NumInst;
    private double[] m_MI;

    public String globalInfo() {
        return LocalString.get("Nearest-neighbor-like algorithm using non-nested generalized exemplars ") + LocalString.get("(which are hyperrectangles that can be viewed as if-then rules). For more ") + LocalString.get("information, see \n\n") + LocalString.get("Brent Martin, (1995) \"Instance-Based learning : Nearest Neighbor With ") + LocalString.get("Generalization\", Master Thesis, University of Waikato, Hamilton, New ") + LocalString.get("Zealand\n\n") + LocalString.get("Sylvain Roy (2002) \"Nearest Neighbor With Generalization\",") + LocalString.get("Unpublished, University of Canterbury, Christchurch, New Zealand\n\n");
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("Cannot handle string attributes!"));
        }
        if (!instances.attribute(instances.classIndex()).isNominal()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("Class type must be nominal!"));
        }
        instances = new Instances(instances);
        this.m_Train = new Instances(instances, 0);
        this.m_Exemplars = null;
        this.m_ExemplarsByClass = new Exemplar[this.m_Train.numClasses()];
        for (n = 0; n < this.m_Train.numClasses(); ++n) {
            this.m_ExemplarsByClass[n] = null;
        }
        this.m_MaxArray = new double[this.m_Train.numAttributes()];
        this.m_MinArray = new double[this.m_Train.numAttributes()];
        for (n = 0; n < this.m_Train.numAttributes(); ++n) {
            this.m_MinArray[n] = Double.POSITIVE_INFINITY;
            this.m_MaxArray[n] = Double.NEGATIVE_INFINITY;
        }
        this.m_MI_MinArray = new double[instances.numAttributes()];
        this.m_MI_MaxArray = new double[instances.numAttributes()];
        this.m_MI_NumAttrClassInter = new int[instances.numAttributes()][][];
        this.m_MI_NumAttrInter = new int[instances.numAttributes()][];
        this.m_MI_NumAttrClassValue = new int[instances.numAttributes()][][];
        this.m_MI_NumAttrValue = new int[instances.numAttributes()][];
        this.m_MI_NumClass = new int[instances.numClasses()];
        this.m_MI = new double[instances.numAttributes()];
        this.m_MI_NumInst = 0;
        for (n = 0; n < instances.numClasses(); ++n) {
            this.m_MI_NumClass[n] = 0;
        }
        for (n = 0; n < instances.numAttributes(); ++n) {
            int n2;
            if (n == instances.classIndex()) continue;
            this.m_MI_MinArray[n] = Double.NaN;
            this.m_MI_MaxArray[n] = Double.NaN;
            this.m_MI[n] = Double.NaN;
            if (instances.attribute(n).isNumeric()) {
                this.m_MI_NumAttrInter[n] = new int[this.m_NumFoldersMI];
                for (n2 = 0; n2 < this.m_NumFoldersMI; ++n2) {
                    this.m_MI_NumAttrInter[n][n2] = 0;
                }
            } else {
                this.m_MI_NumAttrValue[n] = new int[instances.attribute(n).numValues() + 1];
                for (n2 = 0; n2 < instances.attribute(n).numValues() + 1; ++n2) {
                    this.m_MI_NumAttrValue[n][n2] = 0;
                }
            }
            this.m_MI_NumAttrClassInter[n] = new int[instances.numClasses()][];
            this.m_MI_NumAttrClassValue[n] = new int[instances.numClasses()][];
            for (n2 = 0; n2 < instances.numClasses(); ++n2) {
                int n3;
                if (instances.attribute(n).isNumeric()) {
                    this.m_MI_NumAttrClassInter[n][n2] = new int[this.m_NumFoldersMI];
                    for (n3 = 0; n3 < this.m_NumFoldersMI; ++n3) {
                        this.m_MI_NumAttrClassInter[n][n2][n3] = 0;
                    }
                    continue;
                }
                if (!instances.attribute(n).isNominal()) continue;
                this.m_MI_NumAttrClassValue[n][n2] = new int[instances.attribute(n).numValues() + 1];
                for (n3 = 0; n3 < instances.attribute(n).numValues() + 1; ++n3) {
                    this.m_MI_NumAttrClassValue[n][n2][n3] = 0;
                }
            }
        }
        this.m_MissingVector = new double[instances.numAttributes()];
        for (n = 0; n < instances.numAttributes(); ++n) {
            this.m_MissingVector[n] = n == instances.classIndex() ? Double.NaN : (double)instances.attribute(n).numValues();
        }
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            this.update((Instance)enumeration.nextElement());
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (!this.m_Train.equalHeaders(instance.dataset())) {
            throw new Exception(LocalString.get("NNge.classifyInstance : Incompatible instance types !"));
        }
        Exemplar exemplar = this.nearestExemplar(instance);
        if (exemplar == null) {
            throw new Exception(LocalString.get("NNge.classifyInstance : NNge hasn't been trained !"));
        }
        return exemplar.classValue();
    }

    public void updateClassifier(Instance instance) throws Exception {
        if (!this.m_Train.equalHeaders(instance.dataset())) {
            throw new Exception(LocalString.get("Incompatible instance types"));
        }
        this.update(instance);
    }

    private void update(Instance instance) throws Exception {
        if (instance.classIsMissing()) {
            return;
        }
        instance.replaceMissingValues(this.m_MissingVector);
        this.m_Train.add(instance);
        this.updateMinMax(instance);
        this.updateMI(instance);
        Exemplar exemplar = this.nearestExemplar(instance);
        if (exemplar == null) {
            Exemplar exemplar2 = new Exemplar(this, this.m_Train, 10, instance.classValue());
            exemplar2.generalise(instance);
            this.initWeight(exemplar2);
            this.addExemplar(exemplar2);
            return;
        }
        this.adjust(instance, exemplar);
        this.generalise(instance);
    }

    private Exemplar nearestExemplar(Instance instance) {
        if (this.m_Exemplars == null) {
            return null;
        }
        Exemplar exemplar = this.m_Exemplars;
        Exemplar exemplar2 = this.m_Exemplars;
        double d = exemplar.squaredDistance(instance);
        while (exemplar.next != null) {
            double d2 = (exemplar = exemplar.next).squaredDistance(instance);
            if (!(d2 < d)) continue;
            d = d2;
            exemplar2 = exemplar;
        }
        return exemplar2;
    }

    private Exemplar nearestExemplar(Instance instance, double d) {
        if (this.m_ExemplarsByClass[(int)d] == null) {
            return null;
        }
        Exemplar exemplar = this.m_ExemplarsByClass[(int)d];
        Exemplar exemplar2 = this.m_ExemplarsByClass[(int)d];
        double d2 = exemplar.squaredDistance(instance);
        while (exemplar.nextWithClass != null) {
            double d3 = (exemplar = exemplar.nextWithClass).squaredDistance(instance);
            if (!(d3 < d2)) continue;
            d2 = d3;
            exemplar2 = exemplar;
        }
        return exemplar2;
    }

    private void generalise(Instance instance) throws Exception {
        Exemplar exemplar;
        Exemplar exemplar2 = this.m_ExemplarsByClass[(int)instance.classValue()];
        for (int i = 0; i < this.m_NumAttemptsOfGene && exemplar2 != null; ++i) {
            exemplar = exemplar2;
            Exemplar exemplar3 = exemplar2;
            double d = exemplar2.squaredDistance(instance);
            while (exemplar3.nextWithClass != null) {
                double d2 = (exemplar3 = exemplar3.nextWithClass).squaredDistance(instance);
                if (!(d2 < d)) continue;
                d = d2;
                exemplar = exemplar3;
            }
            if (exemplar == exemplar2) {
                exemplar2 = exemplar2.nextWithClass;
            }
            this.removeExemplar(exemplar);
            exemplar.preGeneralise(instance);
            if (!this.detectOverlapping(exemplar)) {
                exemplar.validateGeneralisation();
                this.addExemplar(exemplar);
                return;
            }
            exemplar.cancelGeneralisation();
            this.addExemplar(exemplar);
        }
        exemplar = new Exemplar(this, this.m_Train, 5, instance.classValue());
        exemplar.generalise(instance);
        this.initWeight(exemplar);
        this.addExemplar(exemplar);
    }

    private void adjust(Instance instance, Exemplar exemplar) throws Exception {
        if (instance.classValue() == exemplar.classValue()) {
            exemplar.incrPositiveCount();
        } else {
            exemplar.incrNegativeCount();
            if (exemplar.holds(instance)) {
                this.prune(exemplar, instance);
            }
        }
    }

    private void prune(Exemplar exemplar, Instance instance) throws Exception {
        Serializable serializable;
        Object object;
        int n;
        this.removeExemplar(exemplar);
        int n2 = -1;
        int n3 = -1;
        double d = Double.POSITIVE_INFINITY;
        int n4 = -1;
        int n5 = -1;
        for (n = 0; n < this.m_Train.numAttributes(); ++n) {
            int n6;
            if (n == this.m_Train.classIndex()) continue;
            if (this.m_Train.attribute(n).isNumeric()) {
                double d2 = this.m_MaxArray[n] - this.m_MinArray[n];
                double d3 = d2 != 0.0 ? Math.min(exemplar.getMaxBorder(n) - instance.value(n), instance.value(n) - exemplar.getMinBorder(n)) / d2 : Double.POSITIVE_INFINITY;
                int n7 = 0;
                n6 = 0;
                object = exemplar.enumerateInstances();
                while (object.hasMoreElements()) {
                    serializable = (Instance)object.nextElement();
                    if (((Instance)serializable).value(n) < instance.value(n)) {
                        ++n6;
                        continue;
                    }
                    if (!(((Instance)serializable).value(n) > instance.value(n))) continue;
                    ++n7;
                }
                n6 = Math.max(n6, n7);
                if (d3 < d) {
                    d = d3;
                    n5 = n6;
                    n2 = n;
                    continue;
                }
                if (d3 != d || n6 <= n5) continue;
                n5 = n6;
                n2 = n;
                continue;
            }
            Enumeration enumeration = exemplar.enumerateInstances();
            n6 = 0;
            while (enumeration.hasMoreElements()) {
                if (((Instance)enumeration.nextElement()).value(n) == instance.value(n)) continue;
                ++n6;
            }
            if (n6 <= n4) continue;
            n4 = n6;
            n3 = n;
        }
        n = n2 == -1 && n3 == -1 ? 0 : (n2 == -1 ? n3 : (n3 == -1 ? n2 : (n4 > n5 ? n3 : n2)));
        Exemplar exemplar2 = new Exemplar(this, this.m_Train, 10, exemplar.classValue());
        object = new Exemplar(this, this.m_Train, 10, exemplar.classValue());
        serializable = new LinkedList();
        Enumeration enumeration = exemplar.enumerateInstances();
        if (this.m_Train.attribute(n).isNumeric()) {
            while (enumeration.hasMoreElements()) {
                Instance instance2 = (Instance)enumeration.nextElement();
                if (instance2.value(n) > instance.value(n)) {
                    exemplar2.generalise(instance2);
                    continue;
                }
                if (instance2.value(n) < instance.value(n)) {
                    ((Exemplar)object).generalise(instance2);
                    continue;
                }
                if (!this.notEqualFeatures(instance2, instance)) continue;
                ((LinkedList)serializable).add(instance2);
            }
        } else {
            while (enumeration.hasMoreElements()) {
                Instance instance3 = (Instance)enumeration.nextElement();
                if (instance3.value(n) != instance.value(n)) {
                    exemplar2.generalise(instance3);
                    continue;
                }
                if (!this.notEqualFeatures(instance3, instance)) continue;
                ((LinkedList)serializable).add(instance3);
            }
        }
        while (((LinkedList)serializable).size() != 0) {
            Instance instance4 = (Instance)((LinkedList)serializable).removeFirst();
            exemplar2.preGeneralise(instance4);
            if (!exemplar2.holds(instance)) {
                exemplar2.validateGeneralisation();
                continue;
            }
            exemplar2.cancelGeneralisation();
            ((Exemplar)object).preGeneralise(instance4);
            if (!((Exemplar)object).holds(instance)) {
                ((Exemplar)object).validateGeneralisation();
                continue;
            }
            ((Exemplar)object).cancelGeneralisation();
            Exemplar exemplar3 = new Exemplar(this, this.m_Train, 3, instance4.classValue());
            exemplar3.generalise(instance4);
            this.initWeight(exemplar3);
            this.addExemplar(exemplar3);
        }
        if (exemplar2.numInstances() != 0) {
            this.initWeight(exemplar2);
            this.addExemplar(exemplar2);
        }
        if (((Instances)object).numInstances() != 0) {
            this.initWeight((Exemplar)object);
            this.addExemplar((Exemplar)object);
        }
    }

    private boolean notEqualFeatures(Instance instance, Instance instance2) {
        for (int i = 0; i < this.m_Train.numAttributes(); ++i) {
            if (i == this.m_Train.classIndex() || instance.value(i) == instance2.value(i)) continue;
            return true;
        }
        return false;
    }

    private boolean detectOverlapping(Exemplar exemplar) {
        Exemplar exemplar2 = this.m_Exemplars;
        while (exemplar2 != null) {
            if (exemplar.overlaps(exemplar2)) {
                return true;
            }
            exemplar2 = exemplar2.next;
        }
        return false;
    }

    private void updateMinMax(Instance instance) {
        for (int i = 0; i < this.m_Train.numAttributes(); ++i) {
            if (this.m_Train.classIndex() == i || this.m_Train.attribute(i).isNominal()) continue;
            if (instance.value(i) < this.m_MinArray[i]) {
                this.m_MinArray[i] = instance.value(i);
            }
            if (!(instance.value(i) > this.m_MaxArray[i])) continue;
            this.m_MaxArray[i] = instance.value(i);
        }
    }

    private void updateMI(Instance instance) throws Exception {
        if (this.m_NumFoldersMI < 1) {
            throw new Exception(LocalString.get("NNge.updateMI : incorrect number of folders ! Option I must be greater than 1."));
        }
        int n = (int)instance.classValue();
        this.m_MI_NumClass[n] = this.m_MI_NumClass[n] + 1;
        ++this.m_MI_NumInst;
        for (int i = 0; i < this.m_Train.numAttributes(); ++i) {
            double d;
            int n2;
            int n3;
            if (this.m_Train.classIndex() == i) continue;
            if (this.m_Train.attribute(i).isNumeric()) {
                int n4;
                double d2;
                if (Double.isNaN(this.m_MI_MaxArray[i]) || Double.isNaN(this.m_MI_MinArray[i]) || this.m_MI_MaxArray[i] < instance.value(i) || instance.value(i) < this.m_MI_MinArray[i]) {
                    if (Double.isNaN(this.m_MI_MaxArray[i])) {
                        this.m_MI_MaxArray[i] = instance.value(i);
                    }
                    if (Double.isNaN(this.m_MI_MinArray[i])) {
                        this.m_MI_MinArray[i] = instance.value(i);
                    }
                    if (this.m_MI_MaxArray[i] < instance.value(i)) {
                        this.m_MI_MaxArray[i] = instance.value(i);
                    }
                    if (this.m_MI_MinArray[i] > instance.value(i)) {
                        this.m_MI_MinArray[i] = instance.value(i);
                    }
                    d2 = (this.m_MI_MaxArray[i] - this.m_MI_MinArray[i]) / (double)this.m_NumFoldersMI;
                    for (n4 = 0; n4 < this.m_NumFoldersMI; ++n4) {
                        this.m_MI_NumAttrInter[i][n4] = 0;
                        for (int j = 0; j < this.m_Train.numClasses(); ++j) {
                            this.m_MI_NumAttrClassInter[i][j][n4] = 0;
                            Enumeration enumeration = this.m_Train.enumerateInstances();
                            while (enumeration.hasMoreElements()) {
                                Instance instance2 = (Instance)enumeration.nextElement();
                                if (!(this.m_MI_MinArray[i] + (double)n4 * d2 <= instance2.value(i)) || !(instance2.value(i) <= this.m_MI_MinArray[i] + (double)(n4 + 1) * d2) || instance2.classValue() != (double)j) continue;
                                int[] nArray = this.m_MI_NumAttrInter[i];
                                int n5 = n4;
                                nArray[n5] = nArray[n5] + 1;
                                int[] nArray2 = this.m_MI_NumAttrClassInter[i][j];
                                int n6 = n4;
                                nArray2[n6] = nArray2[n6] + 1;
                            }
                        }
                    }
                } else {
                    d2 = (this.m_MI_MaxArray[i] - this.m_MI_MinArray[i]) / (double)this.m_NumFoldersMI;
                    for (n4 = 0; n4 < this.m_NumFoldersMI; ++n4) {
                        if (!(this.m_MI_MinArray[i] + (double)n4 * d2 <= instance.value(i)) || !(instance.value(i) <= this.m_MI_MinArray[i] + (double)(n4 + 1) * d2)) continue;
                        int[] nArray = this.m_MI_NumAttrInter[i];
                        int n7 = n4;
                        nArray[n7] = nArray[n7] + 1;
                        int[] nArray3 = this.m_MI_NumAttrClassInter[i][(int)instance.classValue()];
                        int n8 = n4;
                        nArray3[n8] = nArray3[n8] + 1;
                    }
                }
                this.m_MI[i] = 0.0;
                for (n3 = 0; n3 < this.m_NumFoldersMI; ++n3) {
                    for (n2 = 0; n2 < this.m_Train.numClasses(); ++n2) {
                        double d3 = (double)this.m_MI_NumAttrClassInter[i][n2][n3] / (double)this.m_MI_NumInst;
                        double d4 = (double)this.m_MI_NumClass[n2] / (double)this.m_MI_NumInst;
                        d = (double)this.m_MI_NumAttrInter[i][n3] / (double)this.m_MI_NumInst;
                        if (d3 == 0.0) continue;
                        int n9 = i;
                        this.m_MI[n9] = this.m_MI[n9] + d3 * Utils.log2(d3 / (d4 * d));
                    }
                }
                continue;
            }
            if (this.m_Train.attribute(i).isNominal()) {
                int[] nArray = this.m_MI_NumAttrValue[i];
                int n10 = (int)instance.value(i);
                nArray[n10] = nArray[n10] + 1;
                int[] nArray4 = this.m_MI_NumAttrClassValue[i][(int)instance.classValue()];
                int n11 = (int)instance.value(i);
                nArray4[n11] = nArray4[n11] + 1;
                this.m_MI[i] = 0.0;
                for (n3 = 0; n3 < this.m_Train.attribute(i).numValues() + 1; ++n3) {
                    for (n2 = 0; n2 < this.m_Train.numClasses(); ++n2) {
                        double d5 = (double)this.m_MI_NumAttrClassValue[i][n2][n3] / (double)this.m_MI_NumInst;
                        double d6 = (double)this.m_MI_NumClass[n2] / (double)this.m_MI_NumInst;
                        d = (double)this.m_MI_NumAttrValue[i][n3] / (double)this.m_MI_NumInst;
                        if (d5 == 0.0) continue;
                        int n12 = i;
                        this.m_MI[n12] = this.m_MI[n12] + d5 * Utils.log2(d5 / (d6 * d));
                    }
                }
                continue;
            }
            throw new Exception(LocalString.get("NNge.updateMI : Cannot deal with 'string attribute'."));
        }
    }

    private void initWeight(Exemplar exemplar) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Exemplar exemplar2 = this.m_Exemplars;
        if (exemplar2 == null) {
            exemplar.setPositiveCount(1);
            exemplar.setNegativeCount(0);
            return;
        }
        while (exemplar2 != null) {
            n += exemplar2.getPositiveCount();
            n2 += exemplar2.getNegativeCount();
            ++n3;
            exemplar2 = exemplar2.next;
        }
        exemplar.setPositiveCount(n / n3);
        exemplar.setNegativeCount(n2 / n3);
    }

    private void addExemplar(Exemplar exemplar) {
        exemplar.next = this.m_Exemplars;
        if (this.m_Exemplars != null) {
            this.m_Exemplars.previous = exemplar;
        }
        exemplar.previous = null;
        this.m_Exemplars = exemplar;
        exemplar.nextWithClass = this.m_ExemplarsByClass[(int)exemplar.classValue()];
        if (this.m_ExemplarsByClass[(int)exemplar.classValue()] != null) {
            this.m_ExemplarsByClass[(int)exemplar.classValue()].previousWithClass = exemplar;
        }
        exemplar.previousWithClass = null;
        this.m_ExemplarsByClass[(int)((Exemplar)exemplar).classValue()] = exemplar;
    }

    private void removeExemplar(Exemplar exemplar) {
        if (this.m_Exemplars == exemplar) {
            this.m_Exemplars = exemplar.next;
            if (this.m_Exemplars != null) {
                this.m_Exemplars.previous = null;
            }
        } else {
            exemplar.previous.next = exemplar.next;
            if (exemplar.next != null) {
                exemplar.next.previous = exemplar.previous;
            }
        }
        exemplar.next = (exemplar.previous = null);
        if (this.m_ExemplarsByClass[(int)exemplar.classValue()] == exemplar) {
            this.m_ExemplarsByClass[(int)((Exemplar)exemplar).classValue()] = exemplar.nextWithClass;
            if (this.m_ExemplarsByClass[(int)exemplar.classValue()] != null) {
                this.m_ExemplarsByClass[(int)exemplar.classValue()].previousWithClass = null;
            }
        } else {
            exemplar.previousWithClass.nextWithClass = exemplar.nextWithClass;
            if (exemplar.nextWithClass != null) {
                exemplar.nextWithClass.previousWithClass = exemplar.previousWithClass;
            }
        }
        exemplar.nextWithClass = (exemplar.previousWithClass = null);
    }

    private double attrWeight(int n) {
        return this.m_MI[n];
    }

    public String toString() {
        int n;
        Exemplar exemplar = this.m_Exemplars;
        if (this.m_MinArray == null) {
            return LocalString.get("No classifier built");
        }
        int[] nArray = new int[this.m_Train.numClasses()];
        int[] nArray2 = new int[this.m_Train.numClasses()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = 0;
            nArray2[n] = 0;
        }
        int n2 = 0;
        int n3 = 0;
        String string = LocalString.get("\nNNGE classifier\n\nRules generated :\n");
        while (exemplar != null) {
            string = string + LocalString.get("\tclass ") + this.m_Train.attribute(this.m_Train.classIndex()).value((int)exemplar.classValue()) + " IF : ";
            string = string + exemplar.toRules() + "\n";
            ++n2;
            int n4 = (int)exemplar.classValue();
            nArray[n4] = nArray[n4] + 1;
            if (exemplar.numInstances() == 1) {
                ++n3;
                int n5 = (int)exemplar.classValue();
                nArray2[n5] = nArray2[n5] + 1;
            }
            exemplar = exemplar.next;
        }
        string = string + LocalString.get("\nStat :\n");
        for (n = 0; n < nArray.length; ++n) {
            string = string + LocalString.get("\tclass ") + this.m_Train.attribute(this.m_Train.classIndex()).value(n) + " : " + Integer.toString(nArray[n]) + LocalString.get(" exemplar(s) including ") + Integer.toString(nArray[n] - nArray2[n]) + LocalString.get(" Hyperrectangle(s) and ") + Integer.toString(nArray2[n]) + LocalString.get(" Single(s).\n");
        }
        string = string + LocalString.get("\n\tTotal : ") + Integer.toString(n2) + LocalString.get(" exemplars(s) including ") + Integer.toString(n2 - n3) + LocalString.get(" Hyperrectangle(s) and ") + Integer.toString(n3) + LocalString.get(" Single(s).\n");
        string = string + "\n";
        string = string + LocalString.get("\tFeature weights : ");
        String string2 = "[";
        for (int i = 0; i < this.m_Train.numAttributes(); ++i) {
            if (i == this.m_Train.classIndex()) continue;
            string = string + string2 + Double.toString(this.attrWeight(i));
            string2 = " ";
        }
        string = string + "]";
        string = string + "\n\n";
        return string;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option(LocalString.get("\tNumber of attempts of generalisation.\n"), "G", 1, LocalString.get("-G <value>")));
        vector.addElement(new Option(LocalString.get("\tNumber of folder for computing the mutual information.\n"), "I", 1, LocalString.get("-I <value>")));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('G', stringArray);
        if (string.length() != 0) {
            this.m_NumAttemptsOfGene = Integer.parseInt(string);
            if (this.m_NumAttemptsOfGene < 1) {
                throw new Exception(LocalString.get("NNge.setOptions : G option's value must be greater than 1."));
            }
        } else {
            this.m_NumAttemptsOfGene = 5;
        }
        if ((string = Utils.getOption('I', stringArray)).length() != 0) {
            this.m_NumFoldersMI = Integer.parseInt(string);
            if (this.m_NumFoldersMI < 1) {
                throw new Exception(LocalString.get("NNge.setOptions : I option's value must be greater than 1."));
            }
        } else {
            this.m_NumFoldersMI = 5;
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[5];
        int n = 0;
        stringArray[n++] = "-G";
        stringArray[n++] = "" + this.m_NumAttemptsOfGene;
        stringArray[n++] = "-I";
        stringArray[n++] = "" + this.m_NumFoldersMI;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String numAttemptsOfGeneOptionTipText() {
        return LocalString.get("Sets the number of attempts for generalization.");
    }

    public int getNumAttemptsOfGeneOption() {
        return this.m_NumAttemptsOfGene;
    }

    public void setNumAttemptsOfGeneOption(int n) {
        this.m_NumAttemptsOfGene = n;
    }

    public String numFoldersMIOptionTipText() {
        return LocalString.get("Sets the number of folder for mutual information.");
    }

    public int getNumFoldersMIOption() {
        return this.m_NumFoldersMI;
    }

    public void setNumFoldersMIOption(int n) {
        this.m_NumFoldersMI = n;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new NNge(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private class Exemplar
    extends Instances {
        private Exemplar previous = null;
        private Exemplar next = null;
        private Exemplar previousWithClass = null;
        private Exemplar nextWithClass = null;
        private NNge m_NNge;
        private double m_ClassValue;
        private int m_PositiveCount = 1;
        private int m_NegativeCount = 0;
        private double[] m_MaxBorder;
        private double[] m_MinBorder;
        private boolean[][] m_Range;
        private double[] m_PreMaxBorder = null;
        private double[] m_PreMinBorder = null;
        private boolean[][] m_PreRange = null;
        private Instance m_PreInst = null;

        private Exemplar(NNge nNge2, Instances instances, int n, double d) {
            super(instances, n);
            this.m_NNge = nNge2;
            this.m_ClassValue = d;
            this.m_MinBorder = new double[this.numAttributes()];
            this.m_MaxBorder = new double[this.numAttributes()];
            this.m_Range = new boolean[this.numAttributes()][];
            for (int i = 0; i < this.numAttributes(); ++i) {
                if (this.attribute(i).isNumeric()) {
                    this.m_MinBorder[i] = Double.POSITIVE_INFINITY;
                    this.m_MaxBorder[i] = Double.NEGATIVE_INFINITY;
                    this.m_Range[i] = null;
                    continue;
                }
                this.m_MinBorder[i] = Double.NaN;
                this.m_MaxBorder[i] = Double.NaN;
                this.m_Range[i] = new boolean[this.attribute(i).numValues() + 1];
                for (int j = 0; j < this.attribute(i).numValues() + 1; ++j) {
                    this.m_Range[i][j] = false;
                }
            }
        }

        private void generalise(Instance instance) throws Exception {
            if (this.m_ClassValue != instance.classValue()) {
                throw new Exception(LocalString.get("Exemplar.generalise : Incompatible instance's class."));
            }
            this.add(instance);
            for (int i = 0; i < this.numAttributes(); ++i) {
                if (instance.isMissing(i)) {
                    throw new Exception(LocalString.get("Exemplar.generalise : Generalisation with missing feature impossible."));
                }
                if (i == this.classIndex()) continue;
                if (this.attribute(i).isNumeric()) {
                    if (this.m_MaxBorder[i] < instance.value(i)) {
                        this.m_MaxBorder[i] = instance.value(i);
                    }
                    if (!(instance.value(i) < this.m_MinBorder[i])) continue;
                    this.m_MinBorder[i] = instance.value(i);
                    continue;
                }
                this.m_Range[i][(int)instance.value((int)i)] = true;
            }
        }

        private void preGeneralise(Instance instance) throws Exception {
            int n;
            if (this.m_ClassValue != instance.classValue()) {
                throw new Exception(LocalString.get("Exemplar.preGeneralise : Incompatible instance's class."));
            }
            this.m_PreInst = instance;
            this.m_PreRange = new boolean[this.numAttributes()][];
            this.m_PreMinBorder = new double[this.numAttributes()];
            this.m_PreMaxBorder = new double[this.numAttributes()];
            for (n = 0; n < this.numAttributes(); ++n) {
                if (this.attribute(n).isNumeric()) {
                    this.m_PreMinBorder[n] = this.m_MinBorder[n];
                    this.m_PreMaxBorder[n] = this.m_MaxBorder[n];
                    continue;
                }
                this.m_PreRange[n] = new boolean[this.attribute(n).numValues() + 1];
                for (int i = 0; i < this.attribute(n).numValues() + 1; ++i) {
                    this.m_PreRange[n][i] = this.m_Range[n][i];
                }
            }
            for (n = 0; n < this.numAttributes(); ++n) {
                if (instance.isMissing(n)) {
                    throw new Exception(LocalString.get("Exemplar.preGeneralise : Generalisation with missing feature impossible."));
                }
                if (n == this.classIndex()) continue;
                if (this.attribute(n).isNumeric()) {
                    if (this.m_MaxBorder[n] < instance.value(n)) {
                        this.m_MaxBorder[n] = instance.value(n);
                    }
                    if (!(instance.value(n) < this.m_MinBorder[n])) continue;
                    this.m_MinBorder[n] = instance.value(n);
                    continue;
                }
                this.m_Range[n][(int)instance.value((int)n)] = true;
            }
        }

        private void validateGeneralisation() throws Exception {
            if (this.m_PreInst == null) {
                throw new Exception(LocalString.get("Exemplar.validateGeneralisation : validateGeneralisation called without previous call to preGeneralise!"));
            }
            this.add(this.m_PreInst);
            this.m_PreRange = null;
            this.m_PreMinBorder = null;
            this.m_PreMaxBorder = null;
        }

        private void cancelGeneralisation() throws Exception {
            if (this.m_PreInst == null) {
                throw new Exception(LocalString.get("Exemplar.cancelGeneralisation : cancelGeneralisation called without previous call to preGeneralise!"));
            }
            this.m_PreInst = null;
            this.m_Range = this.m_PreRange;
            this.m_MinBorder = this.m_PreMinBorder;
            this.m_MaxBorder = this.m_PreMaxBorder;
            this.m_PreRange = null;
            this.m_PreMinBorder = null;
            this.m_PreMaxBorder = null;
        }

        private boolean holds(Instance instance) {
            if (this.numInstances() == 0) {
                return false;
            }
            for (int i = 0; i < this.numAttributes(); ++i) {
                if (i == this.classIndex() || this.holds(i, instance.value(i))) continue;
                return false;
            }
            return true;
        }

        private boolean holds(int n, double d) {
            if (this.numAttributes() == 0) {
                return false;
            }
            if (this.attribute(n).isNumeric()) {
                return this.m_MinBorder[n] <= d && d <= this.m_MaxBorder[n];
            }
            return this.m_Range[n][(int)d];
        }

        private boolean overlaps(Exemplar exemplar) {
            if (exemplar.isEmpty() || this.isEmpty()) {
                return false;
            }
            for (int i = 0; i < this.numAttributes(); ++i) {
                if (i == this.classIndex()) continue;
                if (this.attribute(i).isNumeric() && (exemplar.m_MaxBorder[i] < this.m_MinBorder[i] || exemplar.m_MinBorder[i] > this.m_MaxBorder[i])) {
                    return false;
                }
                if (!this.attribute(i).isNominal()) continue;
                boolean bl = false;
                for (int j = 0; j < this.attribute(i).numValues() + 1; ++j) {
                    if (!this.m_Range[i][j] || !exemplar.m_Range[i][j]) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }

        private double attrDistance(Instance instance, int n) {
            if (instance.isMissing(n)) {
                return 0.0;
            }
            if (this.attribute(n).isNumeric()) {
                double d = this.m_NNge.m_MaxArray[n] - this.m_NNge.m_MinArray[n];
                if (d <= 0.0) {
                    d = 1.0;
                }
                if (this.m_MaxBorder[n] < instance.value(n)) {
                    return (instance.value(n) - this.m_MaxBorder[n]) / d;
                }
                if (instance.value(n) < this.m_MinBorder[n]) {
                    return (this.m_MinBorder[n] - instance.value(n)) / d;
                }
                return 0.0;
            }
            if (this.holds(n, instance.value(n))) {
                return 0.0;
            }
            return 1.0;
        }

        private double squaredDistance(Instance instance) {
            double d = 0.0;
            int n = 0;
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (i == this.classIndex()) continue;
                double d2 = this.m_NNge.attrWeight(i) * this.attrDistance(instance, i);
                d2 *= d2;
                d += d2;
                if (instance.isMissing(i)) continue;
                ++n;
            }
            if (n == 0) {
                return 0.0;
            }
            return d / (double)(n * n);
        }

        private double weight() {
            return (double)(this.m_PositiveCount + this.m_NegativeCount) / (double)this.m_PositiveCount;
        }

        private double classValue() {
            return this.m_ClassValue;
        }

        private double getMinBorder(int n) throws Exception {
            if (!this.attribute(n).isNumeric()) {
                throw new Exception(LocalString.get("Exception.getMinBorder : not numeric attribute !"));
            }
            if (this.numInstances() == 0) {
                throw new Exception(LocalString.get("Exception.getMinBorder : empty Exemplar !"));
            }
            return this.m_MinBorder[n];
        }

        private double getMaxBorder(int n) throws Exception {
            if (!this.attribute(n).isNumeric()) {
                throw new Exception(LocalString.get("Exception.getMaxBorder : not numeric attribute !"));
            }
            if (this.numInstances() == 0) {
                throw new Exception(LocalString.get("Exception.getMaxBorder : empty Exemplar !"));
            }
            return this.m_MaxBorder[n];
        }

        private int getPositiveCount() {
            return this.m_PositiveCount;
        }

        private int getNegativeCount() {
            return this.m_NegativeCount;
        }

        private void setPositiveCount(int n) {
            this.m_PositiveCount = n;
        }

        private void setNegativeCount(int n) {
            this.m_NegativeCount = n;
        }

        private void incrPositiveCount() {
            ++this.m_PositiveCount;
        }

        private void incrNegativeCount() {
            ++this.m_NegativeCount;
        }

        private boolean isEmpty() {
            return this.numInstances() == 0;
        }

        private String toString2() {
            Enumeration enumeration = null;
            String string = LocalString.get("Exemplar[");
            if (this.numInstances() == 0) {
                return string + LocalString.get("Empty]");
            }
            string = string + "{";
            enumeration = this.enumerateInstances();
            while (enumeration.hasMoreElements()) {
                string = string + "<" + enumeration.nextElement().toString() + "> ";
            }
            string = string.substring(0, string.length() - 1);
            string = string + "} {" + this.toRules() + "} p=" + this.m_PositiveCount + " n=" + this.m_NegativeCount + "]";
            return string;
        }

        private String toRules() {
            if (this.numInstances() == 0) {
                return LocalString.get("No Rules (Empty Exemplar)");
            }
            String string = "";
            String string2 = "";
            for (int i = 0; i < this.numAttributes(); ++i) {
                if (i == this.classIndex()) continue;
                if (this.attribute(i).isNumeric()) {
                    string = this.m_MaxBorder[i] != this.m_MinBorder[i] ? string + string2 + this.m_MinBorder[i] + "<=" + this.attribute(i).name() + "<=" + this.m_MaxBorder[i] : string + string2 + this.attribute(i).name() + "=" + this.m_MaxBorder[i];
                    string2 = " ^ ";
                    continue;
                }
                string = string + string2 + this.attribute(i).name() + " in {";
                String string3 = "";
                for (int j = 0; j < this.attribute(i).numValues() + 1; ++j) {
                    if (!this.m_Range[i][j]) continue;
                    string = string + string3;
                    string = j == this.attribute(i).numValues() ? string + "?" : string + this.attribute(i).value(j);
                    string3 = ",";
                }
                string = string + "}";
                string2 = " ^ ";
            }
            string = string + "  (" + this.numInstances() + ")";
            return string;
        }
    }
}

