/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.Rule;
import weka.classifiers.rules.RuleStats;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Copyable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.supervised.attribute.ClassOrder;

public class JRip
extends Classifier
implements OptionHandler,
AdditionalMeasureProducer,
WeightedInstancesHandler {
    private static double MAX_DL_SURPLUS = 64.0;
    private Attribute m_Class;
    private FastVector m_Ruleset;
    private FastVector m_Distributions;
    private int m_Optimizations = 2;
    private Random m_Random = null;
    private double m_Total = 0.0;
    private long m_Seed = 1L;
    private int m_Folds = 3;
    private double m_MinNo = 2.0;
    private boolean m_Debug = false;
    private boolean m_CheckErr = true;
    private boolean m_UsePruning = true;
    private Filter m_Filter = null;
    private FastVector m_RulesetStats;

    public String globalInfo() {
        return LocalString.get("This class implements a propositional rule learner, Repeated Incremental ") + LocalString.get("Pruning to Produce Error Reduction (RIPPER), which was proposed by William ") + LocalString.get("W. Cohen as an optimized version of IREP. \n\n") + LocalString.get("The algorithm is briefly described as follows: \n\n") + LocalString.get("Initialize RS = {}, and for each class from the less prevalent one to ") + LocalString.get("the more frequent one, DO: \n\n") + LocalString.get("1. Building stage:\nRepeat 1.1 and 1.2 until the descrition length (DL) ") + LocalString.get("of the ruleset and examples is 64 bits greater than the smallest DL ") + LocalString.get("met so far, or there are no positive examples, or the error rate >= 50%. ") + "\n\n" + LocalString.get("1.1. Grow phase:\n") + LocalString.get("Grow one rule by greedily adding antecedents (or conditions) to ") + LocalString.get("the rule until the rule is perfect (i.e. 100% accurate).  The ") + LocalString.get("procedure tries every possible value of each attribute and selects ") + LocalString.get("the condition with highest information gain: p(log(p/t)-log(P/T)).") + "\n\n" + LocalString.get("1.2. Prune phase:\n") + LocalString.get("Incrementally prune each rule and allow the pruning of any ") + LocalString.get("final sequences of the antecedents;") + LocalString.get("The pruning metric is (p-n)/(p+n) -- but it's actually ") + LocalString.get("2p/(p+n) -1, so in this implementation we simply use p/(p+n) ") + LocalString.get("(actually (p+1)/(p+n+2), thus if p+n is 0, it's 0.5).\n\n") + LocalString.get("2. Optimization stage:\n after generating the initial ruleset {Ri}, ") + LocalString.get("generate and prune two variants of each rule Ri from randomized data ") + LocalString.get("using procedure 1.1 and 1.2. But one variant is generated from an ") + LocalString.get("empty rule while the other is generated by greedily adding antecedents ") + LocalString.get("to the original rule. Moreover, the pruning metric used here is ") + "(TP+TN)/(P+N)." + LocalString.get("Then the smallest possible DL for each variant and the original rule ") + LocalString.get("is computed.  The variant with the minimal DL is selected as the final ") + LocalString.get("representative of Ri in the ruleset.") + LocalString.get("After all the rules in {Ri} have been examined and if there are still ") + LocalString.get("residual positives, more rules are generated based on the residual ") + LocalString.get("positives using Building Stage again. \n") + LocalString.get("3. Delete the rules from the ruleset that would increase the DL of the ") + LocalString.get("whole ruleset if it were in it. and add resultant ruleset to RS. \n") + LocalString.get("ENDDO\n\n") + LocalString.get("Note that there seem to be 2 bugs in the original ripper program that would ") + LocalString.get("affect the ruleset size and accuracy slightly.  This implementation avoids ") + LocalString.get("these bugs and thus is a little bit different from Cohen's original ") + LocalString.get("implementation. Even after fixing the bugs, since the order of classes with ") + LocalString.get("the same frequency is not defined in ripper, there still seems to be ") + LocalString.get("some trivial difference between this implementation and the original ripper, ") + LocalString.get("especially for audiology data in UCI repository, where there are lots of ") + LocalString.get("classes of few instances.\n\n") + LocalString.get("Details please see \"Fast Effective Rule Induction\", William W. Cohen, ") + LocalString.get("'Machine Learning: Proceedings of the Twelfth International Conference'") + LocalString.get("(ML95). \n\n") + LocalString.get("PS.  We have compared this implementation with the original ripper ") + LocalString.get("implementation in aspects of accuracy, ruleset size and running time ") + LocalString.get("on both artificial data \"ab+bcd+defg\" and UCI datasets.  In all these ") + LocalString.get("aspects it seems to be quite comparable to the original ripper ") + LocalString.get("implementation.  However, we didn't consider memory consumption ") + LocalString.get("optimization in this implementation.\n\n");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option(LocalString.get("\tSet number of folds for REP\n") + LocalString.get("\tOne fold is used as pruning set.\n") + LocalString.get("\t(default 3)"), "F", 1, LocalString.get("-F <number of folds>")));
        vector.addElement(new Option(LocalString.get("\tSet the minimal weights of instances\n") + LocalString.get("\twithin a split.\n") + LocalString.get("\t(default 2.0)"), "N", 1, LocalString.get("-N <min. weights>")));
        vector.addElement(new Option(LocalString.get("\tSet the number of runs of\n") + LocalString.get("\toptimizations. (Default: 2)"), "O", 1, LocalString.get("-O <number of runs>")));
        vector.addElement(new Option(LocalString.get("\tSet whether turn on the\n") + LocalString.get("\tdebug mode (Default: false)"), "D", 0, "-D"));
        vector.addElement(new Option(LocalString.get("\tThe seed of randomization\n") + LocalString.get("\t(Default: 1)"), "S", 1, LocalString.get("-S <seed>")));
        vector.addElement(new Option(LocalString.get("Whether NOT check the error rate>=0.5\n") + LocalString.get("\tin stopping criteria ") + LocalString.get("\t(default: check)"), "E", 0, "-E"));
        vector.addElement(new Option(LocalString.get("Whether NOT use pruning\n") + LocalString.get("\t(default: use pruning)"), "P", 0, "-P"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('F', stringArray);
        this.m_Folds = string.length() != 0 ? Integer.parseInt(string) : 3;
        String string2 = Utils.getOption('N', stringArray);
        this.m_MinNo = string2.length() != 0 ? Double.parseDouble(string2) : 2.0;
        String string3 = Utils.getOption('S', stringArray);
        this.m_Seed = string3.length() != 0 ? Long.parseLong(string3) : 1L;
        String string4 = Utils.getOption('O', stringArray);
        this.m_Optimizations = string4.length() != 0 ? Integer.parseInt(string4) : 2;
        this.m_Debug = Utils.getFlag('D', stringArray);
        this.m_CheckErr = !Utils.getFlag('E', stringArray);
        this.m_UsePruning = !Utils.getFlag('P', stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[11];
        int n = 0;
        stringArray[n++] = "-F";
        stringArray[n++] = "" + this.m_Folds;
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.m_MinNo;
        stringArray[n++] = "-O";
        stringArray[n++] = "" + this.m_Optimizations;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.m_Seed;
        if (this.m_Debug) {
            stringArray[n++] = "-D";
        }
        if (!this.m_CheckErr) {
            stringArray[n++] = "-E";
        }
        if (!this.m_UsePruning) {
            stringArray[n++] = "-P";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement(LocalString.get("measureNumRules"));
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase(LocalString.get("measureNumRules")) == 0) {
            return this.m_Ruleset.size();
        }
        throw new IllegalArgumentException(string + LocalString.get(" not supported (RIPPER)"));
    }

    public String foldsTipText() {
        return LocalString.get("Determines the amount of data used for pruning. One fold is used for ") + LocalString.get("pruning, the rest for growing the rules.");
    }

    public void setFolds(int n) {
        this.m_Folds = n;
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String minNoTipText() {
        return LocalString.get("The minimum total weight of the instances in a rule.");
    }

    public void setMinNo(double d) {
        this.m_MinNo = d;
    }

    public double getMinNo() {
        return this.m_MinNo;
    }

    public String seedTipText() {
        return LocalString.get("The seed used for randomizing the data.");
    }

    public void setSeed(long l) {
        this.m_Seed = l;
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String optimizationsTipText() {
        return LocalString.get("The number of optimization runs.");
    }

    public void setOptimizations(int n) {
        this.m_Optimizations = n;
    }

    public int getOptimizations() {
        return this.m_Optimizations;
    }

    public String debugTipText() {
        return LocalString.get("Whether debug information is output to the console.");
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String checkErrorRateTipText() {
        return LocalString.get("Whether check for error rate >= 1/2 is included") + LocalString.get(" in stopping criterion.");
    }

    public void setCheckErrorRate(boolean bl) {
        this.m_CheckErr = bl;
    }

    public boolean getCheckErrorRate() {
        return this.m_CheckErr;
    }

    public String usePruningTipText() {
        return LocalString.get("Whether pruning is performed.");
    }

    public void setUsePruning(boolean bl) {
        this.m_UsePruning = bl;
    }

    public boolean getUsePruning() {
        return this.m_UsePruning;
    }

    public FastVector getRuleset() {
        return this.m_Ruleset;
    }

    public RuleStats getRuleStats(int n) {
        return (RuleStats)this.m_RulesetStats.elementAt(n);
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        if (instances.numInstances() == 0) {
            throw new Exception(LocalString.get(" No instances with a class value!"));
        }
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException(LocalString.get(" Cannot handle string attributes!"));
        }
        if (!instances.classAttribute().isNominal()) {
            throw new UnsupportedClassTypeException(LocalString.get(" Only nominal class, please."));
        }
        this.m_Random = instances.getRandomNumberGenerator(this.m_Seed);
        this.m_Total = RuleStats.numAllConditions(instances);
        if (this.m_Debug) {
            System.err.println(LocalString.get("Number of all possible conditions = ") + this.m_Total);
        }
        Instances instances2 = null;
        this.m_Filter = new ClassOrder();
        ((ClassOrder)this.m_Filter).setSeed(this.m_Random.nextInt());
        ((ClassOrder)this.m_Filter).setClassOrder(0);
        this.m_Filter.setInputFormat(instances);
        instances2 = Filter.useFilter(instances, this.m_Filter);
        if (instances2 == null) {
            throw new Exception(LocalString.get(" Unable to randomize the class orders."));
        }
        instances2.deleteWithMissingClass();
        if (instances2.numInstances() == 0) {
            throw new Exception(LocalString.get(" No instances with a class value!"));
        }
        if (instances2.numInstances() < this.m_Folds) {
            throw new Exception(LocalString.get(" Not enough data for REP."));
        }
        this.m_Class = instances2.classAttribute();
        this.m_Ruleset = new FastVector();
        this.m_RulesetStats = new FastVector();
        this.m_Distributions = new FastVector();
        double[] dArray = ((ClassOrder)this.m_Filter).getClassCounts();
        if (this.m_Debug) {
            System.err.println(LocalString.get("Sorted classes:"));
            for (n = 0; n < this.m_Class.numValues(); ++n) {
                System.err.println(n + ": " + this.m_Class.value(n) + LocalString.get(" has ") + dArray[n] + LocalString.get(" instances."));
            }
        }
        for (n = 0; n < instances2.numClasses() - 1; ++n) {
            double d = n;
            if (this.m_Debug) {
                int n2 = (int)d;
                System.err.println(LocalString.get("\n\nClass ") + this.m_Class.value(n2) + "(" + n2 + "): " + dArray[n] + LocalString.get("instances\n") + "=====================================\n");
            }
            if (Utils.eq(dArray[n], 0.0)) continue;
            double d2 = 0.0;
            for (int i = n; i < dArray.length; ++i) {
                d2 += dArray[i];
            }
            double d3 = dArray[n] / d2;
            double d4 = 0.0;
            double d5 = 0.0;
            for (int i = 0; i < instances2.numInstances(); ++i) {
                Instance instance = instances2.instance(i);
                d5 += instance.weight();
                if ((int)instance.classValue() != n) continue;
                d4 += instance.weight();
            }
            if (!(d4 > 0.0)) continue;
            double d6 = RuleStats.dataDL(d3, 0.0, d5, 0.0, d4);
            if (Double.isNaN(d6) || Double.isInfinite(d6)) {
                throw new Exception(LocalString.get("Should never happen: ") + LocalString.get("defDL NaN or infinite!"));
            }
            if (this.m_Debug) {
                System.err.println(LocalString.get("The default DL = ") + d6);
            }
            instances2 = this.rulesetForOneClass(d3, instances2, d, d6);
        }
        RipperRule ripperRule = new RipperRule();
        ripperRule.setConsequent(instances2.numClasses() - 1);
        this.m_Ruleset.addElement(ripperRule);
        RuleStats ruleStats = new RuleStats();
        ruleStats.setData(instances2);
        ruleStats.setNumAllConds(this.m_Total);
        ruleStats.addAndUpdate(ripperRule);
        this.m_RulesetStats.addElement(ruleStats);
        for (int i = 0; i < this.m_RulesetStats.size(); ++i) {
            RuleStats ruleStats2 = (RuleStats)this.m_RulesetStats.elementAt(i);
            for (int j = 0; j < ruleStats2.getRulesetSize(); ++j) {
                double[] dArray2 = ruleStats2.getDistributions(j);
                Utils.normalize(dArray2);
                if (dArray2 == null) continue;
                this.m_Distributions.addElement(((ClassOrder)this.m_Filter).distributionsByOriginalIndex(dArray2));
            }
        }
    }

    public double[] distributionForInstance(Instance instance) {
        try {
            for (int i = 0; i < this.m_Ruleset.size(); ++i) {
                RipperRule ripperRule = (RipperRule)this.m_Ruleset.elementAt(i);
                if (!ripperRule.covers(instance)) continue;
                return (double[])this.m_Distributions.elementAt(i);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        System.err.println(LocalString.get("Should never happen!"));
        return new double[instance.classAttribute().numValues()];
    }

    protected Instances rulesetForOneClass(double d, Instances instances, double d2, double d3) throws Exception {
        double[] dArray;
        int n;
        Serializable serializable;
        Instances instances2;
        Instances instances3;
        boolean bl;
        Instances instances4 = instances;
        boolean bl2 = false;
        FastVector fastVector = new FastVector();
        double d4 = d3;
        double d5 = d3;
        Serializable serializable2 = null;
        boolean bl3 = bl = true;
        if (this.m_Debug) {
            System.err.println(LocalString.get("\n*** Building stage ***"));
        }
        while (!bl2 && bl3) {
            if (this.m_UsePruning) {
                instances4 = RuleStats.stratify(instances4, this.m_Folds, this.m_Random);
                Instances[] instancesArray = RuleStats.partition(instances4, this.m_Folds);
                instances3 = instancesArray[0];
                instances2 = instancesArray[1];
                serializable = new RipperRule();
                ((RipperRule)serializable).setConsequent(d2);
                if (this.m_Debug) {
                    System.err.println(LocalString.get("\nGrowing a rule ..."));
                }
                ((RipperRule)serializable).grow(instances3);
                if (this.m_Debug) {
                    System.err.println(LocalString.get("One rule found before pruning:") + ((RipperRule)serializable).toString(this.m_Class));
                }
                if (this.m_Debug) {
                    System.err.println(LocalString.get("\nPruning the rule ..."));
                }
                ((RipperRule)serializable).prune(instances2, false);
                if (this.m_Debug) {
                    System.err.println(LocalString.get("One rule found after pruning:") + ((RipperRule)serializable).toString(this.m_Class));
                }
            } else {
                serializable = new RipperRule();
                ((RipperRule)serializable).setConsequent(d2);
                if (this.m_Debug) {
                    System.err.println(LocalString.get("\nNo pruning: growing a rule ..."));
                }
                ((RipperRule)serializable).grow(instances4);
                if (this.m_Debug) {
                    System.err.println(LocalString.get("No pruning: one rule found:\n") + ((RipperRule)serializable).toString(this.m_Class));
                }
            }
            if (serializable2 == null) {
                serializable2 = new RuleStats();
                ((RuleStats)serializable2).setNumAllConds(this.m_Total);
                ((RuleStats)serializable2).setData(instances4);
            }
            ((RuleStats)serializable2).addAndUpdate((Rule)serializable);
            n = ((RuleStats)serializable2).getRuleset().size() - 1;
            if (Double.isNaN(d4 += ((RuleStats)serializable2).relativeDL(n, d, this.m_CheckErr)) || Double.isInfinite(d4)) {
                throw new Exception(LocalString.get("Should never happen: dl in ") + LocalString.get("building stage NaN or infinite!"));
            }
            if (this.m_Debug) {
                System.err.println(LocalString.get("Before optimization(") + n + LocalString.get("): the dl = ") + d4 + LocalString.get(" | best: ") + d5);
            }
            if (d4 < d5) {
                d5 = d4;
            }
            dArray = ((RuleStats)serializable2).getSimpleStats(n);
            if (this.m_Debug) {
                System.err.println(LocalString.get("The rule covers: ") + dArray[0] + LocalString.get(" | pos = ") + dArray[2] + LocalString.get(" | neg = ") + dArray[4] + LocalString.get("\nThe rule doesn't cover: ") + dArray[1] + LocalString.get(" | pos = ") + dArray[5]);
            }
            if (!(bl2 = this.checkStop(dArray, d5, d4))) {
                fastVector.addElement(serializable);
                instances4 = ((RuleStats)serializable2).getFiltered(n)[1];
                bl3 = Utils.gr(dArray[5], 0.0);
                if (!this.m_Debug) continue;
                System.err.println(LocalString.get("One rule added: has positive? ") + bl3);
                continue;
            }
            if (this.m_Debug) {
                System.err.println(LocalString.get("Quit rule"));
            }
            ((RuleStats)serializable2).removeLast();
        }
        serializable = null;
        if (this.m_UsePruning) {
            for (n = 0; n < this.m_Optimizations; ++n) {
                if (this.m_Debug) {
                    System.err.println(LocalString.get("\n*** Optimization: run #") + n + " ***");
                }
                instances4 = instances;
                serializable = new RuleStats();
                ((RuleStats)serializable).setData(instances4);
                ((RuleStats)serializable).setNumAllConds(this.m_Total);
                int n2 = 0;
                bl2 = false;
                boolean bl4 = false;
                bl3 = bl;
                d4 = d5 = d3;
                while (!bl2 && bl3) {
                    RipperRule ripperRule;
                    RipperRule ripperRule2;
                    bl4 = n2 >= fastVector.size();
                    instances4 = RuleStats.stratify(instances4, this.m_Folds, this.m_Random);
                    Instances[] instancesArray = RuleStats.partition(instances4, this.m_Folds);
                    instances3 = instancesArray[0];
                    instances2 = instancesArray[1];
                    if (this.m_Debug) {
                        System.err.println(LocalString.get("\nRule #") + n2 + LocalString.get("| isResidual?") + bl4 + LocalString.get("| data size: ") + instances4.sumOfWeights());
                    }
                    if (bl4) {
                        ripperRule2 = new RipperRule();
                        ripperRule2.setConsequent(d2);
                        if (this.m_Debug) {
                            System.err.println(LocalString.get("\nGrowing and pruning") + LocalString.get(" a new rule ..."));
                        }
                        ripperRule2.grow(instances3);
                        ripperRule2.prune(instances2, false);
                        ripperRule = ripperRule2;
                        if (this.m_Debug) {
                            System.err.println(LocalString.get("\nNew rule found: ") + ripperRule2.toString(this.m_Class));
                        }
                    } else {
                        Copyable copyable;
                        ripperRule2 = (RipperRule)fastVector.elementAt(n2);
                        boolean bl5 = false;
                        for (int i = 0; i < instances4.numInstances(); ++i) {
                            if (!ripperRule2.covers(instances4.instance(i))) continue;
                            bl5 = true;
                            break;
                        }
                        if (!bl5) {
                            ((RuleStats)serializable).addAndUpdate(ripperRule2);
                            ++n2;
                            continue;
                        }
                        if (this.m_Debug) {
                            System.err.println(LocalString.get("\nGrowing and pruning") + LocalString.get(" Replace ..."));
                        }
                        RipperRule ripperRule3 = new RipperRule();
                        ripperRule3.setConsequent(d2);
                        ripperRule3.grow(instances3);
                        instances2 = RuleStats.rmCoveredBySuccessives(instances2, fastVector, n2);
                        ripperRule3.prune(instances2, true);
                        if (this.m_Debug) {
                            System.err.println(LocalString.get("\nGrowing and pruning") + LocalString.get(" Revision ..."));
                        }
                        RipperRule ripperRule4 = (RipperRule)ripperRule2.copy();
                        Instances instances5 = new Instances(instances3, 0);
                        for (int i = 0; i < instances3.numInstances(); ++i) {
                            copyable = instances3.instance(i);
                            if (!ripperRule4.covers((Instance)copyable)) continue;
                            instances5.add((Instance)copyable);
                        }
                        ripperRule4.grow(instances5);
                        ripperRule4.prune(instances2, true);
                        double[][] dArray2 = new double[n2][6];
                        for (int i = 0; i < n2; ++i) {
                            dArray2[i] = ((RuleStats)serializable).getSimpleStats(i);
                        }
                        copyable = (FastVector)fastVector.copyElements();
                        ((FastVector)copyable).setElementAt(ripperRule3, n2);
                        RuleStats ruleStats = new RuleStats(instances, (FastVector)copyable);
                        ruleStats.setNumAllConds(this.m_Total);
                        ruleStats.countData(n2, instances4, dArray2);
                        dArray = ruleStats.getSimpleStats(n2);
                        if (this.m_Debug) {
                            System.err.println(LocalString.get("Replace rule covers: ") + dArray[0] + LocalString.get(" | pos = ") + dArray[2] + LocalString.get(" | neg = ") + dArray[4] + LocalString.get("\nThe rule doesn't cover: ") + dArray[1] + LocalString.get(" | pos = ") + dArray[5]);
                        }
                        double d6 = ruleStats.relativeDL(n2, d, this.m_CheckErr);
                        if (this.m_Debug) {
                            System.err.println(LocalString.get("\nReplace: ") + ripperRule3.toString(this.m_Class) + " |dl = " + d6);
                        }
                        if (Double.isNaN(d6) || Double.isInfinite(d6)) {
                            throw new Exception(LocalString.get("Should never happen: repDL") + LocalString.get("in optmz. stage NaN or ") + LocalString.get("infinite!"));
                        }
                        ((FastVector)copyable).setElementAt(ripperRule4, n2);
                        RuleStats ruleStats2 = new RuleStats(instances, (FastVector)copyable);
                        ruleStats2.setNumAllConds(this.m_Total);
                        ruleStats2.countData(n2, instances4, dArray2);
                        double d7 = ruleStats2.relativeDL(n2, d, this.m_CheckErr);
                        if (this.m_Debug) {
                            System.err.println(LocalString.get("Revision: ") + ripperRule4.toString(this.m_Class) + " |dl = " + d7);
                        }
                        if (Double.isNaN(d7) || Double.isInfinite(d7)) {
                            throw new Exception(LocalString.get("Should never happen: revDL") + LocalString.get("in optmz. stage NaN or ") + LocalString.get("infinite!"));
                        }
                        serializable2 = new RuleStats(instances, fastVector);
                        ((RuleStats)serializable2).setNumAllConds(this.m_Total);
                        ((RuleStats)serializable2).countData(n2, instances4, dArray2);
                        double d8 = ((RuleStats)serializable2).relativeDL(n2, d, this.m_CheckErr);
                        if (Double.isNaN(d8) || Double.isInfinite(d8)) {
                            throw new Exception(LocalString.get("Should never happen: oldDL") + LocalString.get("in optmz. stage NaN or ") + LocalString.get("infinite!"));
                        }
                        if (this.m_Debug) {
                            System.err.println(LocalString.get("Old rule: ") + ripperRule2.toString(this.m_Class) + " |dl = " + d8);
                        }
                        if (this.m_Debug) {
                            System.err.println(LocalString.get("\nrepDL: ") + d6 + LocalString.get("\nrevDL: ") + d7 + LocalString.get("\noldDL: ") + d8);
                        }
                        ripperRule = d8 <= d7 && d8 <= d6 ? ripperRule2 : (d7 <= d6 ? ripperRule4 : ripperRule3);
                    }
                    ((RuleStats)serializable).addAndUpdate(ripperRule);
                    dArray = ((RuleStats)serializable).getSimpleStats(n2);
                    if (bl4) {
                        d4 += ((RuleStats)serializable).relativeDL(n2, d, this.m_CheckErr);
                        if (this.m_Debug) {
                            System.err.println(LocalString.get("After optimization: the dl") + "=" + d4 + LocalString.get(" | best: ") + d5);
                        }
                        if (d4 < d5) {
                            d5 = d4;
                        }
                        if (!(bl2 = this.checkStop(dArray, d5, d4))) {
                            fastVector.addElement(ripperRule);
                        } else {
                            ((RuleStats)serializable).removeLast();
                            --n2;
                        }
                    } else {
                        fastVector.setElementAt(ripperRule, n2);
                    }
                    if (this.m_Debug) {
                        System.err.println(LocalString.get("The rule covers: ") + dArray[0] + LocalString.get(" | pos = ") + dArray[2] + LocalString.get(" | neg = ") + dArray[4] + LocalString.get("\nThe rule doesn't cover: ") + dArray[1] + LocalString.get(" | pos = ") + dArray[5]);
                        System.err.println(LocalString.get("\nRuleset so far: "));
                        for (int i = 0; i < fastVector.size(); ++i) {
                            System.err.println(i + ": " + ((RipperRule)fastVector.elementAt(i)).toString(this.m_Class));
                        }
                        System.err.println();
                    }
                    if (((RuleStats)serializable).getRulesetSize() > 0) {
                        instances4 = ((RuleStats)serializable).getFiltered(n2)[1];
                    }
                    bl3 = Utils.gr(dArray[5], 0.0);
                    ++n2;
                }
                if (fastVector.size() > n2 + 1) {
                    for (int i = n2 + 1; i < fastVector.size(); ++i) {
                        ((RuleStats)serializable).addAndUpdate((Rule)fastVector.elementAt(i));
                    }
                }
                if (this.m_Debug) {
                    System.err.println(LocalString.get("\nDeleting rules to decrease") + LocalString.get(" DL of the whole ruleset ..."));
                }
                ((RuleStats)serializable).reduceDL(d, this.m_CheckErr);
                if (this.m_Debug) {
                    int n3 = fastVector.size() - ((RuleStats)serializable).getRulesetSize();
                    System.err.println(n3 + LocalString.get(" rules are deleted") + LocalString.get(" after DL reduction procedure"));
                }
                fastVector = ((RuleStats)serializable).getRuleset();
                serializable2 = serializable;
            }
        }
        if (this.m_Debug) {
            System.err.println(LocalString.get("\nFinal ruleset: "));
            for (n = 0; n < fastVector.size(); ++n) {
                System.err.println(n + ": " + ((RipperRule)fastVector.elementAt(n)).toString(this.m_Class));
            }
            System.err.println();
        }
        this.m_Ruleset.appendElements(fastVector);
        this.m_RulesetStats.addElement(serializable2);
        if (fastVector.size() > 0) {
            return ((RuleStats)serializable2).getFiltered(fastVector.size() - 1)[1];
        }
        return instances;
    }

    private boolean checkStop(double[] dArray, double d, double d2) {
        if (d2 > d + MAX_DL_SURPLUS) {
            if (this.m_Debug) {
                System.err.println(LocalString.get("DL too large: ") + d2 + " | " + d);
            }
            return true;
        }
        if (!Utils.gr(dArray[2], 0.0)) {
            if (this.m_Debug) {
                System.err.println(LocalString.get("Too few positives."));
            }
            return true;
        }
        if (dArray[4] / dArray[0] >= 0.5) {
            if (this.m_CheckErr) {
                if (this.m_Debug) {
                    System.err.println(LocalString.get("Error too large: ") + dArray[4] + "/" + dArray[0]);
                }
                return true;
            }
            return false;
        }
        if (this.m_Debug) {
            System.err.println(LocalString.get("Continue."));
        }
        return false;
    }

    public String toString() {
        int n;
        if (this.m_Ruleset == null) {
            return LocalString.get("JRIP: No model built yet.");
        }
        StringBuffer stringBuffer = new StringBuffer(LocalString.get("JRIP rules:\n") + "===========\n\n");
        for (n = 0; n < this.m_RulesetStats.size(); ++n) {
            RuleStats ruleStats = (RuleStats)this.m_RulesetStats.elementAt(n);
            FastVector fastVector = ruleStats.getRuleset();
            for (int i = 0; i < fastVector.size(); ++i) {
                double[] dArray = ruleStats.getSimpleStats(i);
                stringBuffer.append(((RipperRule)fastVector.elementAt(i)).toString(this.m_Class) + " (" + dArray[0] + "/" + dArray[4] + ")\n");
            }
        }
        if (this.m_Debug) {
            System.err.println(LocalString.get("Inside m_Ruleset"));
            for (n = 0; n < this.m_Ruleset.size(); ++n) {
                System.err.println(((RipperRule)this.m_Ruleset.elementAt(n)).toString(this.m_Class));
            }
        }
        stringBuffer.append(LocalString.get("\nNumber of Rules : ") + this.m_Ruleset.size() + "\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new JRip(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    protected class RipperRule
    extends Rule {
        private double m_Consequent = -1.0;
        protected FastVector m_Antds = new FastVector();

        public void setConsequent(double d) {
            this.m_Consequent = d;
        }

        public double getConsequent() {
            return this.m_Consequent;
        }

        public Object copy() {
            RipperRule ripperRule = new RipperRule();
            ripperRule.setConsequent(this.getConsequent());
            ripperRule.m_Antds = (FastVector)this.m_Antds.copyElements();
            return ripperRule;
        }

        public boolean covers(Instance instance) {
            boolean bl = true;
            for (int i = 0; i < this.m_Antds.size(); ++i) {
                Antd antd = (Antd)this.m_Antds.elementAt(i);
                if (antd.covers(instance)) continue;
                bl = false;
                break;
            }
            return bl;
        }

        public boolean hasAntds() {
            if (this.m_Antds == null) {
                return false;
            }
            return this.m_Antds.size() > 0;
        }

        public double size() {
            return this.m_Antds.size();
        }

        private double computeDefAccu(Instances instances) {
            double d = 0.0;
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instance instance = instances.instance(i);
                if ((int)instance.classValue() != (int)this.m_Consequent) continue;
                d += instance.weight();
            }
            return d;
        }

        public void grow(Instances instances) throws Exception {
            int n;
            if (this.m_Consequent == -1.0) {
                throw new Exception(LocalString.get(" Consequent not set yet."));
            }
            Instances instances2 = instances;
            double d = instances2.sumOfWeights();
            if (!Utils.gr(d, 0.0)) {
                return;
            }
            double d2 = this.computeDefAccu(instances2);
            double d3 = (d2 + 1.0) / (d + 1.0);
            boolean[] blArray = new boolean[instances2.numAttributes()];
            for (n = 0; n < blArray.length; ++n) {
                blArray[n] = false;
            }
            n = blArray.length;
            for (int i = 0; i < this.m_Antds.size(); ++i) {
                Antd antd = (Antd)this.m_Antds.elementAt(i);
                if (antd.getAttr().isNumeric()) continue;
                blArray[antd.getAttr().index()] = true;
                --n;
            }
            while (Utils.gr(instances2.numInstances(), 0.0) && n > 0 && Utils.sm(d3, 1.0)) {
                double d4 = 0.0;
                Antd antd = null;
                Instances instances3 = null;
                Enumeration enumeration = instances2.enumerateAttributes();
                while (enumeration.hasMoreElements()) {
                    Instances instances4;
                    Attribute attribute = (Attribute)enumeration.nextElement();
                    if (JRip.this.m_Debug) {
                        System.err.println(LocalString.get("\nOne condition: size = ") + instances2.sumOfWeights());
                    }
                    Antd antd2 = null;
                    antd2 = attribute.isNumeric() ? new NumericAntd(attribute) : new NominalAntd(attribute);
                    if (blArray[attribute.index()] || (instances4 = this.computeInfoGain(instances2, d3, antd2)) == null) continue;
                    double d5 = antd2.getMaxInfoGain();
                    if (JRip.this.m_Debug) {
                        System.err.println(LocalString.get("Test of '") + antd2.toString() + LocalString.get("': infoGain = ") + d5 + LocalString.get(" | Accuracy = ") + antd2.getAccuRate() + "=" + antd2.getAccu() + "/" + antd2.getCover() + LocalString.get(" def. accuracy: ") + d3);
                    }
                    if (!(d5 > d4)) continue;
                    antd = antd2;
                    instances3 = instances4;
                    d4 = d5;
                }
                if (antd == null || Utils.sm(antd.getAccu(), JRip.this.m_MinNo)) break;
                if (!antd.getAttr().isNumeric()) {
                    blArray[antd.getAttr().index()] = true;
                    --n;
                }
                this.m_Antds.addElement(antd);
                instances2 = instances3;
                d3 = antd.getAccuRate();
            }
        }

        private Instances computeInfoGain(Instances instances, double d, Antd antd) {
            Instances instances2 = instances;
            Instances[] instancesArray = antd.splitData(instances2, d, this.m_Consequent);
            if (instancesArray != null) {
                return instancesArray[(int)antd.getAttrValue()];
            }
            return null;
        }

        public void prune(Instances instances, boolean bl) {
            int n;
            int n2;
            Instances instances2 = instances;
            double d = instances2.sumOfWeights();
            if (!Utils.gr(d, 0.0)) {
                return;
            }
            double d2 = this.computeDefAccu(instances2);
            if (JRip.this.m_Debug) {
                System.err.println(LocalString.get("Pruning with ") + d2 + LocalString.get(" positive data out of ") + d + LocalString.get(" instances"));
            }
            if ((n2 = this.m_Antds.size()) == 0) {
                return;
            }
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray3[i] = 0.0;
                dArray2[i] = 0.0;
                dArray[i] = 0.0;
            }
            double d3 = 0.0;
            for (int i = 0; i < n2; ++i) {
                Antd antd = (Antd)this.m_Antds.elementAt(i);
                Attribute attribute = antd.getAttr();
                Instances instances3 = instances2;
                instances2 = new Instances(instances3, 0);
                for (int j = 0; j < instances3.numInstances(); ++j) {
                    Instance instance = instances3.instance(j);
                    if (antd.covers(instance)) {
                        int n3 = i;
                        dArray2[n3] = dArray2[n3] + instance.weight();
                        instances2.add(instance);
                        if ((int)instance.classValue() != (int)this.m_Consequent) continue;
                        int n4 = i;
                        dArray3[n4] = dArray3[n4] + instance.weight();
                        continue;
                    }
                    if (!bl || (int)instance.classValue() == (int)this.m_Consequent) continue;
                    d3 += instance.weight();
                }
                if (bl) {
                    int n5 = i;
                    dArray3[n5] = dArray3[n5] + d3;
                    dArray[i] = dArray3[i] / d;
                    continue;
                }
                dArray[i] = (dArray3[i] + 1.0) / (dArray2[i] + 2.0);
            }
            double d4 = (d2 + 1.0) / (d + 2.0);
            int n6 = -1;
            for (n = 0; n < dArray3.length; ++n) {
                if (JRip.this.m_Debug) {
                    double d5 = bl ? d : dArray2[n];
                    System.err.println(n + LocalString.get("(useAccuray? ") + !bl + "): " + dArray[n] + "=" + dArray3[n] + "/" + d5);
                }
                if (!(dArray[n] > d4)) continue;
                d4 = dArray[n];
                n6 = n;
            }
            for (n = n2 - 1; n > n6; --n) {
                this.m_Antds.removeElementAt(n);
            }
        }

        public String toString(Attribute attribute) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_Antds.size() > 0) {
                for (int i = 0; i < this.m_Antds.size() - 1; ++i) {
                    stringBuffer.append("(" + ((Antd)this.m_Antds.elementAt(i)).toString() + LocalString.get(") and "));
                }
                stringBuffer.append("(" + ((Antd)this.m_Antds.lastElement()).toString() + ")");
            }
            stringBuffer.append(" => " + attribute.name() + "=" + attribute.value((int)this.m_Consequent));
            return stringBuffer.toString();
        }
    }

    private class NominalAntd
    extends Antd {
        private double[] accurate;
        private double[] coverage;

        public NominalAntd(Attribute attribute) {
            super(attribute);
            int n = this.att.numValues();
            this.accurate = new double[n];
            this.coverage = new double[n];
        }

        public Object copy() {
            NominalAntd nominalAntd = new NominalAntd(this.getAttr());
            nominalAntd.value = this.value;
            return nominalAntd;
        }

        public Instances[] splitData(Instances instances, double d, double d2) {
            int n;
            int n2 = this.att.numValues();
            Instances[] instancesArray = new Instances[n2];
            for (n = 0; n < n2; ++n) {
                instancesArray[n] = new Instances(instances, instances.numInstances());
                this.accurate[n] = 0.0;
                this.coverage[n] = 0.0;
            }
            for (n = 0; n < instances.numInstances(); ++n) {
                Instance instance = instances.instance(n);
                if (instance.isMissing(this.att)) continue;
                int n3 = (int)instance.value(this.att);
                instancesArray[n3].add(instance);
                int n4 = n3;
                this.coverage[n4] = this.coverage[n4] + instance.weight();
                if ((int)instance.classValue() != (int)d2) continue;
                int n5 = n3;
                this.accurate[n5] = this.accurate[n5] + instance.weight();
            }
            for (n = 0; n < n2; ++n) {
                double d3 = this.accurate[n] + 1.0;
                double d4 = this.coverage[n] + 1.0;
                double d5 = this.accurate[n] * (Utils.log2(d3 / d4) - Utils.log2(d));
                if (!(d5 > this.maxInfoGain)) continue;
                this.maxInfoGain = d5;
                this.cover = this.coverage[n];
                this.accu = this.accurate[n];
                this.accuRate = d3 / d4;
                this.value = n;
            }
            return instancesArray;
        }

        public boolean covers(Instance instance) {
            boolean bl = false;
            if (!instance.isMissing(this.att) && (int)instance.value(this.att) == (int)this.value) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            return this.att.name() + " = " + this.att.value((int)this.value);
        }
    }

    private class NumericAntd
    extends Antd {
        private double splitPoint = Double.NaN;

        public NumericAntd(Attribute attribute) {
            super(attribute);
        }

        public double getSplitPoint() {
            return this.splitPoint;
        }

        public Object copy() {
            NumericAntd numericAntd = new NumericAntd(this.getAttr());
            numericAntd.value = this.value;
            numericAntd.splitPoint = this.splitPoint;
            return numericAntd;
        }

        public Instances[] splitData(Instances instances, double d, double d2) {
            Instance instance;
            int n;
            Instances instances2 = instances;
            int n2 = instances2.numInstances();
            int n3 = 1;
            int n4 = 0;
            int n5 = n3;
            this.maxInfoGain = 0.0;
            this.value = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            instances2.sort(this.att);
            for (n = 0; n < instances2.numInstances(); ++n) {
                instance = instances2.instance(n);
                if (instance.isMissing(this.att)) {
                    n2 = n;
                    break;
                }
                d4 += instance.weight();
                if (!Utils.eq(instance.classValue(), d2)) continue;
                d6 += instance.weight();
            }
            if (n2 == 0) {
                return null;
            }
            this.splitPoint = instances2.instance(n2 - 1).value(this.att);
            while (n3 <= n2) {
                if (n3 == n2 || instances2.instance(n3).value(this.att) > instances2.instance(n4).value(this.att)) {
                    double d7;
                    double d8;
                    double d9;
                    double d10;
                    boolean bl;
                    double d11;
                    for (n = n4; n < n3; ++n) {
                        instance = instances2.instance(n);
                        d3 += instance.weight();
                        if (!Utils.eq(instances2.instance(n).classValue(), d2)) continue;
                        d5 += instance.weight();
                    }
                    double d12 = (d5 + 1.0) / (d3 + 1.0);
                    double d13 = (d6 + 1.0) / (d4 + 1.0);
                    double d14 = d5 * (Utils.log2(d12) - Utils.log2(d));
                    if (d14 > (d11 = d6 * (Utils.log2(d13) - Utils.log2(d)))) {
                        bl = true;
                        d10 = d14;
                        d9 = d12;
                        d8 = d5;
                        d7 = d3;
                    } else {
                        bl = false;
                        d10 = d11;
                        d9 = d13;
                        d8 = d6;
                        d7 = d4;
                    }
                    if (d10 > this.maxInfoGain) {
                        this.splitPoint = instances2.instance(n4).value(this.att);
                        this.value = bl ? 0.0 : 1.0;
                        this.accuRate = d9;
                        this.accu = d8;
                        this.cover = d7;
                        this.maxInfoGain = d10;
                        n5 = bl ? n3 : n4;
                    }
                    for (int i = n4; i < n3; ++i) {
                        Instance instance2 = instances2.instance(i);
                        d4 -= instance2.weight();
                        if (!Utils.eq(instances2.instance(i).classValue(), d2)) continue;
                        d6 -= instance2.weight();
                    }
                    n4 = n3;
                }
                ++n3;
            }
            Instances[] instancesArray = new Instances[]{new Instances(instances2, 0, n5), new Instances(instances2, n5, n2 - n5)};
            return instancesArray;
        }

        public boolean covers(Instance instance) {
            boolean bl = true;
            if (!instance.isMissing(this.att)) {
                if ((int)this.value == 0) {
                    if (instance.value(this.att) > this.splitPoint) {
                        bl = false;
                    }
                } else if (instance.value(this.att) < this.splitPoint) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            String string = (int)this.value == 0 ? " <= " : " >= ";
            return this.att.name() + string + Utils.doubleToString(this.splitPoint, 6);
        }
    }

    private abstract class Antd
    implements WeightedInstancesHandler,
    Copyable,
    Serializable {
        protected Attribute att;
        protected double value;
        protected double maxInfoGain;
        protected double accuRate;
        protected double cover;
        protected double accu;

        public Antd(Attribute attribute) {
            this.att = attribute;
            this.value = Double.NaN;
            this.maxInfoGain = 0.0;
            this.accuRate = Double.NaN;
            this.cover = Double.NaN;
            this.accu = Double.NaN;
        }

        public abstract Instances[] splitData(Instances var1, double var2, double var4);

        public abstract boolean covers(Instance var1);

        public abstract String toString();

        public abstract Object copy();

        public Attribute getAttr() {
            return this.att;
        }

        public double getAttrValue() {
            return this.value;
        }

        public double getMaxInfoGain() {
            return this.maxInfoGain;
        }

        public double getAccuRate() {
            return this.accuRate;
        }

        public double getAccu() {
            return this.accu;
        }

        public double getCover() {
            return this.cover;
        }
    }
}

