/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSA;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskBar;

public class TaskItem
extends Item {
    TaskBar parent;
    Shell shell;
    int progress;
    int progressState = -1;
    Image overlayImage;
    String overlayText = "";
    boolean showingText = false;
    Menu menu;
    static final int PROGRESS_MAX = 100;

    TaskItem(TaskBar taskBar, int n) {
        super(taskBar, n);
        this.parent = taskBar;
        taskBar.createItem(this, -1);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    @Override
    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Image getOverlayImage() {
        this.checkWidget();
        return this.overlayImage;
    }

    public String getOverlayText() {
        this.checkWidget();
        return this.overlayText;
    }

    public TaskBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getProgress() {
        this.checkWidget();
        return this.progress;
    }

    public int getProgressState() {
        this.checkWidget();
        return this.progressState;
    }

    void recreate() {
        if (this.showingText) {
            if (this.overlayText.length() != 0) {
                this.updateText();
            }
        } else if (this.overlayImage != null) {
            this.updateImage();
        }
        if (this.progress != 0) {
            this.updateProgress();
        }
        if (this.progressState != -1) {
            this.updateProgressState();
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.overlayImage = null;
        this.overlayText = null;
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
        }
        if (this.shell != null) {
            return;
        }
        this.menu = menu;
        this.parent.setMenu(menu);
    }

    public void setOverlayImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (this.shell == null) {
            return;
        }
        this.overlayImage = image;
        if (image != null) {
            this.updateImage();
        } else if (this.overlayText.length() != 0) {
            this.updateText();
        } else {
            int n = this.parent.mTaskbarList3;
            int n2 = this.shell.handle;
            OS.VtblCall(18, n, n2, 0, 0);
        }
    }

    public void setOverlayText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.shell == null) {
            return;
        }
        this.overlayText = string;
        if (string.length() != 0) {
            this.updateText();
        } else if (this.overlayImage != null) {
            this.updateImage();
        } else {
            int n = this.parent.mTaskbarList3;
            int n2 = this.shell.handle;
            OS.VtblCall(18, n, n2, 0, 0);
        }
    }

    public void setProgress(int n) {
        this.checkWidget();
        if (this.shell == null) {
            return;
        }
        if (this.progress == (n = Math.max(0, Math.min(n, 100)))) {
            return;
        }
        this.progress = n;
        this.updateProgress();
    }

    public void setProgressState(int n) {
        this.checkWidget();
        if (this.shell == null) {
            return;
        }
        if (this.progressState == n) {
            return;
        }
        this.progressState = n;
        this.updateProgressState();
    }

    void setShell(Shell shell) {
        this.shell = shell;
        shell.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (TaskItem.this.isDisposed()) {
                    return;
                }
                TaskItem.this.dispose();
            }
        });
    }

    void updateImage() {
        this.showingText = false;
        Image image = null;
        int n = 0;
        switch (this.overlayImage.type) {
            case 0: {
                image = Display.createIcon(this.overlayImage);
                n = image.handle;
                break;
            }
            case 1: {
                n = this.overlayImage.handle;
            }
        }
        int n2 = this.parent.mTaskbarList3;
        int n3 = this.shell.handle;
        OS.VtblCall(18, n2, n3, n, 0);
        if (image != null) {
            image.dispose();
        }
    }

    void updateProgress() {
        if (this.progressState == 2) {
            return;
        }
        if (this.progressState == -1) {
            return;
        }
        int n = this.parent.mTaskbarList3;
        int n2 = this.shell.handle;
        OS.VtblCall(9, n, n2, (long)this.progress, 100L);
    }

    void updateProgressState() {
        int n = 0;
        switch (this.progressState) {
            case 0: {
                n = 2;
                break;
            }
            case 1: {
                n = 4;
                break;
            }
            case 4: {
                n = 8;
                break;
            }
            case 2: {
                n = 1;
            }
        }
        int n2 = this.parent.mTaskbarList3;
        int n3 = this.shell.handle;
        OS.VtblCall(9, n2, n3, (long)this.progress, 100L);
        OS.VtblCall(10, n2, n3, n);
    }

    void updateText() {
        this.showingText = true;
        int n = 16;
        int n2 = 16;
        int n3 = OS.GetDC(0);
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = n;
        bITMAPINFOHEADER.biHeight = -n2;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)32;
        bITMAPINFOHEADER.biCompression = 0;
        byte[] byArray = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        int[] nArray = new int[1];
        int n4 = OS.CreateDIBSection(0, byArray, 0, nArray, 0, 0);
        if (n4 == 0) {
            this.error(2);
        }
        int n5 = OS.CreateCompatibleDC(n3);
        int n6 = OS.SelectObject(n5, n4);
        int n7 = OS.CreateBitmap(n, n2, 1, 1, null);
        if (n7 == 0) {
            this.error(2);
        }
        int n8 = OS.CreateCompatibleDC(n3);
        int n9 = OS.SelectObject(n8, n7);
        OS.PatBlt(n8, 0, 0, n, n2, 16711778);
        int n10 = OS.SelectObject(n8, OS.GetStockObject(4));
        OS.RoundRect(n8, 0, 0, n, n2, 8, 8);
        OS.SelectObject(n8, n10);
        int n11 = OS.CreateSolidBrush(OS.GetSysColor(OS.COLOR_HIGHLIGHT));
        n10 = OS.SelectObject(n5, n11);
        OS.RoundRect(n5, 0, 0, n, n2, 8, 8);
        OS.SelectObject(n5, n10);
        OS.DeleteObject(n11);
        int n12 = 2080;
        RECT rECT = new RECT();
        TCHAR tCHAR = new TCHAR(this.shell.getCodePage(), this.overlayText, false);
        int n13 = tCHAR.length();
        int n14 = 0;
        int n15 = 0;
        NONCLIENTMETRICS nONCLIENTMETRICS = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
        nONCLIENTMETRICS.cbSize = NONCLIENTMETRICS.sizeof;
        if (OS.SystemParametersInfo(41, 0, nONCLIENTMETRICS, 0)) {
            LOGFONT lOGFONT = OS.IsUnicode ? nONCLIENTMETRICS.lfMessageFont : ((NONCLIENTMETRICSA)nONCLIENTMETRICS).lfMessageFont;
            lOGFONT.lfHeight = -10;
            n14 = OS.CreateFontIndirect(lOGFONT);
            n15 = OS.SelectObject(n5, n14);
            OS.DrawText(n5, tCHAR, n13, rECT, n12 | 0x400);
            if (rECT.right > n - 2) {
                OS.SelectObject(n5, n15);
                OS.DeleteObject(n14);
                lOGFONT.lfHeight = -8;
                n14 = OS.CreateFontIndirect(lOGFONT);
                OS.SelectObject(n5, n14);
            }
        }
        OS.DrawText(n5, tCHAR, n13, rECT, n12 | 0x400);
        OS.OffsetRect(rECT, (n - rECT.right) / 2, (n2 - rECT.bottom) / 2);
        int n16 = OS.SetBkMode(n5, 1);
        OS.SetTextColor(n5, OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT));
        OS.DrawText(n5, tCHAR, n13, rECT, n12);
        if (n14 != 0) {
            OS.SelectObject(n5, n15);
            OS.DeleteObject(n14);
        }
        OS.SetBkMode(n5, n16);
        OS.SelectObject(n5, n6);
        OS.DeleteDC(n5);
        OS.SelectObject(n8, n9);
        OS.DeleteDC(n8);
        OS.ReleaseDC(0, n3);
        ICONINFO iCONINFO = new ICONINFO();
        iCONINFO.fIcon = true;
        iCONINFO.hbmColor = n4;
        iCONINFO.hbmMask = n7;
        int n17 = OS.CreateIconIndirect(iCONINFO);
        if (n17 == 0) {
            this.error(2);
        }
        OS.DeleteObject(n4);
        OS.DeleteObject(n7);
        int n18 = this.parent.mTaskbarList3;
        int n19 = this.shell.handle;
        OS.VtblCall(18, n18, n19, n17, 0);
        OS.DestroyIcon(n17);
    }
}

