/**
 * WAR02 Animation Editor.
 * Copyright (C)2006  Hiroki.Uematsu
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * @copyright 2006 Hiroki.Uematsu
 * @version   CVS: $Id$
 * @link      http://war02.sourceforge.jp/
 */

#include "StdAfx.h"
#include "MotionCollection.h"

using namespace System;
using namespace Collections::Generic;

namespace war02 {
namespace core {

    /**
     * RXgN^
     * @private
     */
    MotionCollection::MotionCollection(void)
    {
        motionList = gcnew Dictionary<Int32, Motion^>();
        
        //[V̏s
        //IɁAƂƂŏǂ
        motionList->Add(MotionID::Normal, gcnew Motion(MotionID::Normal, L"ʏ"));
        motionList->Add(MotionID::Walk,   gcnew Motion(MotionID::Walk,   L""));
        motionList->Add(MotionID::Dash,   gcnew Motion(MotionID::Dash,   L"_bV"));
        motionList->Add(MotionID::Punch,  gcnew Motion(MotionID::Punch,  L"p`"));
        motionList->Add(MotionID::Kick,   gcnew Motion(MotionID::Kick,   L"LbN"));
        motionList->Add(MotionID::Jump,   gcnew Motion(MotionID::Jump,   L"Wv"));
    }


    /**
     * NX̃CX^XԂBsingletonłB
     * @return NX̃CX^X
     */
    MotionCollection^
    MotionCollection::getInstance()
    {
        if(instance == nullptr)
        {
            instance = gcnew MotionCollection();
        }
        return instance;
    }


    /**
     * w肳ꂽID̃[VԂ
     * @param id [VID
     * @return [V
     */
    Motion^
    MotionCollection::getMotion(Int32 id)
    {
        Motion^ motion = nullptr;
        if(!motionList->TryGetValue(id, motion))
        {
            //ۂɂ͗O
            return nullptr;
        }
        return motion;
    }


    /**
     * [Ṽe[uԂ
     * @return [Ṽe[u
     */
    Dictionary<Int32, Motion^>^
    MotionCollection::getMotionList()
    {
        return motionList;
    }


    /**
     * [Ṽe[uzɊi[ĕԂ
     * @return [Ṽe[u
     */
    array<Motion^>^
    MotionCollection::getMotionArray()
    {
        array<Motion^>^ arr = gcnew array<Motion^>(motionList->Count);
        Int32 i=0;
        for each(KeyValuePair<Int32, Motion^> kvp in motionList) {
            arr->SetValue(kvp.Value, i++);
        }
        return arr;
    }


} // namespace core
} // namespace war02
