/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.ant;

import com.oracle.tools.packager.Log;
import com.sun.javafx.tools.ant.AntLog;
import com.sun.javafx.tools.ant.Application;
import com.sun.javafx.tools.ant.Callbacks;
import com.sun.javafx.tools.ant.FileSet;
import com.sun.javafx.tools.ant.Info;
import com.sun.javafx.tools.ant.Platform;
import com.sun.javafx.tools.ant.Preferences;
import com.sun.javafx.tools.ant.Resources;
import com.sun.javafx.tools.ant.Utils;
import com.sun.javafx.tools.packager.DeployParams;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.PackagerLib;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;

public class DeployFXTask
extends Task
implements DynamicAttribute {
    private String width = null;
    private String height = null;
    private String embeddedWidth = null;
    private String embeddedHeight = null;
    private String outfile = null;
    private String outdir = null;
    private boolean embedJNLP;
    private boolean isExtension = false;
    private boolean includeDT = false;
    private String updateMode = "background";
    private Info appInfo = null;
    private Application app = null;
    private Resources resources = null;
    private Preferences prefs = null;
    private String codebase = null;
    private String placeholder;
    private PackagerLib packager;
    private DeployParams deployParams;
    private Callbacks callbacks;
    boolean offlineAllowed = true;
    Bundler.BundleType nativeBundles = Bundler.BundleType.NONE;
    String bundleFormat = null;
    private boolean verbose = false;
    List<Template> templateList = new LinkedList<Template>();
    Platform platform;
    private Permissions perms = null;
    List<BundleArgument> bundleArgumentList = new LinkedList<BundleArgument>();

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setCodebase(String string) {
        this.codebase = string;
    }

    public DeployFXTask() {
        this.packager = new PackagerLib();
        this.deployParams = new DeployParams();
    }

    public void execute() {
        this.deployParams.setOutfile(this.outfile);
        this.deployParams.setOutdir(new File(this.outdir));
        this.deployParams.setOfflineAllowed(this.offlineAllowed);
        this.deployParams.setVerbose(this.verbose);
        this.deployParams.setCodebase(this.codebase);
        if (this.width != null) {
            this.deployParams.setWidth(Integer.valueOf(this.width));
        }
        if (this.height != null) {
            this.deployParams.setHeight(Integer.valueOf(this.height));
        }
        if (this.embeddedWidth != null && this.embeddedHeight != null) {
            this.deployParams.setEmbeddedDimensions(this.embeddedWidth, this.embeddedHeight);
        }
        this.deployParams.setEmbedJNLP(this.embedJNLP);
        if (this.perms != null) {
            this.deployParams.setEmbedCertifcates(this.perms.embed);
            this.deployParams.setAllPermissions(this.perms.elevated);
        }
        if (this.app != null) {
            this.deployParams.setApplicationClass(this.app.get().mainClass);
            this.deployParams.setPreloader(this.app.get().preloaderClass);
            this.deployParams.setAppId(this.app.get().id);
            this.deployParams.setAppName(this.app.get().name);
            this.deployParams.setParams(this.app.get().parameters);
            this.deployParams.setArguments(this.app.get().getArguments());
            this.deployParams.setHtmlParams(this.app.get().htmlParameters);
            this.deployParams.setFallback(this.app.get().fallbackApp);
            this.deployParams.setSwingAppWithEmbeddedJavaFX(this.app.get().embeddedIntoSwing);
            this.deployParams.setVersion(this.app.get().version);
            this.deployParams.setId(this.app.get().id);
            this.deployParams.setServiceHint(this.app.get().daemon);
        }
        if (this.appInfo != null) {
            this.deployParams.setTitle(this.appInfo.title);
            this.deployParams.setVendor(this.appInfo.vendor);
            this.deployParams.setDescription(this.appInfo.appDescription);
            this.deployParams.setCategory(this.appInfo.category);
            this.deployParams.setLicenseType(this.appInfo.licenseType);
            this.deployParams.setCopyright(this.appInfo.copyright);
            this.deployParams.setEmail(this.appInfo.email);
            for (Info.Icon object : this.appInfo.icons) {
                if (object instanceof Info.Splash) {
                    this.deployParams.addIcon(object.href, object.kind, object.width, object.height, object.depth, ((Info.Splash)object).mode);
                    continue;
                }
                this.deployParams.addIcon(object.href, object.kind, object.width, object.height, object.depth, DeployParams.RunMode.WEBSTART);
            }
        }
        this.deployParams.setUpdateMode(this.updateMode);
        this.deployParams.setExtension(this.isExtension);
        this.deployParams.setIncludeDT(this.includeDT);
        if (this.platform != null) {
            Platform platform = this.platform.get();
            if (platform.j2se != null) {
                this.deployParams.setJRE(platform.j2se);
            }
            if (platform.javafx != null) {
                this.deployParams.setJavafx(platform.javafx);
            }
            if (platform.javaRoot != null) {
                if ("".equals(platform.javaRoot)) {
                    this.deployParams.setJavaRuntimeSource(null);
                } else {
                    this.deployParams.setJavaRuntimeSource(new File(platform.javaRoot));
                }
            }
            for (Platform.Property property : platform.properties) {
                this.deployParams.addJvmProperty(property.name, property.value);
            }
            for (Platform.Jvmarg jvmarg : platform.jvmargs) {
                this.deployParams.addJvmArg(jvmarg.value);
            }
            for (Platform.Property property : platform.jvmUserArgs) {
                this.deployParams.addJvmUserArg(property.name, property.value);
            }
        }
        if (this.callbacks != null) {
            this.deployParams.setCallbacks(this.callbacks.callbacks);
        }
        if (this.prefs != null) {
            this.deployParams.setNeedShortcut(this.prefs.getShortcut());
            this.deployParams.setNeedInstall(this.prefs.getInstall());
            this.deployParams.setNeedMenu(this.prefs.getMenu());
            this.deployParams.setSystemWide(this.prefs.getSystemInstall());
        }
        for (Template template : this.templateList) {
            this.deployParams.addTemplate(template.infile, template.outfile);
        }
        for (BundleArgument bundleArgument : this.bundleArgumentList) {
            this.deployParams.addBundleArgument(bundleArgument.arg, bundleArgument.value);
        }
        this.deployParams.setPlaceholder(this.placeholder);
        if (this.resources != null) {
            for (FileSet fileSet : this.resources.getResources()) {
                Utils.addResources(this.deployParams, fileSet);
            }
        }
        this.deployParams.setBundleType(this.nativeBundles);
        this.deployParams.setTargetFormat(this.bundleFormat);
        Log.setLogger(new AntLog(this.getProject()));
        try {
            this.packager.generateDeploymentPackages(this.deployParams);
        }
        catch (PackagerException packagerException) {
            if (packagerException.getCause() != null) {
                throw new BuildException(packagerException.getCause().getMessage(), packagerException.getCause());
            }
            throw new BuildException(packagerException.getMessage(), (Throwable)packagerException);
        }
        catch (Exception exception) {
            throw new BuildException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            Log.setLogger(null);
        }
    }

    public void setExtension(boolean bl) {
        this.isExtension = bl;
    }

    public void setNativeBundles(String string) {
        if ("false".equals(string) || "none".equals(string)) {
            this.nativeBundles = Bundler.BundleType.NONE;
        } else if ("all".equals(string) || "true".equals(string)) {
            this.nativeBundles = Bundler.BundleType.ALL;
        } else if ("image".equals(string)) {
            this.nativeBundles = Bundler.BundleType.IMAGE;
        } else if ("installer".equals(string)) {
            this.nativeBundles = Bundler.BundleType.INSTALLER;
        } else {
            this.nativeBundles = Bundler.BundleType.INSTALLER;
            this.bundleFormat = string != null ? string.toLowerCase() : null;
        }
    }

    public void setUpdateMode(String string) {
        String string2 = string.toLowerCase();
        if ("eager".equals(string2)) {
            string2 = "always";
        }
        if (!("always".equals(string2) || "background".equals(string2) || "timeout".equals(string2))) {
            throw new BuildException("Unknown update mode: [" + string2 + "]." + "Supported modes are: 'always', 'timeout' and 'background'");
        }
        this.updateMode = string2;
    }

    public void setOfflineAllowed(boolean bl) {
        this.offlineAllowed = bl;
    }

    public void setEmbeddedWidth(String string) {
        this.embeddedWidth = string;
    }

    public void setWidth(String string) {
        this.width = string;
    }

    public void setEmbeddedHeight(String string) {
        this.embeddedHeight = string;
    }

    public void setHeight(String string) {
        this.height = string;
    }

    public void setEmbedJNLP(boolean bl) {
        this.embedJNLP = bl;
    }

    public void setOutdir(String string) {
        this.outdir = string;
    }

    public void setOutfile(String string) {
        this.outfile = string;
    }

    public void setIncludeDT(Boolean bl) {
        this.includeDT = bl;
    }

    public void setPlaceholderRef(String string) {
        this.placeholder = string;
    }

    public void setPlaceholderId(String string) {
        this.placeholder = "'" + string + "'";
    }

    public Info createInfo() {
        this.appInfo = new Info();
        return this.appInfo;
    }

    public Application createApplication() {
        this.app = new Application();
        return this.app;
    }

    public Preferences createPreferences() {
        this.prefs = new Preferences();
        return this.prefs;
    }

    public Callbacks createCallbacks() {
        if (this.callbacks != null) {
            throw new BuildException("Only one callbacks element is supported.");
        }
        this.callbacks = new Callbacks();
        return this.callbacks;
    }

    public Resources createResources() {
        if (this.resources != null) {
            throw new BuildException("Only one resources element is supported.");
        }
        this.resources = new Resources();
        return this.resources;
    }

    public Template createTemplate() {
        Template template = new Template();
        this.templateList.add(template);
        return template;
    }

    public Platform createPlatform() {
        this.platform = new Platform();
        return this.platform;
    }

    public Permissions createPermissions() {
        this.perms = new Permissions();
        return this.perms;
    }

    public BundleArgument createBundleArgument() {
        BundleArgument bundleArgument = new BundleArgument();
        this.bundleArgumentList.add(bundleArgument);
        return bundleArgument;
    }

    public void setDynamicAttribute(String string, String string2) throws BuildException {
        this.bundleArgumentList.add(new BundleArgument(string, string2));
    }

    public static class BundleArgument
    extends DataType {
        String arg = null;
        String value = null;

        BundleArgument() {
        }

        BundleArgument(String string, String string2) {
            this.arg = string;
            this.value = string2;
        }

        public void setArg(String string) {
            this.arg = string;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }

    public static class Template
    extends DataType {
        File infile = null;
        File outfile = null;

        public void setFile(File file) {
            this.infile = file;
        }

        public void setTofile(File file) {
            this.outfile = file;
        }
    }

    public static class Permissions
    extends DataType {
        boolean embed = false;
        boolean elevated = true;

        public void setElevated(boolean bl) {
            this.elevated = bl;
        }

        public void setCacheCertificates(boolean bl) {
            this.embed = bl;
        }
    }
}

