/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.windows;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.windows.WinResources;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;

public class WinServiceBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(WinServiceBundler.class.getName());
    private static final String EXECUTABLE_SVC_NAME = "WinLauncherSvc.exe";

    public WinServiceBundler() {
        this.baseResourceLoader = WinResources.class;
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "windows.service";
    }

    @Override
    public String getBundleType() {
        return "IMAGE";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        return WinServiceBundler.getServiceBundleParameters();
    }

    public static Collection<BundlerParamInfo<?>> getServiceBundleParameters() {
        return Arrays.asList(StandardBundlerParam.APP_NAME, StandardBundlerParam.BUILD_ROOT);
    }

    @Override
    public boolean validate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        try {
            if (map == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            return this.doValidate(map);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ConfigException) {
                throw (ConfigException)runtimeException.getCause();
            }
            throw new ConfigException(runtimeException);
        }
    }

    boolean doValidate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            throw new UnsupportedPlatformException();
        }
        if (WinResources.class.getResource(EXECUTABLE_SVC_NAME) == null) {
            throw new ConfigException(I18N.getString("error.no-windows-resources"), I18N.getString("error.no-windows-resources.advice"));
        }
        return true;
    }

    @Override
    public File execute(Map<String, ? super Object> map, File file) {
        return this.doBundle(map, file, false);
    }

    static String getAppName(Map<String, ? super Object> map) {
        return (String)StandardBundlerParam.APP_NAME.fetchFrom(map);
    }

    static String getAppSvcName(Map<String, ? super Object> map) {
        return (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + "Svc";
    }

    public static File getLauncherSvc(File file, Map<String, ? super Object> map) {
        return new File(file, WinServiceBundler.getAppName(map) + "Svc.exe");
    }

    File doBundle(Map<String, ? super Object> map, File file, boolean bl) {
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), file.getAbsolutePath()));
        }
        if (!file.canWrite()) {
            throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), file.getAbsolutePath()));
        }
        try {
            if (!bl) {
                Log.info(MessageFormat.format(I18N.getString("message.creating-service-bundle"), WinServiceBundler.getAppSvcName(map), file.getAbsolutePath()));
            }
            File file2 = WinServiceBundler.getLauncherSvc(file, map);
            IOUtils.copyFromURL(WinResources.class.getResource(EXECUTABLE_SVC_NAME), file2);
            file2.setExecutable(true, false);
            if (!bl) {
                Log.info(MessageFormat.format(I18N.getString("message.result-dir"), file.getAbsolutePath()));
            }
            return file;
        }
        catch (IOException iOException) {
            Log.info("Exception: " + iOException);
            Log.debug(iOException);
            return null;
        }
    }
}

