/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.mac;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.mac.MacResources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class MacDaemonBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(MacDaemonBundler.class.getName());
    private static final String TEMPLATE_LAUNCHD_PLIST = "launchd.plist.template";
    public static final String MAC_BUNDLER_PREFIX = "package/macosx" + File.separator;
    public static final BundlerParamInfo<File> CONFIG_ROOT = new StandardBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, map -> {
        File file = new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)map), "macosx");
        file.mkdirs();
        return file;
    }, (string, map) -> new File((String)string));

    public MacDaemonBundler() {
        this.baseResourceLoader = MacResources.class;
    }

    private File getConfig_LaunchdPlist(Map<String, ? super Object> map) {
        return new File(CONFIG_ROOT.fetchFrom(map), "launchd.plist");
    }

    private void prepareConfigFiles(Map<String, ? super Object> map) throws IOException {
        File file = this.getConfig_LaunchdPlist(map);
        file.createNewFile();
        this.writeLaunchdPlist(file, map);
    }

    private String getDaemonIdentifier(Map<String, ? super Object> map) {
        return ((String)StandardBundlerParam.IDENTIFIER.fetchFrom(map)).toLowerCase() + ".daemon";
    }

    public String getAppName(Map<String, ? super Object> map) {
        return (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".app";
    }

    private String getLauncherName(Map<String, ? super Object> map) {
        if (StandardBundlerParam.APP_NAME.fetchFrom(map) != null) {
            return (String)StandardBundlerParam.APP_NAME.fetchFrom(map);
        }
        return (String)StandardBundlerParam.MAIN_CLASS.fetchFrom(map);
    }

    private String getDaemonLauncherPath(Map<String, ? super Object> map) {
        return "/Applications/" + this.getAppName(map) + "/Contents/MacOS/" + this.getLauncherName(map);
    }

    private void writeLaunchdPlist(File file, Map<String, ? super Object> map) throws IOException {
        Log.verbose(MessageFormat.format(I18N.getString("message.preparing-launchd-plist"), file.getAbsolutePath()));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("DEPLOY_DAEMON_IDENTIFIER", this.getDaemonIdentifier(map));
        hashMap.put("DEPLOY_DAEMON_LAUNCHER_PATH", this.getDaemonLauncherPath(map));
        hashMap.put("DEPLOY_RUN_AT_LOAD", String.valueOf(StandardBundlerParam.START_ON_INSTALL.fetchFrom(map)));
        hashMap.put("DEPLOY_KEEP_ALIVE", String.valueOf(StandardBundlerParam.RUN_AT_STARTUP.fetchFrom(map)));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(this.preprocessTextResource(MAC_BUNDLER_PREFIX + this.getConfig_LaunchdPlist(map).getName(), I18N.getString("resource.launchd-config"), TEMPLATE_LAUNCHD_PLIST, hashMap, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)));
        ((Writer)bufferedWriter).close();
    }

    protected void cleanupConfigFiles(Map<String, ? super Object> map) {
        if (CONFIG_ROOT.fetchFrom(map) != null && this.getConfig_LaunchdPlist(map) != null) {
            this.getConfig_LaunchdPlist(map).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File doBundle(Map<String, ? super Object> map, File file, boolean bl) {
        File file2;
        block10: {
            block9: {
                if (!file.isDirectory() && !file.mkdirs()) {
                    throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), file.getAbsolutePath()));
                }
                if (!file.canWrite()) {
                    throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), file.getAbsolutePath()));
                }
                file2 = null;
                try {
                    File file3 = (File)StandardBundlerParam.BUILD_ROOT.fetchFrom(map);
                    this.prepareConfigFiles(map);
                    file2 = new File(file, (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".daemon");
                    IOUtils.deleteRecursive(file2);
                    file2.mkdirs();
                    if (!bl) {
                        Log.info(MessageFormat.format(I18N.getString("message.creating-daemon-component"), file2.getAbsolutePath()));
                    }
                    File file4 = new File(file2, "Library");
                    file4.mkdirs();
                    File file5 = new File(file4, "LaunchDaemons");
                    file5.mkdirs();
                    IOUtils.copyFile(this.getConfig_LaunchdPlist(map), new File(file5, ((String)StandardBundlerParam.IDENTIFIER.fetchFrom(map)).toLowerCase() + ".launchd.plist"));
                    if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) break block9;
                    this.cleanupConfigFiles(map);
                    break block10;
                }
                catch (IOException iOException) {
                    File file6;
                    block11: {
                        try {
                            Log.verbose(iOException);
                            file6 = null;
                            if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) break block11;
                            this.cleanupConfigFiles(map);
                        }
                        catch (Throwable throwable) {
                            if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                                this.cleanupConfigFiles(map);
                            } else {
                                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(map).getAbsolutePath()));
                            }
                            throw throwable;
                        }
                    }
                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(map).getAbsolutePath()));
                    return file6;
                }
            }
            Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(map).getAbsolutePath()));
        }
        return file2;
    }

    @Override
    public String getName() {
        return I18N.getString("bundle.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundle.description");
    }

    @Override
    public String getID() {
        return "mac.daemon";
    }

    @Override
    public String getBundleType() {
        return "INSTALLER";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        return MacDaemonBundler.getDaemonBundleParameters();
    }

    public static Collection<BundlerParamInfo<?>> getDaemonBundleParameters() {
        return Arrays.asList(StandardBundlerParam.APP_NAME, StandardBundlerParam.BUILD_ROOT, StandardBundlerParam.IDENTIFIER, StandardBundlerParam.START_ON_INSTALL, StandardBundlerParam.RUN_AT_STARTUP);
    }

    @Override
    public boolean validate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        try {
            return this.doValidate(map);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ConfigException) {
                throw (ConfigException)runtimeException.getCause();
            }
            throw new ConfigException(runtimeException);
        }
    }

    public boolean doValidate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        if (!System.getProperty("os.name").toLowerCase().contains("os x")) {
            throw new UnsupportedPlatformException();
        }
        return true;
    }

    @Override
    public File execute(Map<String, ? super Object> map, File file) {
        return this.doBundle(map, file, false);
    }
}

