/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.mac;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.EnumeratedBundlerParam;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.JreUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.mac.MacBaseInstallerBundler;
import com.oracle.tools.packager.mac.MacResources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class MacAppBundler
extends AbstractBundler {
    private static final ResourceBundle I18N;
    public static final String MAC_BUNDLER_PREFIX;
    private static final String EXECUTABLE_NAME = "JavaAppLauncher";
    private static final String TEMPLATE_BUNDLE_ICON = "GenericApp.icns";
    private static final String OS_TYPE_CODE = "APPL";
    private static final String TEMPLATE_INFO_PLIST = "Info.plist.template";
    public static final EnumeratedBundlerParam<String> MAC_CATEGORY;
    public static final BundlerParamInfo<String> MAC_CF_BUNDLE_NAME;
    public static final BundlerParamInfo<String> MAC_CF_BUNDLE_IDENTIFIER;
    public static final BundlerParamInfo<File> CONFIG_ROOT;
    public static final BundlerParamInfo<URL> RAW_EXECUTABLE_URL;
    public static final BundlerParamInfo<String> DEFAULT_ICNS_ICON;
    public static final BundlerParamInfo<JreUtils.Rule[]> MAC_JDK_RULES;
    public static final BundlerParamInfo<RelativeFileSet> MAC_RUNTIME;
    public static final BundlerParamInfo<String> DEVELOPER_ID_APP_SIGNING_KEY;
    public static final BundlerParamInfo<String> BUNDLE_ID_SIGNING_PREFIX;
    public static final BundlerParamInfo<File> ICON_ICNS;

    private static Map<String, String> getMacCategories() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Business", "public.app-category.business");
        hashMap.put("Developer Tools", "public.app-category.developer-tools");
        hashMap.put("Education", "public.app-category.education");
        hashMap.put("Entertainment", "public.app-category.entertainment");
        hashMap.put("Finance", "public.app-category.finance");
        hashMap.put("Games", "public.app-category.games");
        hashMap.put("Graphics & Design", "public.app-category.graphics-design");
        hashMap.put("Healthcare & Fitness", "public.app-category.healthcare-fitness");
        hashMap.put("Lifestyle", "public.app-category.lifestyle");
        hashMap.put("Medical", "public.app-category.medical");
        hashMap.put("Music", "public.app-category.music");
        hashMap.put("News", "public.app-category.news");
        hashMap.put("Photography", "public.app-category.photography");
        hashMap.put("Productivity", "public.app-category.productivity");
        hashMap.put("Reference", "public.app-category.reference");
        hashMap.put("Social Networking", "public.app-category.social-networking");
        hashMap.put("Sports", "public.app-category.sports");
        hashMap.put("Travel", "public.app-category.travel");
        hashMap.put("Utilities", "public.app-category.utilities");
        hashMap.put("Video", "public.app-category.video");
        hashMap.put("Weather", "public.app-category.weather");
        hashMap.put("Action Games", "public.app-category.action-games");
        hashMap.put("Adventure Games", "public.app-category.adventure-games");
        hashMap.put("Arcade Games", "public.app-category.arcade-games");
        hashMap.put("Board Games", "public.app-category.board-games");
        hashMap.put("Card Games", "public.app-category.card-games");
        hashMap.put("Casino Games", "public.app-category.casino-games");
        hashMap.put("Dice Games", "public.app-category.dice-games");
        hashMap.put("Educational Games", "public.app-category.educational-games");
        hashMap.put("Family Games", "public.app-category.family-games");
        hashMap.put("Kids Games", "public.app-category.kids-games");
        hashMap.put("Music Games", "public.app-category.music-games");
        hashMap.put("Puzzle Games", "public.app-category.puzzle-games");
        hashMap.put("Racing Games", "public.app-category.racing-games");
        hashMap.put("Role Playing Games", "public.app-category.role-playing-games");
        hashMap.put("Simulation Games", "public.app-category.simulation-games");
        hashMap.put("Sports Games", "public.app-category.sports-games");
        hashMap.put("Strategy Games", "public.app-category.strategy-games");
        hashMap.put("Trivia Games", "public.app-category.trivia-games");
        hashMap.put("Word Games", "public.app-category.word-games");
        return hashMap;
    }

    public static RelativeFileSet extractMacRuntime(String string, Map<String, ? super Object> map) {
        if (string.isEmpty()) {
            return null;
        }
        if (string.endsWith("/Home")) {
            throw new IllegalArgumentException(I18N.getString("message.no-mac-jre-support"));
        }
        if (string.endsWith("/Home/jre")) {
            File file = new File(string).getParentFile().getParentFile().getParentFile();
            return JreUtils.extractJreAsRelativeFileSet(file.toString(), MAC_JDK_RULES.fetchFrom(map));
        }
        return JreUtils.extractJreAsRelativeFileSet(string, MAC_JDK_RULES.fetchFrom(map));
    }

    public MacAppBundler() {
        this.baseResourceLoader = MacResources.class;
    }

    @Override
    public boolean validate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        try {
            return this.doValidate(map);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ConfigException) {
                throw (ConfigException)runtimeException.getCause();
            }
            throw new ConfigException(runtimeException);
        }
    }

    public boolean doValidate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        if (!System.getProperty("os.name").toLowerCase().contains("os x")) {
            throw new UnsupportedPlatformException();
        }
        StandardBundlerParam.validateMainClassInfoFromAppResources(map);
        if (MacBaseInstallerBundler.getPredefinedImage(map) != null) {
            return true;
        }
        if (StandardBundlerParam.MAIN_JAR.fetchFrom(map) == null) {
            throw new ConfigException(I18N.getString("error.no-application-jar"), I18N.getString("error.no-application-jar.advice"));
        }
        this.testRuntime(MAC_RUNTIME.fetchFrom(map), new String[]{"Contents/Home/jre/lib/[^/]+/libjvm.dylib", "Contents/Home/jre/lib/rt.jar"});
        if (((Boolean)StandardBundlerParam.USE_FX_PACKAGING.fetchFrom(map)).booleanValue()) {
            this.testRuntime(MAC_RUNTIME.fetchFrom(map), new String[]{"Contents/Home/jre/lib/ext/jfxrt.jar", "Contents/Home/jre/lib/jfxrt.jar"});
        }
        return true;
    }

    private File getConfig_InfoPlist(Map<String, ? super Object> map) {
        return new File(CONFIG_ROOT.fetchFrom(map), "Info.plist");
    }

    private File getConfig_Icon(Map<String, ? super Object> map) {
        return new File(CONFIG_ROOT.fetchFrom(map), (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".icns");
    }

    private void prepareConfigFiles(Map<String, ? super Object> map) throws IOException {
        File file = this.getConfig_InfoPlist(map);
        file.createNewFile();
        this.writeInfoPlist(file, map);
        this.prepareIcon(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File doBundle(Map<String, ? super Object> map, File file, boolean bl) {
        File file2;
        block13: {
            block11: {
                File file3;
                block12: {
                    file2 = null;
                    if (!file.isDirectory() && !file.mkdirs()) {
                        throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), file.getAbsolutePath()));
                    }
                    if (!file.canWrite()) {
                        throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), file.getAbsolutePath()));
                    }
                    File file4 = MacBaseInstallerBundler.getPredefinedImage(map);
                    if (file4 == null) break block11;
                    file3 = file4;
                    if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) break block12;
                    this.cleanupConfigFiles(map);
                }
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(map).getAbsolutePath()));
                return file3;
            }
            try {
                StandardBundlerParam.BUILD_ROOT.fetchFrom(map);
                this.prepareConfigFiles(map);
                file2 = new File(file, (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".app");
                IOUtils.deleteRecursive(file2);
                file2.mkdirs();
                if (!bl) {
                    Log.info(MessageFormat.format(I18N.getString("message.creating-app-bundle"), file2.getAbsolutePath()));
                }
                File file5 = new File(file2, "Contents");
                file5.mkdirs();
                File file6 = new File(file5, "MacOS");
                file6.mkdirs();
                File file7 = new File(file5, "Java");
                file7.mkdirs();
                File file8 = new File(file5, "PlugIns");
                File file9 = new File(file5, "Resources");
                file9.mkdirs();
                File file10 = new File(file5, "PkgInfo");
                file10.createNewFile();
                this.writePkgInfo(file10);
                File file11 = new File(file6, this.getLauncherName(map));
                IOUtils.copyFromURL(RAW_EXECUTABLE_URL.fetchFrom(map), file11);
                file11.setExecutable(true, false);
                this.copyRuntime(file8, map);
                this.copyClassPathEntries(file7, map);
                IOUtils.copyFile(this.getConfig_Icon(map), new File(file9, this.getConfig_Icon(map).getName()));
                IOUtils.copyFile(this.getConfig_InfoPlist(map), new File(file5, "Info.plist"));
                String string = DEVELOPER_ID_APP_SIGNING_KEY.fetchFrom(map);
                if (string != null) {
                    MacBaseInstallerBundler.signAppBundle(map, file2, string, BUNDLE_ID_SIGNING_PREFIX.fetchFrom(map));
                }
                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) break block13;
                this.cleanupConfigFiles(map);
            }
            catch (IOException iOException) {
                File file12;
                block14: {
                    try {
                        Log.info(iOException.toString());
                        Log.verbose(iOException);
                        file12 = null;
                        if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) break block14;
                        this.cleanupConfigFiles(map);
                    }
                    catch (Throwable throwable) {
                        if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                            this.cleanupConfigFiles(map);
                        } else {
                            Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(map).getAbsolutePath()));
                        }
                        throw throwable;
                    }
                }
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(map).getAbsolutePath()));
                return file12;
            }
        }
        Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(map).getAbsolutePath()));
        return file2;
    }

    public String getAppName(Map<String, ? super Object> map) {
        return (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".app";
    }

    public void cleanupConfigFiles(Map<String, ? super Object> map) {
        if (CONFIG_ROOT.fetchFrom(map) != null) {
            if (this.getConfig_Icon(map) != null) {
                this.getConfig_Icon(map).delete();
            }
            if (this.getConfig_InfoPlist(map) != null) {
                this.getConfig_InfoPlist(map).delete();
            }
        }
    }

    private void copyClassPathEntries(File file, Map<String, ? super Object> map) throws IOException {
        RelativeFileSet relativeFileSet = (RelativeFileSet)StandardBundlerParam.APP_RESOURCES.fetchFrom(map);
        if (relativeFileSet == null) {
            throw new RuntimeException(I18N.getString("message.null-classpath"));
        }
        File file2 = relativeFileSet.getBaseDirectory();
        for (String string : relativeFileSet.getIncludedFiles()) {
            IOUtils.copyFile(new File(file2, string), new File(file, string));
        }
    }

    private void copyRuntime(File file, Map<String, ? super Object> map) throws IOException {
        RelativeFileSet relativeFileSet = MAC_RUNTIME.fetchFrom(map);
        if (relativeFileSet == null) {
            return;
        }
        file.mkdirs();
        File file2 = relativeFileSet.getBaseDirectory();
        File file3 = new File(file, file2.getName());
        Set<String> set = relativeFileSet.getIncludedFiles();
        for (String string : set) {
            IOUtils.copyFile(new File(file2, string), new File(file3, string));
        }
    }

    private void prepareIcon(Map<String, ? super Object> map) throws IOException {
        File file = ICON_ICNS.fetchFrom(map);
        if (file == null || !file.exists()) {
            this.fetchResource(MAC_BUNDLER_PREFIX + (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".icns", "icon", DEFAULT_ICNS_ICON.fetchFrom(map), this.getConfig_Icon(map), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)));
        } else {
            this.fetchResource(MAC_BUNDLER_PREFIX + (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".icns", "icon", file, this.getConfig_Icon(map), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)));
        }
    }

    private String getLauncherName(Map<String, ? super Object> map) {
        if (StandardBundlerParam.APP_NAME.fetchFrom(map) != null) {
            return (String)StandardBundlerParam.APP_NAME.fetchFrom(map);
        }
        return (String)StandardBundlerParam.MAIN_CLASS.fetchFrom(map);
    }

    private String getBundleName(Map<String, ? super Object> map) {
        if (MAC_CF_BUNDLE_NAME.fetchFrom(map) != null) {
            String string = MAC_CF_BUNDLE_NAME.fetchFrom(map);
            if (string.length() > 16) {
                Log.info(MessageFormat.format(I18N.getString("message.bundle-name-too-long-warning"), MAC_CF_BUNDLE_NAME.getID(), string));
            }
            return MAC_CF_BUNDLE_NAME.fetchFrom(map);
        }
        if (StandardBundlerParam.APP_NAME.fetchFrom(map) != null) {
            return (String)StandardBundlerParam.APP_NAME.fetchFrom(map);
        }
        String string = (String)StandardBundlerParam.MAIN_CLASS.fetchFrom(map);
        if (string.length() > 16) {
            string = string.substring(0, 16);
        }
        return string;
    }

    private void writeInfoPlist(File file, Map<String, ? super Object> map) throws IOException {
        Object object222;
        Log.verbose(MessageFormat.format(I18N.getString("message.preparing-info-plist"), file.getAbsolutePath()));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("DEPLOY_ICON_FILE", this.getConfig_Icon(map).getName());
        hashMap.put("DEPLOY_BUNDLE_IDENTIFIER", MAC_CF_BUNDLE_IDENTIFIER.fetchFrom(map));
        hashMap.put("DEPLOY_BUNDLE_NAME", this.getBundleName(map));
        hashMap.put("DEPLOY_BUNDLE_COPYRIGHT", StandardBundlerParam.COPYRIGHT.fetchFrom(map) != null ? (String)StandardBundlerParam.COPYRIGHT.fetchFrom(map) : "Unknown");
        hashMap.put("DEPLOY_LAUNCHER_NAME", this.getLauncherName(map));
        if (MAC_RUNTIME.fetchFrom(map) != null) {
            hashMap.put("DEPLOY_JAVA_RUNTIME_NAME", MAC_RUNTIME.fetchFrom(map).getBaseDirectory().getName());
        } else {
            hashMap.put("DEPLOY_JAVA_RUNTIME_NAME", "");
        }
        hashMap.put("DEPLOY_BUNDLE_SHORT_VERSION", StandardBundlerParam.VERSION.fetchFrom(map) != null ? (String)StandardBundlerParam.VERSION.fetchFrom(map) : "1.0.0");
        hashMap.put("DEPLOY_BUNDLE_CATEGORY", MAC_CATEGORY.validatedFetchFrom(map));
        hashMap.put("DEPLOY_MAIN_JAR_NAME", ((RelativeFileSet)StandardBundlerParam.MAIN_JAR.fetchFrom(map)).getIncludedFiles().iterator().next());
        hashMap.put("DEPLOY_PREFERENCES_ID", ((String)StandardBundlerParam.PREFERENCES_ID.fetchFrom(map)).toLowerCase());
        StringBuilder stringBuilder = new StringBuilder();
        List list = (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(map);
        String string = "";
        for (Object object222 : list) {
            stringBuilder.append(string).append("    <string>").append((String)object222).append("</string>");
            string = "\n";
        }
        Map map2 = (Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(map);
        for (Map.Entry object3 : map2.entrySet()) {
            stringBuilder.append(string).append("    <string>-D").append((String)object3.getKey()).append("=").append((String)object3.getValue()).append("</string>");
            string = "\n";
        }
        hashMap.put("DEPLOY_JVM_OPTIONS", stringBuilder.toString());
        string = "";
        stringBuilder = new StringBuilder();
        object222 = (Map)StandardBundlerParam.USER_JVM_OPTIONS.fetchFrom(map);
        for (Map.Entry entry : object222.entrySet()) {
            stringBuilder.append(string);
            stringBuilder.append("      <key>").append((String)entry.getKey()).append("</key>\n");
            stringBuilder.append("      <string>").append((String)entry.getValue()).append("</string>");
            string = "\n";
        }
        hashMap.put("DEPLOY_JVM_USER_OPTIONS", stringBuilder.toString());
        hashMap.put("DEPLOY_LAUNCHER_CLASS", (String)StandardBundlerParam.MAIN_CLASS.fetchFrom(map));
        hashMap.put("DEPLOY_APP_CLASSPATH", (String)StandardBundlerParam.CLASSPATH.fetchFrom(map));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(this.preprocessTextResource(MAC_BUNDLER_PREFIX + this.getConfig_InfoPlist(map).getName(), I18N.getString("resource.bundle-config-file"), TEMPLATE_INFO_PLIST, hashMap, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)));
        ((Writer)bufferedWriter).close();
    }

    private void writePkgInfo(File file) throws IOException {
        String string = "????";
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            bufferedWriter.write(OS_TYPE_CODE + string);
            ((Writer)bufferedWriter).flush();
        }
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "mac.app";
    }

    @Override
    public String getBundleType() {
        return "IMAGE";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        return MacAppBundler.getAppBundleParameters();
    }

    public static Collection<BundlerParamInfo<?>> getAppBundleParameters() {
        return Arrays.asList(StandardBundlerParam.APP_NAME, StandardBundlerParam.APP_RESOURCES, BUNDLE_ID_SIGNING_PREFIX, DEVELOPER_ID_APP_SIGNING_KEY, ICON_ICNS, StandardBundlerParam.JVM_OPTIONS, StandardBundlerParam.JVM_PROPERTIES, MAC_CATEGORY, MAC_CF_BUNDLE_IDENTIFIER, MAC_CF_BUNDLE_NAME, MAC_RUNTIME, StandardBundlerParam.MAIN_CLASS, StandardBundlerParam.MAIN_JAR, StandardBundlerParam.CLASSPATH, StandardBundlerParam.PREFERENCES_ID, StandardBundlerParam.USER_JVM_OPTIONS, StandardBundlerParam.VERSION);
    }

    @Override
    public File execute(Map<String, ? super Object> map, File file) {
        return this.doBundle(map, file, false);
    }

    private static /* synthetic */ File lambda$static$137(String string, Map map) {
        return new File(string);
    }

    private static /* synthetic */ File lambda$static$136(Map map) {
        File file = (File)StandardBundlerParam.ICON.fetchFrom(map);
        if (file != null && !file.getName().toLowerCase().endsWith(".icns")) {
            Log.info(MessageFormat.format(I18N.getString("message.icon-not-icns"), file));
            return null;
        }
        return file;
    }

    private static /* synthetic */ String lambda$static$135(String string, Map map) {
        return string;
    }

    private static /* synthetic */ String lambda$static$134(Map map) {
        return (String)StandardBundlerParam.IDENTIFIER.fetchFrom(map) + ".";
    }

    private static /* synthetic */ String lambda$static$133(String string, Map map) {
        return string;
    }

    private static /* synthetic */ String lambda$static$132(Map map) {
        String string = "Developer ID Application: " + MacBaseInstallerBundler.SIGNING_KEY_USER.fetchFrom(map);
        try {
            IOUtils.exec(new ProcessBuilder("security", "find-certificate", "-c", string), (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static /* synthetic */ RelativeFileSet lambda$static$131(Map map) {
        return MacAppBundler.extractMacRuntime(System.getProperty("java.home"), map);
    }

    private static /* synthetic */ JreUtils.Rule[] lambda$static$130(String string, Map map) {
        return null;
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

