/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.linux;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.linux.LinuxAppBundler;
import com.oracle.tools.packager.linux.LinuxResources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LinuxDebBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(LinuxDebBundler.class.getName());
    public static final BundlerParamInfo<LinuxAppBundler> APP_BUNDLER = new StandardBundlerParam<LinuxAppBundler>(I18N.getString("param.app-bundler.name"), I18N.getString("param.app-bundler.description"), "linux.app.bundler", LinuxAppBundler.class, map -> new LinuxAppBundler(), (string, map) -> null);
    public static final BundlerParamInfo<String> BUNDLE_NAME = new StandardBundlerParam<String>(I18N.getString("param.bundle-name.name"), I18N.getString("param.bundle-name.description"), "linux.bundleName", String.class, map -> {
        String string = (String)StandardBundlerParam.APP_NAME.fetchFrom((Map<String, Object>)map);
        if (string == null) {
            return null;
        }
        string = string.toLowerCase().replaceAll("[ _]", "-").replaceAll("[^-+.a-z0-9]", "");
        return string;
    }, (string, map) -> string);
    public static final BundlerParamInfo<String> FULL_PACKAGE_NAME = new StandardBundlerParam<String>(I18N.getString("param.full-package-name.name"), I18N.getString("param.full-package-name.description"), "linux.deb.fullPackageName", String.class, map -> BUNDLE_NAME.fetchFrom((Map<String, Object>)map) + "-" + (String)StandardBundlerParam.VERSION.fetchFrom((Map<String, Object>)map), (string, map) -> string);
    public static final BundlerParamInfo<File> CONFIG_ROOT = new StandardBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, map -> new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)map), "linux"), (string, map) -> new File((String)string));
    public static final BundlerParamInfo<File> DEB_IMAGE_DIR = new StandardBundlerParam<File>(I18N.getString("param.image-dir.name"), I18N.getString("param.image-dir.description"), "linux.deb.imageDir", File.class, map -> {
        File file = (File)IMAGES_ROOT.fetchFrom((Map<String, ? super Object>)map);
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(new File(file, "linux-deb.image"), FULL_PACKAGE_NAME.fetchFrom((Map<String, Object>)map));
    }, (string, map) -> new File((String)string));
    public static final BundlerParamInfo<File> APP_IMAGE_ROOT = new StandardBundlerParam<File>(I18N.getString("param.app-image-root.name"), I18N.getString("param.app-image-root.description"), "linux.deb.imageRoot", File.class, map -> {
        File file = DEB_IMAGE_DIR.fetchFrom((Map<String, Object>)map);
        return new File(file, "opt");
    }, (string, map) -> new File((String)string));
    public static final BundlerParamInfo<File> CONFIG_DIR = new StandardBundlerParam<File>(I18N.getString("param.config-dir.name"), I18N.getString("param.config-dir.description"), "linux.deb.configDir", File.class, map -> new File(DEB_IMAGE_DIR.fetchFrom((Map<String, Object>)map), "DEBIAN"), (string, map) -> new File((String)string));
    public static final BundlerParamInfo<String> EMAIL = new StandardBundlerParam<String>(I18N.getString("param.maintainer-email.name"), I18N.getString("param.maintainer-email.description"), "email", String.class, map -> "Unknown", (string, map) -> string);
    public static final BundlerParamInfo<String> MAINTAINER = new StandardBundlerParam<String>(I18N.getString("param.maintainer-name.name"), I18N.getString("param.maintainer-name.description"), "linux.deb.maintainer", String.class, map -> (String)StandardBundlerParam.VENDOR.fetchFrom((Map<String, Object>)map) + " <" + EMAIL.fetchFrom((Map<String, Object>)map) + ">", (string, map) -> string);
    public static final BundlerParamInfo<String> LICENSE_TEXT = new StandardBundlerParam<String>(I18N.getString("param.license-text.name"), I18N.getString("param.license-text.description"), "linux.deb.licenseText", String.class, map -> {
        block3: {
            try {
                List list = (List)StandardBundlerParam.LICENSE_FILE.fetchFrom((Map<String, Object>)map);
                RelativeFileSet relativeFileSet = (RelativeFileSet)StandardBundlerParam.APP_RESOURCES.fetchFrom((Map<String, Object>)map);
                if (list.size() > 0) {
                    return new String(IOUtils.readFully(new File(relativeFileSet.getBaseDirectory(), (String)list.get(0))));
                }
            }
            catch (Exception exception) {
                if (!Log.isDebug()) break block3;
                exception.printStackTrace();
            }
        }
        return StandardBundlerParam.LICENSE_TYPE.fetchFrom((Map<String, Object>)map);
    }, (string, map) -> string);
    private static final String DEFAULT_ICON = "javalogo_white_32.png";
    private static final String DEFAULT_CONTROL_TEMPLATE = "template.control";
    private static final String DEFAULT_PRERM_TEMPLATE = "template.prerm";
    private static final String DEFAULT_PREINSTALL_TEMPLATE = "template.preinst";
    private static final String DEFAULT_POSTRM_TEMPLATE = "template.postrm";
    private static final String DEFAULT_POSTINSTALL_TEMPLATE = "template.postinst";
    private static final String DEFAULT_COPYRIGHT_TEMPLATE = "template.copyright";
    private static final String DEFAULT_DESKTOP_FILE_TEMPLATE = "template.desktop";
    private static final String DEFAULT_INIT_SCRIPT_TEMPLATE = "template.deb.init.script";
    public static final String TOOL_DPKG = "dpkg-deb";

    public LinuxDebBundler() {
        this.baseResourceLoader = LinuxResources.class;
    }

    public static boolean testTool(String string, String string2) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(string, "--version");
            IOUtils.exec(processBuilder, Log.isDebug(), true);
        }
        catch (Exception exception) {
            Log.verbose(MessageFormat.format(I18N.getString("message.test-for-tool"), string, exception.getMessage()));
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        try {
            if (map == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            APP_BUNDLER.fetchFrom(map).doValidate(map);
            if (!LinuxDebBundler.testTool(TOOL_DPKG, "1")) {
                throw new ConfigException(MessageFormat.format(I18N.getString("error.tool-not-found"), TOOL_DPKG), I18N.getString("error.tool-not-found.advice"));
            }
            if (map.containsKey(StandardBundlerParam.LICENSE_FILE.getID())) {
                RelativeFileSet relativeFileSet = (RelativeFileSet)StandardBundlerParam.APP_RESOURCES.fetchFrom(map);
                for (String string : (List)StandardBundlerParam.LICENSE_FILE.fetchFrom(map)) {
                    if (relativeFileSet.contains(string)) continue;
                    throw new ConfigException(I18N.getString("error.license-missing"), MessageFormat.format(I18N.getString("error.license-missing.advice"), string, relativeFileSet.getBaseDirectory().toString()));
                }
            } else {
                Log.info(I18N.getString("message.debs-like-licenses"));
            }
            if (map.containsKey(StandardBundlerParam.SERVICE_HINT.getID()) && ((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue() && BUNDLE_NAME.fetchFrom(map).length() > 16) {
                throw new ConfigException(MessageFormat.format(I18N.getString("error.launcher-name-too-long"), BUNDLE_NAME.fetchFrom(map)), MessageFormat.format(I18N.getString("error.launcher-name-too-long.advice"), BUNDLE_NAME.getID()));
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ConfigException) {
                throw (ConfigException)runtimeException.getCause();
            }
            throw new ConfigException(runtimeException);
        }
    }

    private boolean prepareProto(Map<String, ? super Object> map) {
        File file = APP_IMAGE_ROOT.fetchFrom(map);
        File file2 = APP_BUNDLER.fetchFrom(map).doBundle(map, file, true);
        return file2 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File bundle(Map<String, ? super Object> map, File file) {
        File file2;
        block31: {
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), file.getAbsolutePath()));
            }
            if (!file.canWrite()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), file.getAbsolutePath()));
            }
            file2 = DEB_IMAGE_DIR.fetchFrom(map);
            File file3 = CONFIG_DIR.fetchFrom(map);
            file2.mkdirs();
            file3.mkdirs();
            if (!this.prepareProto(map) || !this.prepareProjectConfig(map)) break block31;
            File file4 = this.buildDeb(map, file);
            try {
                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                    this.saveConfigFiles(map);
                }
                if (file2 != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(file2);
                } else if (file2 != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), file2.getAbsolutePath()));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            return file4;
        }
        File file5 = null;
        try {
            if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                this.saveConfigFiles(map);
            }
            if (file2 != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(file2);
            } else if (file2 != null) {
                Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), file2.getAbsolutePath()));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return file5;
        catch (IOException iOException) {
            File file6;
            try {
                iOException.printStackTrace();
                file6 = null;
            }
            catch (Throwable throwable) {
                try {
                    if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                        this.saveConfigFiles(map);
                    }
                    if (file2 != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(file2);
                    } else if (file2 != null) {
                        Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), file2.getAbsolutePath()));
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
                throw throwable;
            }
            try {
                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                    this.saveConfigFiles(map);
                }
                if (file2 != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(file2);
                } else if (file2 != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), file2.getAbsolutePath()));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            return file6;
        }
    }

    private void setPermissions(File file, String string) {
        Set<PosixFilePermission> set = PosixFilePermissions.fromString(string);
        try {
            if (file.exists()) {
                Files.setPosixFilePermissions(file.toPath(), set);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(LinuxDebBundler.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    protected void saveConfigFiles(Map<String, ? super Object> map) {
        try {
            File file = CONFIG_ROOT.fetchFrom(map);
            if (this.getConfig_ControlFile(map).exists()) {
                IOUtils.copyFile(this.getConfig_ControlFile(map), new File(file, this.getConfig_ControlFile(map).getName()));
            }
            if (this.getConfig_CopyrightFile(map).exists()) {
                IOUtils.copyFile(this.getConfig_CopyrightFile(map), new File(file, this.getConfig_CopyrightFile(map).getName()));
            }
            if (this.getConfig_PreinstallFile(map).exists()) {
                IOUtils.copyFile(this.getConfig_PreinstallFile(map), new File(file, this.getConfig_PreinstallFile(map).getName()));
            }
            if (this.getConfig_PrermFile(map).exists()) {
                IOUtils.copyFile(this.getConfig_PrermFile(map), new File(file, this.getConfig_PrermFile(map).getName()));
            }
            if (this.getConfig_PostinstallFile(map).exists()) {
                IOUtils.copyFile(this.getConfig_PostinstallFile(map), new File(file, this.getConfig_PostinstallFile(map).getName()));
            }
            if (this.getConfig_PostrmFile(map).exists()) {
                IOUtils.copyFile(this.getConfig_PostrmFile(map), new File(file, this.getConfig_PostrmFile(map).getName()));
            }
            if (this.getConfig_DesktopShortcutFile(map).exists()) {
                IOUtils.copyFile(this.getConfig_DesktopShortcutFile(map), new File(file, this.getConfig_DesktopShortcutFile(map).getName()));
            }
            if (this.getConfig_IconFile(map).exists()) {
                IOUtils.copyFile(this.getConfig_IconFile(map), new File(file, this.getConfig_IconFile(map).getName()));
            }
            if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue() && this.getConfig_InitScriptFile(map).exists()) {
                IOUtils.copyFile(this.getConfig_InitScriptFile(map), new File(file, this.getConfig_InitScriptFile(map).getName()));
            }
            Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), file.getAbsolutePath()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String getArch() {
        String string = System.getProperty("os.arch");
        if ("i386".equals(string)) {
            return "i386";
        }
        return "amd64";
    }

    private long getInstalledSizeKB(Map<String, ? super Object> map) {
        return this.getInstalledSizeKB(APP_IMAGE_ROOT.fetchFrom(map)) >> 10;
    }

    private long getInstalledSizeKB(File file) {
        long l = 0L;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isFile()) {
                    l += file2.length();
                    continue;
                }
                if (!file2.isDirectory()) continue;
                l += this.getInstalledSizeKB(file2);
            }
        }
        return l;
    }

    private boolean prepareProjectConfig(Map<String, ? super Object> map) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("APPLICATION_NAME", (String)StandardBundlerParam.APP_NAME.fetchFrom(map));
        hashMap.put("APPLICATION_FS_NAME", (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map));
        hashMap.put("APPLICATION_PACKAGE", BUNDLE_NAME.fetchFrom(map));
        hashMap.put("APPLICATION_VENDOR", (String)StandardBundlerParam.VENDOR.fetchFrom(map));
        hashMap.put("APPLICATION_MAINTAINER", MAINTAINER.fetchFrom(map));
        hashMap.put("APPLICATION_VERSION", (String)StandardBundlerParam.VERSION.fetchFrom(map));
        hashMap.put("APPLICATION_LAUNCHER_FILENAME", (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map));
        hashMap.put("DEPLOY_BUNDLE_CATEGORY", (String)StandardBundlerParam.CATEGORY.fetchFrom(map));
        hashMap.put("APPLICATION_DESCRIPTION", (String)StandardBundlerParam.DESCRIPTION.fetchFrom(map));
        hashMap.put("APPLICATION_SUMMARY", (String)StandardBundlerParam.TITLE.fetchFrom(map));
        hashMap.put("APPLICATION_COPYRIGHT", (String)StandardBundlerParam.COPYRIGHT.fetchFrom(map));
        hashMap.put("APPLICATION_LICENSE_TYPE", StandardBundlerParam.LICENSE_TYPE.fetchFrom(map));
        hashMap.put("APPLICATION_LICENSE_TEXT", LICENSE_TEXT.fetchFrom(map));
        hashMap.put("APPLICATION_ARCH", this.getArch());
        hashMap.put("APPLICATION_INSTALLED_SIZE", Long.toString(this.getInstalledSizeKB(map)));
        hashMap.put("SERVICE_HINT", String.valueOf(StandardBundlerParam.SERVICE_HINT.fetchFrom(map)));
        hashMap.put("START_ON_INSTALL", String.valueOf(StandardBundlerParam.START_ON_INSTALL.fetchFrom(map)));
        hashMap.put("STOP_ON_UNINSTALL", String.valueOf(StandardBundlerParam.STOP_ON_UNINSTALL.fetchFrom(map)));
        hashMap.put("RUN_AT_STARTUP", String.valueOf(StandardBundlerParam.RUN_AT_STARTUP.fetchFrom(map)));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.getConfig_ControlFile(map)));
        String string = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_ControlFile(map).getName(), I18N.getString("resource.deb-control-file"), DEFAULT_CONTROL_TEMPLATE, hashMap, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        bufferedWriter.write(string);
        ((Writer)bufferedWriter).close();
        bufferedWriter = new BufferedWriter(new FileWriter(this.getConfig_PreinstallFile(map)));
        string = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_PreinstallFile(map).getName(), I18N.getString("resource.deb-preinstall-script"), DEFAULT_PREINSTALL_TEMPLATE, hashMap, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        bufferedWriter.write(string);
        ((Writer)bufferedWriter).close();
        this.setPermissions(this.getConfig_PreinstallFile(map), "rwxr-xr-x");
        bufferedWriter = new BufferedWriter(new FileWriter(this.getConfig_PrermFile(map)));
        string = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_PrermFile(map).getName(), I18N.getString("resource.deb-prerm-script"), DEFAULT_PRERM_TEMPLATE, hashMap, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        bufferedWriter.write(string);
        ((Writer)bufferedWriter).close();
        this.setPermissions(this.getConfig_PrermFile(map), "rwxr-xr-x");
        bufferedWriter = new BufferedWriter(new FileWriter(this.getConfig_PostinstallFile(map)));
        string = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_PostinstallFile(map).getName(), I18N.getString("resource.deb-postinstall-script"), DEFAULT_POSTINSTALL_TEMPLATE, hashMap, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        bufferedWriter.write(string);
        ((Writer)bufferedWriter).close();
        this.setPermissions(this.getConfig_PostinstallFile(map), "rwxr-xr-x");
        bufferedWriter = new BufferedWriter(new FileWriter(this.getConfig_PostrmFile(map)));
        string = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_PostrmFile(map).getName(), I18N.getString("resource.deb-postrm-script"), DEFAULT_POSTRM_TEMPLATE, hashMap, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        bufferedWriter.write(string);
        ((Writer)bufferedWriter).close();
        this.setPermissions(this.getConfig_PostrmFile(map), "rwxr-xr-x");
        bufferedWriter = new BufferedWriter(new FileWriter(this.getConfig_CopyrightFile(map)));
        string = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_CopyrightFile(map).getName(), I18N.getString("resource.deb-copyright-file"), DEFAULT_COPYRIGHT_TEMPLATE, hashMap, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        bufferedWriter.write(string);
        ((Writer)bufferedWriter).close();
        bufferedWriter = new BufferedWriter(new FileWriter(this.getConfig_DesktopShortcutFile(map)));
        string = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_DesktopShortcutFile(map).getName(), I18N.getString("resource.menu-shortcut-descriptor"), DEFAULT_DESKTOP_FILE_TEMPLATE, hashMap, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        bufferedWriter.write(string);
        ((Writer)bufferedWriter).close();
        File file = this.getConfig_IconFile(map);
        File file2 = LinuxAppBundler.ICON_PNG.fetchFrom(map);
        if (file2 == null || !file2.exists()) {
            this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + file.getName(), I18N.getString("resource.menu-icon"), DEFAULT_ICON, file, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)));
        } else {
            this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + file.getName(), I18N.getString("resource.menu-icon"), file2, file, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)));
        }
        if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue()) {
            bufferedWriter = new BufferedWriter(new FileWriter(this.getConfig_InitScriptFile(map)));
            string = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_InitScriptFile(map).getName(), I18N.getString("resource.deb-init-script"), DEFAULT_INIT_SCRIPT_TEMPLATE, hashMap, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
            bufferedWriter.write(string);
            ((Writer)bufferedWriter).close();
            this.setPermissions(this.getConfig_InitScriptFile(map), "rwxr-xr-x");
        }
        return true;
    }

    private File getConfig_DesktopShortcutFile(Map<String, ? super Object> map) {
        return new File(LinuxAppBundler.getRootDir(APP_IMAGE_ROOT.fetchFrom(map), map), (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map) + ".desktop");
    }

    private File getConfig_IconFile(Map<String, ? super Object> map) {
        return new File(LinuxAppBundler.getRootDir(APP_IMAGE_ROOT.fetchFrom(map), map), (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map) + ".png");
    }

    private File getConfig_InitScriptFile(Map<String, ? super Object> map) {
        return new File(LinuxAppBundler.getRootDir(APP_IMAGE_ROOT.fetchFrom(map), map), BUNDLE_NAME.fetchFrom(map) + ".init");
    }

    private File getConfig_ControlFile(Map<String, ? super Object> map) {
        return new File(CONFIG_DIR.fetchFrom(map), "control");
    }

    private File getConfig_PreinstallFile(Map<String, ? super Object> map) {
        return new File(CONFIG_DIR.fetchFrom(map), "preinst");
    }

    private File getConfig_PrermFile(Map<String, ? super Object> map) {
        return new File(CONFIG_DIR.fetchFrom(map), "prerm");
    }

    private File getConfig_PostinstallFile(Map<String, ? super Object> map) {
        return new File(CONFIG_DIR.fetchFrom(map), "postinst");
    }

    private File getConfig_PostrmFile(Map<String, ? super Object> map) {
        return new File(CONFIG_DIR.fetchFrom(map), "postrm");
    }

    private File getConfig_CopyrightFile(Map<String, ? super Object> map) {
        return new File(CONFIG_DIR.fetchFrom(map), "copyright");
    }

    private File buildDeb(Map<String, ? super Object> map, File file) throws IOException {
        File file2 = new File(file, FULL_PACKAGE_NAME.fetchFrom(map) + ".deb");
        Log.verbose(MessageFormat.format(I18N.getString("message.outputting-to-location"), file2.getAbsolutePath()));
        file2.getParentFile().mkdirs();
        ProcessBuilder processBuilder = new ProcessBuilder("fakeroot", TOOL_DPKG, "-b", FULL_PACKAGE_NAME.fetchFrom(map), file2.getAbsolutePath());
        processBuilder = processBuilder.directory(DEB_IMAGE_DIR.fetchFrom(map).getParentFile());
        IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        Log.info(MessageFormat.format(I18N.getString("message.output-to-location"), file2.getAbsolutePath()));
        return file2;
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "deb";
    }

    @Override
    public String getBundleType() {
        return "INSTALLER";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(LinuxAppBundler.getAppBundleParameters());
        linkedHashSet.addAll(LinuxDebBundler.getDebBundleParameters());
        return linkedHashSet;
    }

    public static Collection<BundlerParamInfo<?>> getDebBundleParameters() {
        return Arrays.asList(BUNDLE_NAME, StandardBundlerParam.COPYRIGHT, StandardBundlerParam.CATEGORY, StandardBundlerParam.DESCRIPTION, EMAIL, LinuxAppBundler.ICON_PNG, StandardBundlerParam.LICENSE_FILE, StandardBundlerParam.LICENSE_TYPE, StandardBundlerParam.TITLE, StandardBundlerParam.VENDOR);
    }

    @Override
    public File execute(Map<String, ? super Object> map, File file) {
        return this.bundle(map, file);
    }
}

