/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import com.oracle.tools.packager.Bundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.Bundlers;
import com.oracle.tools.packager.linux.LinuxAppBundler;
import com.oracle.tools.packager.linux.LinuxDebBundler;
import com.oracle.tools.packager.linux.LinuxRpmBundler;
import com.oracle.tools.packager.mac.MacAppBundler;
import com.oracle.tools.packager.mac.MacAppStoreBundler;
import com.oracle.tools.packager.mac.MacDmgBundler;
import com.oracle.tools.packager.mac.MacPkgBundler;
import com.oracle.tools.packager.windows.WinAppBundler;
import com.oracle.tools.packager.windows.WinExeBundler;
import com.oracle.tools.packager.windows.WinMsiBundler;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;

public class BasicBundlers
implements Bundlers {
    boolean defaultsLoaded = false;
    private Collection<Bundler> bundlers = new CopyOnWriteArrayList<Bundler>();

    @Override
    public Collection<Bundler> getBundlers() {
        return Collections.unmodifiableCollection(this.bundlers);
    }

    @Override
    public Collection<Bundler> getBundlers(String string) {
        if (string == null) {
            return Collections.emptySet();
        }
        switch (string) {
            case "NONE": {
                return Collections.emptySet();
            }
            case "ALL": {
                return this.getBundlers();
            }
        }
        return Arrays.asList(this.getBundlers().stream().filter(bundler -> string.equals(bundler.getBundleType())).toArray(Bundler[]::new));
    }

    @Override
    public Collection<BundlerParamInfo> getStandardParameters() {
        return null;
    }

    @Override
    public void loadDefaultBundlers() {
        if (this.defaultsLoaded) {
            return;
        }
        this.bundlers.add(new WinAppBundler());
        this.bundlers.add(new WinExeBundler());
        this.bundlers.add(new WinMsiBundler());
        this.bundlers.add(new LinuxAppBundler());
        this.bundlers.add(new LinuxDebBundler());
        this.bundlers.add(new LinuxRpmBundler());
        this.bundlers.add(new MacAppBundler());
        this.bundlers.add(new MacDmgBundler());
        this.bundlers.add(new MacPkgBundler());
        this.bundlers.add(new MacAppStoreBundler());
        this.defaultsLoaded = true;
    }

    @Override
    public void loadBundlersFromServices(ClassLoader classLoader) {
        ServiceLoader<Bundler> serviceLoader = ServiceLoader.load(Bundler.class, classLoader);
        for (Bundler bundler : serviceLoader) {
            this.bundlers.add(bundler);
        }
    }

    @Override
    public void loadBundler(Bundler bundler) {
        this.bundlers.add(bundler);
    }
}

