/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;
import org.netbeans.swing.tabcontrol.DocumentSwitcherTable;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;
import org.openide.awt.StatusDisplayer;
import org.openide.windows.TopComponent;

final class ButtonPopupSwitcher
implements MouseInputListener,
AWTEventListener,
ListSelectionListener,
ComplexListDataListener,
PopupMenuListener {
    private static JPopupMenu popup;
    private Component invokingComponent = null;
    private long invocationTime = -1L;
    private static boolean shown;
    private static ButtonPopupSwitcher currentSwitcher;
    private final DocumentSwitcherTable pTable;
    private int x;
    private int y;
    private boolean isDragging = true;
    private final TabDisplayer displayer;

    public static void showPopup(JComponent jComponent, TabDisplayer tabDisplayer, int n, int n2) {
        ButtonPopupSwitcher buttonPopupSwitcher = new ButtonPopupSwitcher(tabDisplayer, n, n2);
        buttonPopupSwitcher.doSelect(jComponent);
        currentSwitcher = buttonPopupSwitcher;
    }

    private ButtonPopupSwitcher(TabDisplayer tabDisplayer, int n, int n2) {
        this.displayer = tabDisplayer;
        Object[] objectArray = this.createSwitcherItems(tabDisplayer);
        Arrays.sort(objectArray);
        this.pTable = new DocumentSwitcherTable(tabDisplayer, (SwitcherTableItem[])objectArray, n2);
        this.x = n;
        this.y = n2;
    }

    private void doSelect(JComponent jComponent) {
        this.invokingComponent = jComponent;
        this.invokingComponent.addMouseListener(this);
        this.invokingComponent.addMouseMotionListener(this);
        this.pTable.addMouseListener(this);
        this.pTable.addMouseMotionListener(this);
        this.pTable.getSelectionModel().addListSelectionListener(this);
        this.displayer.getModel().addComplexListDataListener(this);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        popup = new JPopupMenu();
        popup.setBorderPainted(false);
        popup.setBorder(BorderFactory.createEmptyBorder());
        popup.add(this.pTable);
        popup.pack();
        int n = this.x - (int)this.pTable.getPreferredSize().getWidth();
        int n2 = this.y + 1;
        popup.setLocation(n, n2);
        popup.setInvoker(this.invokingComponent);
        popup.addPopupMenuListener(this);
        popup.setVisible(true);
        shown = true;
        this.invocationTime = System.currentTimeMillis();
    }

    public static boolean isShown() {
        return shown;
    }

    static void hidePopup() {
        if (ButtonPopupSwitcher.isShown()) {
            currentSwitcher.hideCurrentPopup();
        }
    }

    private synchronized void hideCurrentPopup() {
        this.pTable.removeMouseListener(this);
        this.pTable.removeMouseMotionListener(this);
        this.pTable.getSelectionModel().removeListSelectionListener(this);
        this.displayer.getModel().removeComplexListDataListener(this);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        if (this.invokingComponent != null) {
            this.invokingComponent.removeMouseListener(this);
            this.invokingComponent.removeMouseMotionListener(this);
            this.invokingComponent = null;
        }
        if (popup != null) {
            popup.removePopupMenuListener(this);
            final JPopupMenu jPopupMenu = popup;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (jPopupMenu.isVisible()) {
                        jPopupMenu.setVisible(false);
                    }
                }
            });
            popup.setVisible(false);
            popup = null;
            shown = false;
            currentSwitcher = null;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        SwitcherTableItem switcherTableItem = this.pTable.getSelectedItem();
        StatusDisplayer.getDefault().setStatusText(null == switcherTableItem ? null : switcherTableItem.getDescription());
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        mouseEvent.consume();
        this.changeSelection(mouseEvent);
        this.pTable.onMouseEvent(mouseEvent);
        this.isDragging = false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.displayer.getModel().size();
        if (this.pTable.onMouseEvent(mouseEvent) && n == 1) {
            this.hideCurrentPopup();
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        long l;
        if (mouseEvent.getSource() == this.invokingComponent && (l = System.currentTimeMillis()) - this.invocationTime > 500L && this.isDragging) {
            this.mouseClicked(mouseEvent);
        }
        this.isDragging = false;
        mouseEvent.consume();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        SwitcherTableItem switcherTableItem;
        Point point = mouseEvent.getPoint();
        point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this.pTable);
        if (this.pTable.contains(point) && !this.pTable.onMouseEvent(mouseEvent) && (switcherTableItem = this.pTable.getSelectedItem()) != null) {
            this.hideCurrentPopup();
            switcherTableItem.activate();
        }
        this.isDragging = false;
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.pTable.clearSelection();
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.changeSelection(mouseEvent);
        this.pTable.onMouseEvent(mouseEvent);
        mouseEvent.consume();
    }

    private void changeSelection(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (mouseEvent.getSource() != this) {
            point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this.pTable);
        }
        if (this.pTable.contains(point)) {
            int n = this.pTable.rowAtPoint(point);
            int n2 = this.pTable.columnAtPoint(point);
            this.pTable.changeSelection(n, n2, false, false);
        } else {
            this.pTable.clearSelection();
        }
    }

    private boolean onSwitcherTable(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (!(mouseEvent.getSource() instanceof Component)) {
            return false;
        }
        point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this.pTable);
        return this.pTable.contains(point);
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getSource() == this) {
            return;
        }
        if (aWTEvent instanceof KeyEvent && aWTEvent.getID() == 401) {
            if (!this.changeSelection((KeyEvent)aWTEvent)) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                this.hideCurrentPopup();
            } else {
                ((KeyEvent)aWTEvent).consume();
            }
        }
    }

    private boolean changeSelection(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = this.pTable.getSelectedRow();
        int n3 = this.pTable.getSelectedColumn();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        boolean bl = true;
        switch (n) {
            case 37: {
                if (--n3 >= 0) break;
                n3 = this.pTable.getColumnCount() - 1;
                break;
            }
            case 39: {
                if (++n3 <= this.pTable.getColumnCount() - 1) break;
                n3 = 0;
                break;
            }
            case 40: {
                if (++n2 <= this.pTable.getRowCount() - 1) break;
                n2 = 0;
                if (++n3 <= this.pTable.getColumnCount() - 1) break;
                n3 = 0;
                break;
            }
            case 38: {
                if (--n2 >= 0) break;
                n2 = this.pTable.getRowCount() - 1;
                if (--n3 >= 0) break;
                n3 = this.pTable.getColumnCount() - 1;
                break;
            }
            case 10: {
                SwitcherTableItem switcherTableItem = this.pTable.getSelectedItem();
                if (switcherTableItem == null) break;
                switcherTableItem.activate();
                this.hideCurrentPopup();
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            this.pTable.changeSelection(n2, n3, false, false);
        }
        return bl;
    }

    private void changed() {
        if (!ButtonPopupSwitcher.isShown()) {
            return;
        }
        Object[] objectArray = this.createSwitcherItems(this.displayer);
        if (objectArray.length == 0) {
            this.hideCurrentPopup();
            return;
        }
        Arrays.sort(objectArray);
        this.pTable.setSwitcherItems((SwitcherTableItem[])objectArray, this.y);
        popup.pack();
        int n = this.x - (int)this.pTable.getPreferredSize().getWidth();
        int n2 = this.y + 1;
        popup.setLocation(n, n2);
    }

    @Override
    public void indicesAdded(ComplexListDataEvent complexListDataEvent) {
        this.changed();
    }

    @Override
    public void indicesRemoved(ComplexListDataEvent complexListDataEvent) {
        this.changed();
    }

    @Override
    public void indicesChanged(ComplexListDataEvent complexListDataEvent) {
        this.changed();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.changed();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.changed();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.changed();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        if (null != popup) {
            popup.removePopupMenuListener(this);
        }
        this.hideCurrentPopup();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        if (null != popup) {
            popup.removePopupMenuListener(this);
        }
        this.hideCurrentPopup();
    }

    private DocumentSwitcherTable.Item[] createSwitcherItems(TabDisplayer tabDisplayer) {
        List<TabData> list = tabDisplayer.getModel().getTabs();
        DocumentSwitcherTable.Item[] itemArray = new DocumentSwitcherTable.Item[list.size()];
        int n = 0;
        int n2 = tabDisplayer.getSelectionModel().getSelectedIndex();
        TabData tabData = n2 >= 0 ? tabDisplayer.getModel().getTab(n2) : null;
        for (TabData tabData2 : list) {
            String string;
            String string2;
            if (tabData2.getComponent() instanceof TopComponent) {
                TopComponent topComponent = (TopComponent)tabData2.getComponent();
                string2 = topComponent.getDisplayName();
                if (string2 == null) {
                    string2 = topComponent.getName();
                }
                if ((string = topComponent.getHtmlDisplayName()) == null) {
                    string = string2;
                }
            } else {
                string2 = string = tabData2.getText();
            }
            itemArray[n++] = new DocumentSwitcherTable.Item((SwitcherTableItem.Activatable)new ActivatableTab(tabData2), string2, string, tabData2, tabData2 == tabData);
        }
        return itemArray;
    }

    private class ActivatableTab
    implements SwitcherTableItem.Activatable {
        private TabData tab;

        private ActivatableTab(TabData tabData) {
            this.tab = tabData;
        }

        @Override
        public void activate() {
            if (this.tab != null) {
                this.selectTab(this.tab);
            }
        }

        private void selectTab(TabData tabData) {
            int n;
            List<TabData> list = ButtonPopupSwitcher.this.displayer.getModel().getTabs();
            int n2 = -1;
            for (n = 0; n < list.size(); ++n) {
                if (!tabData.equals(list.get(n))) continue;
                n2 = n;
                break;
            }
            if (n2 != -1) {
                n = ButtonPopupSwitcher.this.displayer.getSelectionModel().getSelectedIndex();
                ButtonPopupSwitcher.this.displayer.getSelectionModel().setSelectedIndex(n2);
                if (ButtonPopupSwitcher.this.displayer.getType() == 1 && n2 >= 0 && n2 == n) {
                    ButtonPopupSwitcher.this.displayer.getUI().makeTabVisible(n2);
                }
            }
        }
    }
}

