/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.uibuilder;

import com.jrockit.mc.ui.uibuilder.IUIBuilder;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormText;

public class StandardUIBuilder
implements IUIBuilder {
    private Composite m_mainContainer;
    private static final int MAX_SPAN = 10;
    private int m_span = 10;
    private GridData m_lastGridData = null;

    public StandardUIBuilder(Composite container) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 10;
        container.setLayout((Layout)layout);
        this.m_mainContainer = container;
    }

    @Override
    public Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 64);
        return composite;
    }

    @Override
    public void setCompositeLayout(Composite composite) {
        GridData gd = new GridData(4, 4, true, true);
        this.setSpan(gd);
        composite.setLayoutData((Object)gd);
    }

    @Override
    public Table createTable(Composite parent, boolean checked) {
        int style = checked ? 32 : 0;
        Table table = new Table(parent, style | 0x800);
        return table;
    }

    @Override
    public void createCaption(String text) {
        GridData gd = new GridData(800);
        this.setSpan(gd);
        gd.grabExcessHorizontalSpace = true;
        Label label = new Label(this.getContainer(), 0);
        label.setFont(JFaceResources.getBannerFont());
        label.setText(text);
        label.setLayoutData((Object)gd);
    }

    @Override
    public Label createSeparator() {
        GridData gd = new GridData(4, 1, true, false);
        this.setSpan(gd);
        Label label = new Label(this.getContainer(), 258);
        label.setLayoutData((Object)gd);
        return label;
    }

    public void setSpan(GridData gridData) {
        if (this.m_lastGridData != null) {
            this.m_lastGridData.horizontalSpan = 1;
        }
        gridData.horizontalSpan = this.m_span--;
        this.m_lastGridData = gridData;
    }

    @Override
    public Button createCheckBox(String text, boolean checked, String toolTip) {
        GridData gd = new GridData(32);
        this.setSpan(gd);
        Button button = new Button(this.getContainer(), 32);
        button.setText(text);
        button.setLayoutData((Object)gd);
        button.setSelection(checked);
        return button;
    }

    @Override
    public Button createButton(String text, String toolTip) {
        GridData gd = new GridData(32);
        this.setSpan(gd);
        Button button = new Button(this.getContainer(), 0);
        button.setText(text);
        button.setLayoutData((Object)gd);
        return button;
    }

    @Override
    public Label createWrapLabel(String text, String toolTip) {
        GridData gd = new GridData(800);
        this.setSpan(gd);
        gd.grabExcessHorizontalSpace = true;
        Label label = new Label(this.getContainer(), 64);
        label.setText(text);
        label.setLayoutData((Object)gd);
        this.layout();
        return label;
    }

    @Override
    public Label createLabel(String text, String toolTip) {
        GridData gd = new GridData(32);
        this.setSpan(gd);
        Label label = new Label(this.getContainer(), 64);
        label.setText(text);
        label.setToolTipText(toolTip);
        label.setLayoutData((Object)gd);
        return label;
    }

    @Override
    public Text createText(String text, String toolTip, int style) {
        GridData gd = new GridData(800);
        this.setSpan(gd);
        gd.grabExcessHorizontalSpace = true;
        Text textUI = new Text(this.getContainer(), 0x800 | style);
        textUI.setText(text);
        textUI.setToolTipText(toolTip);
        textUI.setLayoutData((Object)gd);
        return textUI;
    }

    private Composite getContainer() {
        return this.m_mainContainer;
    }

    @Override
    public void layout() {
        this.m_span = 10;
        this.m_lastGridData = null;
        this.m_mainContainer.layout();
    }

    @Override
    public void setContainer(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 10;
        composite.setLayout((Layout)layout);
        this.m_mainContainer = composite;
    }

    @Override
    public CCombo createCombo() {
        GridData gd = new GridData(800);
        this.setSpan(gd);
        gd.minimumWidth = 200;
        CCombo c = new CCombo(this.m_mainContainer, 2308);
        c.setLayoutData((Object)gd);
        return c;
    }

    @Override
    public Text createMultiText(String text, String tooltip) {
        GridData gd = new GridData(1840);
        this.setSpan(gd);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        Text textUI = new Text(this.getContainer(), 2114);
        textUI.setText(text);
        textUI.setToolTipText(tooltip);
        textUI.setLayoutData((Object)gd);
        return textUI;
    }

    @Override
    public FormText createFormText(String text, String toolTip) {
        GridData gd = new GridData(800);
        gd.grabExcessHorizontalSpace = true;
        FormText ft = new FormText(this.getContainer(), 64);
        this.setSpan(gd);
        ft.setText(text, false, false);
        ft.setToolTipText(toolTip);
        ft.setLayoutData((Object)gd);
        this.layout();
        return ft;
    }
}

