/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.sections;

import com.jrockit.mc.ui.fields.FieldTableEditAction;
import com.jrockit.mc.ui.fields.FieldToolkit;
import com.jrockit.mc.ui.handlers.FieldMenus;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.sections.ViewerSectionPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class FieldViewerSectionPart
extends ViewerSectionPart {
    private final IDialogSettings m_settings;
    private final Field[] m_fields;

    public FieldViewerSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier, Field[] fieldPrototypes, IDialogSettings settings) {
        super(parent, toolkit, style, sectionIdentifier);
        this.m_settings = settings;
        this.m_fields = this.createFieldInstances(fieldPrototypes);
    }

    protected Field[] createFieldInstances(Field[] fieldPrototypes) {
        return FieldToolkit.instantiateFieldArray(fieldPrototypes);
    }

    protected abstract Composite createFieldViewerClient(IManagedForm var1, FormToolkit var2, Composite var3);

    protected IDialogSettings getSettings() {
        return this.m_settings;
    }

    protected Field[] getFields() {
        return this.m_fields;
    }

    @Override
    protected final Composite createViewerClient(IManagedForm form, FormToolkit formToolkit, Composite section) {
        this.loadDialogSettings(this.getSettings());
        if (this.hasTitle()) {
            FieldTableEditAction ftea = new FieldTableEditAction(this.getSettings());
            ftea.setFields(this.getFields());
            this.getMCToolBarManager().add((IAction)ftea);
        }
        FieldMenus.install(this.getMenuManager(), this.getFields());
        return this.createFieldViewerClient(form, formToolkit, section);
    }

    protected void saveDialogSettings(IDialogSettings settings) {
        IDialogSettings tableSettings = settings.getSection(this.getSectionIdentifier());
        if (tableSettings == null) {
            tableSettings = settings.addNewSection(this.getSectionIdentifier());
        }
        FieldToolkit.fillDialogSettingsFromFields(this.getFields(), tableSettings);
    }

    protected void loadDialogSettings(IDialogSettings settings) {
        IDialogSettings tableSettings = settings.getSection(this.getSectionIdentifier());
        if (tableSettings != null) {
            FieldToolkit.fillFieldsFromDialogSettings(tableSettings, this.getFields());
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.saveDialogSettings(this.getSettings());
        Field[] fields = this.getFields();
        if (fields != null) {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                field.dispose();
                ++n2;
            }
        }
    }
}

