/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.NumberField;

public class FixedItemsField
extends Field {
    protected final String[] m_items;

    public FixedItemsField(int id, String ... items) {
        super(id);
        this.m_items = items;
    }

    @Override
    public String formatObject(Object object) {
        if (object instanceof Integer) {
            return this.getItemString((Integer)object);
        }
        if (object instanceof Long) {
            return this.getItemString(((Long)object).intValue());
        }
        return super.formatObject(object);
    }

    public String getItemString(int index) {
        if (index < 0 || index >= this.m_items.length) {
            return super.formatObject(null);
        }
        return this.m_items[index];
    }

    @Override
    public String formatForClipboard(Object object) {
        return this.formatObject(object);
    }

    @Override
    public Object parse(Tokenizer tokenizer) {
        String text = tokenizer.peek().text;
        int n = 0;
        while (n < this.m_items.length) {
            if (text.equalsIgnoreCase(this.m_items[n])) {
                tokenizer.next();
                return n;
            }
            ++n;
        }
        return null;
    }

    @Override
    public int compare(Object a, Object b, boolean ascendingOrder) {
        if (a instanceof Number && b instanceof Number) {
            return NumberField.compareNumber((Number)a, (Number)b);
        }
        return super.compare(a, b, ascendingOrder);
    }
}

