/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.ui.model.fields.IFieldListener;
import com.jrockit.mc.ui.model.fields.IFieldUI;
import com.jrockit.mc.ui.model.fields.Messages;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.jface.resource.ImageDescriptor;

public class Field
implements Cloneable,
IFieldUI {
    public static final String PROPERTY_MINWIDTH = "width";
    public static final String PROPERTY_WIDTHWEIGHT = "widthweight";
    public static final String PROPERTY_VISIBLE = "visible";
    public static final String PROPERTY_SORTORDER = "sortorder";
    public static final String PROPERTY_NAME = "NAME_TEXT";
    public static final String PROPERTY_DESCRIPTION = "DESCRIPTION_TEXT";
    public static final String PROPERTY_CONTENT_CHANGE = "content.change";
    public static final String PROPERTY_VISIBILITY_CHANGE = "visibility.change";
    public static final String PROPERTY_BOLD = "bold";
    public static final String PROPERTY_FILTERABLE = "filterable";
    public static final String PROPERTY_WRAP = "wrap";
    public final int INDEX;
    public String IDENTIFIER = "";
    private Properties m_properties = new Properties();
    private boolean m_modifiable = true;
    private Collection<IFieldListener> m_fieldListeners = Collections.synchronizedCollection(new HashSet());
    private boolean m_changed = false;

    public Field(int id) {
        this.INDEX = id;
    }

    public void addListener(IFieldListener listener) {
        this.m_fieldListeners.add(listener);
    }

    public synchronized void removeListener(IFieldListener listener) {
        this.m_fieldListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(Object property) {
        Object[] listeners = new Object[]{};
        Collection<IFieldListener> collection = this.m_fieldListeners;
        synchronized (collection) {
            if (this.m_changed) {
                listeners = this.m_fieldListeners.toArray();
            }
            this.m_changed = false;
        }
        Object[] objectArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            IFieldListener f = (IFieldListener)listener;
            f.changed(this, property);
            ++n2;
        }
    }

    public void initialize(String identifier) {
        this.IDENTIFIER = identifier;
        this.setMinWidth(80);
        this.setWidthWeight(10);
        this.setVisible(true);
    }

    public String getProperty(String key) {
        return this.m_properties.getProperty(this.getFullKey(key));
    }

    public void setProperty(String key, String value) {
        this.setChanged();
        this.m_properties.setProperty(this.getFullKey(key), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChanged() {
        Collection<IFieldListener> collection = this.m_fieldListeners;
        synchronized (collection) {
            this.m_changed = true;
        }
    }

    public String getKeyFromProperty(String fullKey) {
        if (!fullKey.startsWith(String.valueOf(this.IDENTIFIER) + "_")) {
            return null;
        }
        return fullKey.substring((String.valueOf(this.IDENTIFIER) + "_").length());
    }

    @Override
    public String getName() {
        return this.getString(PROPERTY_NAME, "Unknown name");
    }

    @Override
    public String getDescription() {
        return this.getString(PROPERTY_DESCRIPTION, "");
    }

    public void setDescription(String description) {
        this.setString(PROPERTY_DESCRIPTION, description);
    }

    public void setModifiable(boolean modifiable) {
        this.m_modifiable = modifiable;
    }

    @Override
    public boolean isModifiable() {
        return this.m_modifiable;
    }

    public void setName(String name) {
        this.setString(PROPERTY_NAME, name);
    }

    public void setProperties(Properties properties) {
        this.m_properties = properties;
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public int getInteger(String key, int defaultValue) {
        try {
            String value = this.getProperty(key);
            if (value == null) {
                return defaultValue;
            }
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public Field newInstance() {
        Field field;
        try {
            field = (Field)this.clone();
            field.m_fieldListeners = Collections.synchronizedCollection(new HashSet());
            field.setProperties((Properties)this.m_properties.clone());
        }
        catch (Exception e) {
            return this;
        }
        return field;
    }

    public void setInteger(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    public String getFullKey(String key) {
        if (key != null) {
            return String.valueOf(this.IDENTIFIER) + "_" + key;
        }
        return null;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            String prop = this.getProperty(key);
            if (prop == null) {
                return defaultValue;
            }
            return Boolean.parseBoolean(prop);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public void setBoolean(String key, boolean value) {
        this.setProperty(key, Boolean.toString(value));
    }

    public void setString(String key, String value) {
        this.setProperty(key, value);
    }

    public String getString(String key, String defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String formatForClipboard(Object object) {
        return this.formatObject(object);
    }

    @Override
    public void setWidthWeight(int widthWeight) {
        this.setInteger(PROPERTY_WIDTHWEIGHT, widthWeight);
    }

    @Override
    public int getWidthWeight() {
        return this.getInteger(PROPERTY_WIDTHWEIGHT, 10);
    }

    @Override
    public void setMinWidth(int width) {
        this.setInteger(PROPERTY_MINWIDTH, width);
    }

    @Override
    public void setSortOrder(boolean sortOrder) {
        this.setBoolean(PROPERTY_SORTORDER, sortOrder);
    }

    @Override
    public int getMinWidth() {
        return this.getInteger(PROPERTY_MINWIDTH, 80);
    }

    @Override
    public void setVisible(boolean visible) {
        this.setBoolean(PROPERTY_VISIBLE, visible);
    }

    @Override
    public boolean isVisible() {
        return this.getBoolean(PROPERTY_VISIBLE, true);
    }

    public void setFilterable(boolean filterable) {
        this.setBoolean(PROPERTY_FILTERABLE, filterable);
    }

    public boolean isFilterable() {
        return this.getBoolean(PROPERTY_FILTERABLE, true);
    }

    public boolean useLineWrap() {
        return this.getBoolean(PROPERTY_WRAP, true);
    }

    @Override
    public boolean getSortOrderAscending() {
        return this.getBoolean(PROPERTY_SORTORDER, true);
    }

    public String formatObject(Object object) {
        return Field.defaultFormat(object);
    }

    public String getUnit() {
        return null;
    }

    public String getTooltip(Object object) {
        return null;
    }

    public ImageDescriptor getImage(Object object) {
        return null;
    }

    public ImageDescriptor getToolTipImage(Object object) {
        return null;
    }

    public static String defaultFormat(Object object) {
        if (object != null) {
            return object.toString().trim();
        }
        return Messages.Field_N_A;
    }

    public int compare(Object a, Object b, boolean ascendingOrder) {
        if (a instanceof Comparable && b instanceof Comparable) {
            if (a.getClass().isAssignableFrom(b.getClass())) {
                return ascendingOrder ? ((Comparable)a).compareTo(b) : -((Comparable)a).compareTo(b);
            }
            if (b.getClass().isAssignableFrom(a.getClass())) {
                return ascendingOrder ? -((Comparable)b).compareTo(a) : ((Comparable)b).compareTo(a);
            }
        }
        return ascendingOrder ? Field.defaultFormat(a).compareTo(Field.defaultFormat(b)) : Field.defaultFormat(b).compareTo(Field.defaultFormat(a));
    }

    public void setInput(Object input) {
    }

    protected Object getInput() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChanged() {
        Collection<IFieldListener> collection = this.m_fieldListeners;
        synchronized (collection) {
            return this.m_changed;
        }
    }

    public void dispose() {
        this.m_fieldListeners.clear();
    }

    public Object parse(Tokenizer tokenizer) throws ParseException {
        return null;
    }
}

