/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.idesupport;

import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.idesupport.BasicFile;
import com.jrockit.mc.ui.idesupport.Messages;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbenchWindow;

public class IDESupportUIToolkit {
    private static final String LAST_IDE_SUPPORT_PATH = "ide.support.last.browse.file";

    private IDESupportUIToolkit() {
    }

    public static MCFile browseForSaveAsFile(String title, String suggestedName, IPath path, String fileExtension, String description, boolean overWritePossible) {
        File theFile;
        block6: {
            SimpleDateFormat sf;
            String prefix;
            String safeFileExtension;
            String file;
            IWorkbenchWindow window;
            while (true) {
                window = IDESupportUIToolkit.getActiveWorkbenchWindow();
                FileDialog dialog = new FileDialog(window.getShell(), 8192);
                if (path != null && path.toFile().exists()) {
                    dialog.setFilterPath(path.toFile().getPath());
                }
                dialog.setFilterExtensions(new String[]{"*." + fileExtension});
                dialog.setFileName(new File(suggestedName).getName());
                dialog.setText(title);
                file = dialog.open();
                if (file == null) {
                    return null;
                }
                safeFileExtension = BasicFile.getSafeFileExtensionWithDot(fileExtension);
                if (!file.endsWith(safeFileExtension)) {
                    file = String.valueOf(file) + safeFileExtension;
                }
                if (!(theFile = new File(file)).exists()) break block6;
                if (!overWritePossible) break;
                int overwriteOk = IDESupportUIToolkit.showAlreadyExists(window, theFile);
                if (overwriteOk == 128) {
                    continue;
                }
                break block6;
                break;
            }
            do {
                prefix = file.substring(0, file.lastIndexOf(safeFileExtension));
                sf = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss");
            } while ((theFile = new File(file = String.valueOf(prefix) + sf.format(System.currentTimeMillis()) + safeFileExtension)).exists());
            IDESupportUIToolkit.showAppend(window, theFile);
        }
        Path newPath = new Path(theFile.getPath());
        IDESupportUIToolkit.saveLastPath((IPath)newPath);
        return new BasicFile((IPath)newPath);
    }

    public static MCFile browseForOpenFile(String title, IPath path, String fileExtension) {
        IWorkbenchWindow window = IDESupportUIToolkit.getActiveWorkbenchWindow();
        FileDialog dialog = new FileDialog(window.getShell(), 4096);
        if (path != null && path.toFile().exists()) {
            dialog.setFilterPath(path.toFile().getPath());
        }
        dialog.setFilterExtensions(new String[]{"*." + fileExtension});
        dialog.setText(title);
        String file = dialog.open();
        if (file != null) {
            Path newPath = new Path(file);
            return new BasicFile((IPath)newPath);
        }
        return null;
    }

    private static IWorkbenchWindow getActiveWorkbenchWindow() {
        return UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    private static int showAlreadyExists(IWorkbenchWindow window, File theFile) {
        MessageBox messageBox = new MessageBox(window.getShell(), 200);
        messageBox.setText(Messages.BasicIDESupport_FILE_ALREADY_EXISTS_TITLE);
        messageBox.setMessage(String.valueOf(Messages.BasicIDESupport_FILE_ALREADY_MESSAGE_TEXT) + '\n' + theFile.getAbsolutePath());
        return messageBox.open();
    }

    private static void showAppend(IWorkbenchWindow window, File theFile) {
        MessageBox messageBox = new MessageBox(window.getShell(), 40);
        messageBox.setText(Messages.BasicIDESupport_FILE_ALREADY_EXISTS_TITLE);
        messageBox.setMessage(String.valueOf(Messages.BasicIDESupport_FILENAME_APPEND_MESSAGE_TEXT) + '\n' + theFile.getAbsolutePath());
        messageBox.open();
    }

    public static IPath getLastPath(String suffix) {
        String s = UIPlugin.getDefault().getPreferenceStore().getString(IDESupportUIToolkit.getLastPathKey(suffix));
        if (s != null && s.length() > 0) {
            return new Path(s);
        }
        return null;
    }

    public static void saveLastPath(IPath path) {
        if (path != null) {
            UIPlugin.getDefault().getPreferenceStore().putValue(IDESupportUIToolkit.getLastPathKey(path.getFileExtension()), path.toOSString());
        }
    }

    public static MCFile getValidDefaultFile(String prefix, String suffix) {
        File directory;
        IPath path = IDESupportUIToolkit.getLastPath(suffix);
        if (path != null && (directory = new File(path.toOSString()).getParentFile()) != null && directory.exists()) {
            try {
                File file = BasicFile.createTempFileWithTimestamp(prefix, BasicFile.getSafeFileExtensionWithDot(suffix), directory);
                if (file.exists() && !file.delete()) {
                    UIPlugin.getDefault().getLogger().severe(String.format("Could not remove temporary file %s!", file.toString()));
                }
                return new BasicFile((IPath)new Path(file.getAbsolutePath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            File file = BasicFile.createTempFileWithTimestamp(prefix, BasicFile.getSafeFileExtensionWithDot(suffix), IDESupportUIToolkit.getWorkspaceLocation());
            if (file.exists() && !file.delete()) {
                UIPlugin.getDefault().getLogger().severe(String.format("Could not remove temporary file %s!", file.toString()));
            }
            return new BasicFile((IPath)new Path(file.getAbsolutePath()));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static File getWorkspaceLocation() {
        File f = Platform.getLocation().toFile();
        if (f.isDirectory()) {
            return f;
        }
        return new File(System.getProperty("user.home", ".\\"));
    }

    private static String getLastPathKey(String suffix) {
        return LAST_IDE_SUPPORT_PATH + BasicFile.getSafeFileExtensionWithDot(suffix);
    }
}

