/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.idesupport;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.idesupport.FiletypeOpener;
import com.jrockit.mc.ui.idesupport.IFiletypeOpener;
import com.jrockit.mc.ui.idesupport.OpenHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class FiletypeManager {
    static final String FILETYPE_OPENER_EXTENSION_POINT_ID = "com.jrockit.mc.ui.filetypeopener";
    static final String FILETYPE_OPENER_EXTENSION_DEFAULT = "default";
    static final String FILETYPE_OPENER_EXTENSION_DESCRIPTION_ATTRIBUTE = "description";
    static final String FILETYPE_OPENER_EXTENSION_NAME_ATTRIBUTE = "name";
    static final String FILETYPE_OPENER_EXTENSION_CLASS_ATTRIBUTE = "class";
    static final String FILETYPE_OPENER_EXTENSION_FILE_EXTENSION_ELEMENT = "fileextension";
    static final String FILETYPE_OPENER_EXTENSION_FILE_EXTENSION_ELEMENT_NAME = "name";
    static final String FILETYPE_OPENER_EXTENSION_FILE_EXTENSION_ELEMENT_FILE_EXTENSION = "fileextension";
    private final List<IFiletypeOpener> m_openers = new ArrayList<IFiletypeOpener>();

    public OpenHandler getFileOpener(String fileName) {
        IFiletypeOpener[] openers;
        IFiletypeOpener[] iFiletypeOpenerArray = openers = this.getFiletypeOpeners();
        int n = openers.length;
        int n2 = 0;
        while (n2 < n) {
            String[] fileExtensions;
            IFiletypeOpener opener = iFiletypeOpenerArray[n2];
            String[] stringArray = fileExtensions = opener.getFileExtensions();
            int n3 = fileExtensions.length;
            int n4 = 0;
            while (n4 < n3) {
                String fileExtension = stringArray[n4];
                if (fileName.endsWith(fileExtension)) {
                    return opener.getCommand();
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public IFiletypeOpener[] getFiletypeOpeners() {
        ArrayList<IFiletypeOpener> openers = new ArrayList<IFiletypeOpener>();
        openers.addAll(this.m_openers);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint exPoint = registry.getExtensionPoint(FILETYPE_OPENER_EXTENSION_POINT_ID);
        if (exPoint != null) {
            openers.addAll(Arrays.asList(this.getExtenders(exPoint)));
        }
        return openers.toArray(new IFiletypeOpener[openers.size()]);
    }

    public void registerFiletypeOpener(IFiletypeOpener opener) {
        this.m_openers.add(opener);
    }

    private IFiletypeOpener[] getExtenders(IExtensionPoint exPoint) {
        List<IFiletypeOpener> openers = this.buildOpenerList(exPoint);
        this.sortOpeners(openers);
        return openers.toArray(new IFiletypeOpener[openers.size()]);
    }

    private List<IFiletypeOpener> buildOpenerList(IExtensionPoint exPoint) {
        IExtension[] ext;
        ArrayList<IFiletypeOpener> openers = new ArrayList<IFiletypeOpener>();
        IExtension[] iExtensionArray = ext = exPoint.getExtensions();
        int n = ext.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] element;
            IExtension element2 = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = element = element2.getConfigurationElements();
            int n3 = element.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element3 = iConfigurationElementArray[n4];
                IFiletypeOpener opener = this.createOpener(element3);
                if (opener != null) {
                    openers.add(opener);
                }
                ++n4;
            }
            ++n2;
        }
        return openers;
    }

    private void sortOpeners(List<IFiletypeOpener> openers) {
        Collections.sort(openers, new Comparator<IFiletypeOpener>(){

            @Override
            public int compare(IFiletypeOpener f1, IFiletypeOpener f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
    }

    private IFiletypeOpener createOpener(IConfigurationElement element) {
        try {
            String name = this.getName(element);
            boolean def = this.getDefault(element);
            String description = this.getDescription(element);
            OpenHandler opener = this.getOpenerCommand(element);
            String[] fileTypes = this.getFileExtensions(element, name);
            String[] fileExtensionNames = this.getFileExtensionNames(element, name);
            return new FiletypeOpener(name, def, description, fileTypes, fileExtensionNames, opener);
        }
        catch (Exception e) {
            UIPlugin.getDefault().getLogger().log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private String getDescription(IConfigurationElement element) throws Exception {
        String description = element.getAttribute(FILETYPE_OPENER_EXTENSION_DESCRIPTION_ATTRIBUTE);
        if (description == null) {
            throw new Exception("Could not find required description attribute for extension point com.jrockit.mc.ui.filetypeopener");
        }
        return description;
    }

    private String getName(IConfigurationElement element) throws Exception {
        String name = element.getAttribute("name");
        if (name == null) {
            throw new Exception("Could not find required name attribute for extension point com.jrockit.mc.ui.filetypeopener");
        }
        return name;
    }

    private boolean getDefault(IConfigurationElement element) throws Exception {
        return Boolean.valueOf(element.getAttribute(FILETYPE_OPENER_EXTENSION_DEFAULT));
    }

    private OpenHandler getOpenerCommand(IConfigurationElement element) throws Exception {
        String className = element.getAttribute(FILETYPE_OPENER_EXTENSION_CLASS_ATTRIBUTE);
        if (className == null) {
            throw new Exception("Could not find required class attribute for extension point com.jrockit.mc.ui.filetypeopener");
        }
        Object opener = element.createExecutableExtension(FILETYPE_OPENER_EXTENSION_CLASS_ATTRIBUTE);
        if (!(opener instanceof OpenHandler)) {
            throw new Exception("Class must implement  " + OpenHandler.class.getName() + " in extension point " + FILETYPE_OPENER_EXTENSION_POINT_ID);
        }
        return (OpenHandler)((Object)opener);
    }

    private String[] getFileExtensions(IConfigurationElement element, String name) throws Exception {
        IConfigurationElement[] elements;
        if (element == null) {
            this.throwFileExtensionException(name);
        }
        if ((elements = element.getChildren("fileextension")) == null || elements.length == 0) {
            this.throwFileExtensionException(name);
        }
        ArrayList<String> fileExtensions = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element2 = iConfigurationElementArray[n2];
            String fileExtension = element2.getAttribute("fileextension");
            if (fileExtension == null) {
                throw new Exception("Error when getting file extension for type " + name + "in extension point " + FILETYPE_OPENER_EXTENSION_POINT_ID);
            }
            fileExtensions.add(fileExtension);
            ++n2;
        }
        return fileExtensions.toArray(new String[fileExtensions.size()]);
    }

    private String[] getFileExtensionNames(IConfigurationElement element, String name) throws Exception {
        IConfigurationElement[] elements;
        if (element == null) {
            this.throwFileExtensionException(name);
        }
        if ((elements = element.getChildren("fileextension")) == null || elements.length == 0) {
            this.throwFileExtensionException(name);
        }
        ArrayList<String> fileExtensionNames = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element2 = iConfigurationElementArray[n2];
            String fileExtension = element2.getAttribute("name");
            if (fileExtension == null) {
                throw new Exception("Error when getting file extension name for type " + name + "in extension point " + FILETYPE_OPENER_EXTENSION_POINT_ID);
            }
            fileExtensionNames.add(fileExtension);
            ++n2;
        }
        return fileExtensionNames.toArray(new String[fileExtensionNames.size()]);
    }

    private void throwFileExtensionException(String name) throws Exception {
        throw new Exception("No file extension name for type " + name + "in extension point " + FILETYPE_OPENER_EXTENSION_POINT_ID);
    }
}

