/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.fields;

import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.ui.accessibility.FocusTracker;
import com.jrockit.mc.ui.fields.AbstractFieldTableContentProvider;
import com.jrockit.mc.ui.fields.Messages;
import com.jrockit.mc.ui.misc.MCColor;
import com.jrockit.mc.ui.misc.SWTColorToolkit;
import com.jrockit.mc.ui.misc.ToolTipManager;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.Row;
import com.jrockit.mc.ui.model.fields.StructuredRowSelection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormText;

public final class PieFieldViewer
extends ContentViewer {
    private static final int ANTI_ALIASING_MARGIN = 10;
    private static final int LINE_WIDTH = 1;
    private static final MCColor PIE_OUTILNE_COLOR = new MCColor(0, 0, 0);
    private static final MCColor PIE_NOT_VALID_COLOR = new MCColor(192, 192, 192);
    private static final int START_ANGLE_OFFSET = 90;
    private Field m_dataField;
    private final Control m_control;
    private Object m_input;
    private ISelection m_selection = StructuredSelection.EMPTY;
    private final Row[] m_rowAtAngle = new Row[360];
    private final Field[] m_fields;
    private double partOfPieFilled;
    private int undrawnItems;

    public PieFieldViewer(Composite parent, Field[] fields) {
        this.m_control = this.crearteControl(parent);
        this.m_fields = fields;
    }

    private Control crearteControl(Composite parent) {
        Composite control = new Composite(parent, 0x20000000);
        this.hookPaintListener(control);
        PieFieldViewer.hookAccessibleListener(control);
        this.hookTooltipListener(control);
        PieFieldViewer.hookFocusListener(control);
        this.hookSelectionListener(control);
        return control;
    }

    public ISelection getSelection() {
        return this.m_selection;
    }

    public void refresh() {
        this.m_control.redraw();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.m_selection = selection;
    }

    public Control getControl() {
        return this.m_control;
    }

    public int getMargin() {
        return 10;
    }

    public void setLabelProvider(IBaseLabelProvider provider) {
        if (provider != null) {
            if (!(provider instanceof IColorProvider)) {
                throw new RuntimeException("LabelProvider must be null or an instance of IColorProvider");
            }
            if (!(provider instanceof ILabelProvider)) {
                throw new RuntimeException("LabelProvider must be null or an instance of ILabelProvider");
            }
        }
        super.setLabelProvider(provider);
    }

    public void setDataField(Field field) {
        this.m_dataField = field;
    }

    public void setContentProvider(IContentProvider contentProvider) {
        if (!(contentProvider instanceof AbstractFieldTableContentProvider)) {
            throw new RuntimeException("ContentProvider must be an AbstractFieldTableContentProvider");
        }
        super.setContentProvider(contentProvider);
    }

    private double getValue(Object element) {
        if (element instanceof Row && this.m_dataField != null) {
            Object o = ((Row)element).getColumn(this.m_dataField.INDEX);
            return o instanceof Number ? ((Number)o).doubleValue() : Double.NaN;
        }
        return Double.NaN;
    }

    private void drawDropShadow(GC gc, Point center, int radius) {
        if (radius < 1) {
            return;
        }
        gc.setAntialias(1);
        int r = 0;
        while (r < 8) {
            Color d = new Color(gc.getDevice(), 250 - r * 12, 250 - r * 12, 250 - r * 12);
            gc.setBackground(d);
            gc.fillArc(center.x - radius, center.y - radius, radius * 2 + 8 - r, radius * 2 + 8 - r, 0, 360);
            d.dispose();
            ++r;
        }
        gc.setAntialias(0);
    }

    public Point getCenter() {
        if (this.m_control != null) {
            return new Point(this.m_control.getBounds().width / 2, this.m_control.getBounds().height / 2);
        }
        return null;
    }

    public int getRadius() {
        if (this.m_control != null) {
            return Math.min(this.m_control.getBounds().width / 2, this.m_control.getBounds().height / 2) - this.getMargin();
        }
        return 0;
    }

    private Object[] getRowElements() {
        AbstractFieldTableContentProvider provider = (AbstractFieldTableContentProvider)this.getContentProvider();
        Assert.isNotNull((Object)provider);
        return provider.getCurrentElements();
    }

    private void drawBackground(GC gc, Rectangle rect) {
        gc.fillRectangle(rect);
    }

    private static boolean hasValidCenter(Point center) {
        return center != null && center.x >= 0 && center.y > 0;
    }

    private void drawPie(GC gc, Point center, int radius) {
        IBaseLabelProvider lp = this.getLabelProvider();
        if (PieFieldViewer.hasValidCenter(center) && radius > 0 && lp instanceof IColorProvider) {
            Color forground = gc.getForeground();
            Color background = gc.getBackground();
            int linewidth = gc.getLineWidth();
            int antiAlising = gc.getAntialias();
            gc.setBackground(SWTColorToolkit.getColor(PIE_NOT_VALID_COLOR.getRGBColor()));
            gc.setForeground(SWTColorToolkit.getColor(PIE_OUTILNE_COLOR.getRGBColor()));
            gc.setLineWidth(1);
            gc.setAntialias(1);
            this.drawSlices(gc, center, radius, (IColorProvider)lp);
            gc.setBackground(background);
            gc.setForeground(forground);
            gc.setLineWidth(linewidth);
            gc.setAntialias(antiAlising);
        }
    }

    public void setInput(Object input) {
        this.m_input = input;
    }

    public Object getInput() {
        return this.m_input;
    }

    private void drawSlices(GC gc, Point center, int radius, IColorProvider colorProvider) {
        Object[] elements = this.getRowElements();
        double total = 0.0;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            double value = this.getValue(element);
            if (Double.isNaN(value) || value < 0.0) {
                total = 0.0;
                break;
            }
            total += value;
            ++n2;
        }
        this.partOfPieFilled = 0.0;
        this.undrawnItems = elements.length;
        int lastAngle = 0;
        Color background = gc.getBackground();
        if (total > 0.0) {
            boolean reverse = this.getValue(elements[elements.length - 1]) > this.getValue(elements[0]);
            int i = reverse ? elements.length - 1 : 0;
            while (i >= 0 && i < elements.length && lastAngle < 360 && elements[i] instanceof Row) {
                Row row = (Row)elements[i];
                double value = this.getValue(row);
                double normalizedShare = value / total;
                int nextAngle = (int)(360.0 * (this.partOfPieFilled + normalizedShare) + 0.5);
                if (nextAngle > lastAngle) {
                    this.partOfPieFilled += normalizedShare;
                    --this.undrawnItems;
                    Color backgroundColor = colorProvider.getBackground(row.getElement());
                    if (backgroundColor != null) {
                        gc.setBackground(backgroundColor);
                    } else {
                        gc.setBackground(background);
                    }
                    if (lastAngle == 0 && nextAngle == 360) {
                        this.drawPieSliceFromOffset(gc, center, radius, 0, 360, false, row);
                        return;
                    }
                    this.drawPieSliceFromOffset(gc, center, radius, lastAngle, nextAngle, true, row);
                    lastAngle = nextAngle;
                }
                i += reverse ? -1 : 1;
            }
        }
        gc.setBackground(background);
        if (lastAngle == 0) {
            this.drawPieSliceFromOffset(gc, center, radius, 0, 360, false, null);
            return;
        }
        if (lastAngle < 360) {
            this.drawPieSliceFromOffset(gc, center, radius, lastAngle, 360, true, null);
        }
        PieFieldViewer.drawPieLine(gc, center.x, center.y, radius, 90);
    }

    public Integer getSelectedAngle(int x, int y) {
        Point center = this.getCenter();
        int radius = this.getRadius();
        if (center != null && PieFieldViewer.isInsideCircle(x, y, center.x, center.y, radius)) {
            return (int)(-PieFieldViewer.getMathAngle(center.x, -center.y, x, -y) + 90.0 + 360.0 + 0.5) % 360;
        }
        return null;
    }

    private static boolean isInsideCircle(int x, int y, int centerX, int centerY, int radius) {
        return (x - centerX) * (x - centerX) + (y - centerY) * (y - centerY) < radius * radius;
    }

    private static double getMathAngle(int centerX, int centerY, int positionX, int positionY) {
        return Math.toDegrees(Math.atan2(positionY - centerY, positionX - centerX));
    }

    private void drawPieSliceFromOffset(GC gc, Point center, int radius, int startAngle, int endAngle, boolean pieLine, Row row) {
        int i = startAngle;
        while (i < endAngle) {
            this.m_rowAtAngle[i] = row;
            ++i;
        }
        int startWithOffset = -startAngle + 90;
        int endWithOffset = -endAngle + 90;
        this.drawPieSlice(gc, center.x, center.y, radius, startWithOffset, endWithOffset - startWithOffset);
        if (pieLine) {
            PieFieldViewer.drawPieLine(gc, center.x, center.y, radius, startWithOffset);
        }
    }

    private static void drawPieLine(GC gc, int x, int y, int radius, int startWithOffset) {
        int x1 = (int)((double)radius * Math.cos(Math.toRadians(startWithOffset)));
        int y1 = (int)((double)radius * Math.sin(Math.toRadians(startWithOffset)));
        Color oldColor = gc.getForeground();
        int oldAlpha = gc.getAlpha();
        Color color = new Color(gc.getDevice(), 0, 0, 0);
        gc.setAlpha(96);
        gc.setForeground(color);
        gc.drawLine(x, y, x + x1, y - y1);
        color.dispose();
        gc.setForeground(oldColor);
        gc.setAlpha(oldAlpha);
    }

    private void hookSelectionListener(Composite control) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1 && (e.stateMask & SWT.MOD4) == 0) {
                    IStructuredSelection s = this.createSelection(e.x, e.y);
                    PieFieldViewer.this.setSelection((ISelection)s);
                    PieFieldViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)PieFieldViewer.this, (ISelection)s));
                }
            }

            private IStructuredSelection createSelection(int x, int y) {
                Row row;
                Integer angle = PieFieldViewer.this.getSelectedAngle(x, y);
                if (angle != null && (row = PieFieldViewer.this.m_rowAtAngle[angle]) != null) {
                    return new StructuredRowSelection(row, PieFieldViewer.this.m_fields);
                }
                return StructuredSelection.EMPTY;
            }
        });
    }

    private static void hookFocusListener(Composite control) {
        FocusTracker.enableFocusTracking(control);
    }

    private void hookTooltipListener(Composite control) {
        new ToolTipManager(control, new ToolTipProvider());
    }

    private static void hookAccessibleListener(Composite control) {
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Pie chart";
            }
        });
    }

    private void hookPaintListener(final Composite control) {
        control.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                PieFieldViewer.this.drawBackground(e.gc, control.getBounds());
                PieFieldViewer.this.drawDropShadow(e.gc, PieFieldViewer.this.getCenter(), PieFieldViewer.this.getRadius());
                PieFieldViewer.this.drawPie(e.gc, PieFieldViewer.this.getCenter(), PieFieldViewer.this.getRadius());
            }
        });
    }

    protected void drawPieSlice(GC gc, int x, int y, int radius, int startAngle, int arcAngle) {
        gc.fillArc(x - radius, y - radius, radius * 2, radius * 2, startAngle, arcAngle);
        gc.drawArc(x - radius, y - radius, radius * 2, radius * 2, startAngle, arcAngle);
    }

    public final class ToolTipProvider
    implements ToolTipManager.ToolTipProvider {
        @Override
        public boolean initializeToolTip(FormText toolTip, int x, int y) {
            IBaseLabelProvider lp = PieFieldViewer.this.getLabelProvider();
            Integer angle = PieFieldViewer.this.getSelectedAngle(x, y);
            if (angle != null && lp instanceof ILabelProvider) {
                Row row = PieFieldViewer.this.m_rowAtAngle[angle];
                if (row != null) {
                    Image image = ((ILabelProvider)lp).getImage(row.getElement());
                    String text = this.buildTooltipText(PieFieldViewer.this.m_fields, row, image != null);
                    if (text != null) {
                        toolTip.setText(text, true, false);
                        if (image != null) {
                            toolTip.setImage("image", image);
                        }
                    }
                } else {
                    toolTip.setWhitespaceNormalized(false);
                    toolTip.setText(NLS.bind((String)Messages.PieFieldViewer_REST_SLICE_TOOLTIP_TEXT, (Object)PieFieldViewer.this.undrawnItems, (Object)KindOfQuantity.format((Number)(1.0 - PieFieldViewer.this.partOfPieFilled), (IUnit)UnitLookup.PERCENT_UNITY)), false, false);
                }
                return true;
            }
            return false;
        }

        public String buildTooltipText(Field[] fields, Row row, boolean color) {
            if (fields.length == 0) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("<form>");
            int n = 0;
            while (n < fields.length) {
                builder.append("<p vspace='false'>");
                if (color && n == 0) {
                    builder.append("<img align='middle' href='image' />\u00a0");
                }
                if (n == 0) {
                    builder.append("<b>");
                    builder.append(this.unformattedRow(fields[n], row));
                    builder.append("</b>");
                } else {
                    builder.append(this.unformattedRow(fields[n], row));
                }
                builder.append("</p>");
                ++n;
            }
            builder.append("</form>");
            return builder.toString();
        }

        private String unformattedRow(Field field, Row row) {
            String name = field.getName();
            String content = field.formatObject(row.getColumn(field.INDEX));
            return String.valueOf(name) + ": " + content;
        }
    }
}

