/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.dial;

import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.ui.accessibility.FocusTracker;
import com.jrockit.mc.ui.dial.DialConfiguration;
import com.jrockit.mc.ui.dial.DialConfigurationPage;
import com.jrockit.mc.ui.dial.DialInformationProvider;
import com.jrockit.mc.ui.dial.DialInformationViewer;
import com.jrockit.mc.ui.dial.DialViewer;
import com.jrockit.mc.ui.dial.Messages;
import com.jrockit.mc.ui.dial.MovingDial;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class Dial
extends Composite {
    private static final String LAST_DIAL_ID = "last";
    private static final String MAX_DIAL_ID = "max";
    private DialConfiguration m_dialConfiguration;
    private final DialViewer m_dialViewer;
    private final DialInformationViewer m_dialInformationViewer;
    private final StackLayout stackLayout = new StackLayout();
    private DialInformationProvider maxDialInformationProvider;

    public Dial(Composite parent, FormToolkit formToolkit, DialConfiguration dialConfiguration) {
        super(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.m_dialViewer = new DialViewer(this, 0);
        FocusTracker.enableFocusTracking(this.m_dialViewer);
        this.m_dialViewer.setLayoutData(new GridData(4, 4, true, false));
        formToolkit.adapt((Composite)this.m_dialViewer);
        Composite infoPart = new Composite((Composite)this, 0);
        infoPart.setLayoutData((Object)new GridData(4, 4, true, false));
        infoPart.setLayout((Layout)this.stackLayout);
        CLabel noValuesYetLabel = new CLabel(infoPart, 0x1000000);
        noValuesYetLabel.setText(Messages.DialViewer_NO_VALUE_YET_TEXT);
        formToolkit.adapt((Composite)noValuesYetLabel);
        this.stackLayout.topControl = noValuesYetLabel;
        this.m_dialInformationViewer = new DialInformationViewer(infoPart, formToolkit, 0);
        formToolkit.adapt((Composite)this.m_dialInformationViewer);
        formToolkit.paintBordersFor((Composite)this);
        formToolkit.adapt((Composite)this);
        this.setDialConfiguration(dialConfiguration);
    }

    public void setUnit(IUnit<?> unit) {
        this.m_dialViewer.setUnit(unit);
        this.m_dialViewer.clear();
        this.m_dialInformationViewer.clear();
        this.m_dialViewer.addDialProvider(LAST_DIAL_ID, new MovingDial());
        this.m_dialInformationViewer.addDialInformationProvider(LAST_DIAL_ID, new DialInformationProvider(unit, Messages.DIAL_LAST_VALUE_TEXT));
        this.maxDialInformationProvider = new DialInformationProvider(unit, Messages.DIAL_MAX_VALUE_TEXT);
        this.updateWatermark();
    }

    public void updateWatermark() {
        if (this.m_dialConfiguration.getUseWatermark()) {
            this.m_dialViewer.addDialProvider(MAX_DIAL_ID, new MovingDial(this.m_dialConfiguration.getWatermarkColor()));
            this.m_dialInformationViewer.addDialInformationProvider(MAX_DIAL_ID, this.maxDialInformationProvider);
        } else {
            this.m_dialViewer.removeDialProvider(MAX_DIAL_ID);
            this.m_dialInformationViewer.removeDialInformationProvider(MAX_DIAL_ID);
        }
    }

    public void setDialConfiguration(DialConfiguration dialConfiguration) {
        this.m_dialConfiguration = dialConfiguration;
        this.m_dialViewer.setTitle(dialConfiguration.getTitle());
        this.m_dialViewer.setGradientRange(dialConfiguration.getGradientBeginValue(), dialConfiguration.getGradientEndValue(), dialConfiguration.getGradientBeginColor(), dialConfiguration.getGradientEndColor());
        this.updateWatermark();
    }

    public void setInput(Number last, Number max) {
        this.m_dialViewer.setInput(LAST_DIAL_ID, last);
        this.m_dialInformationViewer.setInput(LAST_DIAL_ID, last);
        if (this.m_dialConfiguration.getUseWatermark()) {
            this.m_dialViewer.setInput(MAX_DIAL_ID, max);
            this.m_dialInformationViewer.setInput(MAX_DIAL_ID, max);
        }
        this.m_dialViewer.refresh();
        this.m_dialInformationViewer.refresh();
        if (this.stackLayout.topControl != this.m_dialInformationViewer) {
            this.stackLayout.topControl = this.m_dialInformationViewer;
            this.layout(true, true);
        }
    }

    public boolean setFocus() {
        if (this.m_dialViewer != null && !this.m_dialViewer.isDisposed()) {
            return this.m_dialViewer.setFocus();
        }
        return this.setFocus();
    }

    public DialConfiguration getDialConfiguration() {
        return this.m_dialConfiguration;
    }

    public DialViewer getDialViewer() {
        return this.m_dialViewer;
    }

    public IAction getPropertiesAction() {
        return new Action(Messages.DIAL_PROPERTIES_ACTION_TEXT){

            public void run() {
                DialConfigurationPage dp = new DialConfigurationPage(Dial.this.getDialConfiguration(), Dial.this.m_dialViewer.getUnit().getContentType());
                OnePageWizardDialog dialog = new OnePageWizardDialog(Dial.this.getShell(), (IWizardPage)dp);
                dialog.setWidthConstraint(450, 450);
                dialog.setHeightConstraint(450, 450);
                if (dialog.open() == 0) {
                    Dial.this.setDialConfiguration(dp.getConfiguration());
                }
            }
        };
    }
}

