/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui;

import com.jrockit.mc.ui.MCPathFactory;
import com.jrockit.mc.ui.Messages;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;

public class MCPathEditorInput
implements IPathEditorInput,
IPersistableElement {
    private final IPath m_path;
    private final boolean m_persistable;
    private final Map<String, String> m_userData = new HashMap<String, String>();

    public MCPathEditorInput(IPath path, boolean persistable) {
        this.m_path = path;
        this.m_persistable = persistable;
    }

    public boolean exists() {
        return this.m_path != null && this.m_path.toFile().exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        File file = this.getFile();
        return file == null ? Messages.MCPathEditorInput_UNKNOWN_TEXT : file.getName();
    }

    private File getFile() {
        assert (this.m_path != null);
        if (this.m_path != null) {
            File file = this.m_path.toFile();
            assert (file != null);
            return file;
        }
        return null;
    }

    public IPersistableElement getPersistable() {
        if (this.m_persistable) {
            return this;
        }
        return null;
    }

    public String getToolTipText() {
        File file = this.getFile();
        return file == null ? Messages.MCPathEditorInput_UNKNOWN_TEXT : file.getPath();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IPath getPath(Object element) {
        return this.m_path;
    }

    public IPath getPath() {
        return this.m_path;
    }

    public boolean equals(Object object) {
        if (object instanceof IEditorInput) {
            return this.equalsMCPathEditorInputOnly(MCPathFactory.createMCPathEditorInput((IEditorInput)object, false));
        }
        return false;
    }

    public int hashCode() {
        if (this.m_path != null) {
            return this.m_path.hashCode();
        }
        return 0;
    }

    private boolean equalsMCPathEditorInputOnly(Object object) {
        if (object instanceof MCPathEditorInput) {
            return this.m_path != null && this.m_path.equals((Object)((MCPathEditorInput)object).getPath());
        }
        return false;
    }

    public String getFactoryId() {
        return "mc.path.editorinput";
    }

    public void saveState(IMemento memento) {
        memento.putString("portable.string", this.m_path.toPortableString());
        memento.putInteger("persist.editor", this.m_persistable ? 1 : 0);
    }

    public void setUserData(String key, String value) {
        this.m_userData.put(key, value);
    }

    public String getUserData(String key) {
        return this.m_userData.get(key);
    }
}

