/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.views.types;

import com.jrockit.mc.flightrecorder.EventAppearance;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitable;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TypeFolder
implements IVisitable {
    private final String name;
    private final List<TypeDescriptor> descriptors = new ArrayList<TypeDescriptor>();
    private final List<TypeFolder> folders = new ArrayList<TypeFolder>();

    public TypeFolder() {
        this(Messages.EVENT_TYPES_VIEW_DEFAULT_FOLDER_NAME_TEXT);
    }

    public TypeFolder(String name) {
        this.name = name;
    }

    public List<TypeDescriptor> getTypeDescriptors() {
        return this.descriptors;
    }

    public List<TypeFolder> getFolders() {
        return this.folders;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return null;
    }

    public TypeFolder getOrCreateFolderFromPath(String path) {
        TypeFolder folder2;
        String name = EventAppearance.getHumanSegmentName((String)path);
        for (TypeFolder folder2 : this.getFolders()) {
            if (!name.equals(folder2.getName())) continue;
            return folder2;
        }
        folder2 = new TypeFolder(name);
        this.getFolders().add(folder2);
        return folder2;
    }

    public List<IVisitable> getChildren() {
        ArrayList<IVisitable> list = new ArrayList<IVisitable>();
        for (TypeFolder folder : this.getFolders()) {
            if (!folder.hasTypeDescriptor()) continue;
            list.add(folder);
        }
        list.addAll(this.getTypeDescriptors());
        return Collections.unmodifiableList(list);
    }

    private boolean hasTypeDescriptor() {
        for (TypeFolder folder : this.getFolders()) {
            if (!folder.hasTypeDescriptor()) continue;
            return true;
        }
        return !this.getTypeDescriptors().isEmpty();
    }

    @Override
    public void accept(IVisitor visistor) {
        visistor.visit(this);
    }
}

