/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree;

import com.jrockit.mc.common.IMCAggregatedFrame;
import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCStackTrace;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.IAggregator;
import com.jrockit.mc.flightrecorder.ui.components.column.GathererFactory;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItem;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameEqualityChecker;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameNode;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.Normalizer;

public class FrameNodeTreeBuilder {
    private final FrameNode m_topNode;
    private final GathererFactory m_gathererFactory;
    private final FrameEqualityChecker m_frameEqualityChecker;
    private final IMCAggregatedFrame.AggregationType m_type;

    public FrameNodeTreeBuilder(FrameNode topNode, FrameEqualityChecker frameEqualityChecker, GathererFactory gathererFactory, IMCAggregatedFrame.AggregationType type) {
        this.m_gathererFactory = gathererFactory;
        this.m_frameEqualityChecker = frameEqualityChecker;
        this.m_topNode = topNode;
        this.m_type = type;
    }

    protected final FrameNode getTopNode() {
        return this.m_topNode;
    }

    protected void addTrace(HistogramItem traceInformation) {
        FrameNode frameNode = this.getTopNode();
        IAggregator[] aggregators = traceInformation.getAggregators();
        Object object = traceInformation.getKey();
        if (object instanceof IMCStackTrace) {
            IMCStackTrace s = (IMCStackTrace)object;
            for (IMCFrame frame : s.getFrames()) {
                frameNode = this.nextFrameNode(traceInformation, frameNode, frame);
                frameNode.addAggregators(aggregators);
                traceInformation.setUsed(true);
            }
        }
    }

    protected final FrameNode nextFrameNode(HistogramItem item, FrameNode currentNode, IMCFrame addFrame) {
        for (FrameNode childNode : currentNode.getChildren()) {
            if (!this.m_frameEqualityChecker.isEqual(childNode.getFrame(), addFrame)) continue;
            return childNode;
        }
        FrameNode node = this.createFrameNode(item, addFrame, currentNode.getNormalizer());
        currentNode.addChild(node);
        return node;
    }

    protected final FrameNode createFrameNode(HistogramItem item, IMCFrame frame, Normalizer normalizer) {
        return new FrameNode(item, frame, this.m_gathererFactory.createGather(), this.m_type, normalizer);
    }
}

