/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.ui.components.graph.ChartConfiguration;
import com.jrockit.mc.flightrecorder.ui.components.graph.RangeManager;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.coloring.EventColorFactory;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.coloring.IEventColor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIComponentBuilder;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIComponents;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.EventToolkit;

public class UIModel {
    public static final String MODEL_IDENTIFIER = "latency.model";
    private final FlightRecording m_recording;
    private final RangeManager m_rangeMananger;
    private final ChartConfiguration m_chartConfiguration;
    private UIComponents m_uiComponents;
    private final IEventColor m_eventColor;

    public UIModel(IServiceLocator locator, ChartConfiguration chartConfiguration) {
        this.m_recording = (FlightRecording)locator.getService(FlightRecording.class);
        this.m_rangeMananger = new RangeManager(this.m_recording);
        this.m_chartConfiguration = chartConfiguration;
        this.m_eventColor = EventColorFactory.create(locator, this.m_chartConfiguration);
    }

    public void initialize() {
        if (this.m_uiComponents == null) {
            this.m_uiComponents = new UIComponents();
            UIComponentBuilder builder = new UIComponentBuilder(this.m_recording);
            builder.populate(this.m_uiComponents);
            this.updateGCTrackVisibility();
        }
    }

    public UIComponents getUIComponents() {
        return this.m_uiComponents;
    }

    public RangeManager getRangeMananger() {
        return this.m_rangeMananger;
    }

    public void dispose() {
        this.m_rangeMananger.dispose();
        this.m_uiComponents.dispose();
    }

    public FlightRecording getRecording() {
        return this.m_recording;
    }

    public void updateGCTrackVisibility() {
        for (IEventType ie : this.m_recording.getEventTypes()) {
            if (!this.m_uiComponents.getGarbageCollector().isGCPath(ie.getPath())) continue;
            EventToolkit.setVisible(ie, this.m_chartConfiguration.isGCBackdropVisible());
        }
    }

    public IEventColor getEventColor() {
        return this.m_eventColor;
    }
}

