/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ref;

import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.SystemUtils;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.List;

public class CodeRef {
    private final URL jarLocation;
    private final String jarVersion;
    private final CodeSigner[] signers;
    private final String checksum;
    private final String checksumAlg;

    public CodeRef(URL uRL, String string) {
        this.jarLocation = uRL;
        this.jarVersion = string;
        this.signers = null;
        this.checksum = null;
        this.checksumAlg = null;
    }

    public CodeRef(URL uRL, String string, CodeSigner[] codeSignerArray, String string2, String string3) {
        this.jarLocation = uRL;
        this.jarVersion = string;
        this.signers = codeSignerArray;
        this.checksum = string2;
        this.checksumAlg = string3;
    }

    public URL getJarLocation() {
        return this.jarLocation;
    }

    public String getJarVersion() {
        return this.jarVersion;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof CodeRef)) {
            return false;
        }
        CodeRef codeRef = (CodeRef)object;
        boolean bl2 = this.jarLocation == null ? codeRef.jarLocation == null : (bl = this.jarLocation.equals(codeRef.jarLocation));
        boolean bl3 = this.jarVersion == null ? codeRef.jarVersion == null : this.jarVersion.equals(codeRef.jarVersion);
        return bl && bl3;
    }

    public int hashCode() {
        return (this.jarLocation == null ? 0 : this.jarLocation.hashCode()) + (this.jarVersion == null ? 0 : this.jarVersion.hashCode());
    }

    public CodeSigner[] getCodeSigners() throws IOException {
        if (this.signers == null) {
            Resource resource = ResourceProvider.get().getResource(this.jarLocation, this.jarVersion);
            return resource.getCodeSigners();
        }
        return this.signers;
    }

    public Certificate[] getCerts(CodeSigner codeSigner) {
        List<? extends Certificate> list = codeSigner.getSignerCertPath().getCertificates();
        return list.toArray(new Certificate[0]);
    }

    public String getChecksum(final String string) throws IOException {
        if (this.checksum == null || this.checksumAlg == null || !this.checksumAlg.equals(string)) {
            final String[] stringArray = new String[]{""};
            try {
                final Resource resource = ResourceProvider.get().getResource(this.jarLocation, this.jarVersion);
                if (resource != null) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            stringArray[0] = SystemUtils.getFileChecksum(resource.getDataFile(), string);
                            return null;
                        }
                    });
                }
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
            return stringArray[0];
        }
        return this.checksum;
    }

    public String toString() {
        String string = "\n        jar location: " + this.jarLocation + "\n        jar version: " + this.jarVersion;
        return string;
    }
}

