/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.quicksearch.Bundle;
import org.netbeans.modules.quicksearch.CategoryResult;
import org.netbeans.modules.quicksearch.CommandEvaluator;
import org.netbeans.modules.quicksearch.ProviderModel;
import org.netbeans.modules.quicksearch.QuickSearchPopup;
import org.netbeans.modules.quicksearch.ResultsModel;
import org.netbeans.modules.quicksearch.SearchResultRender;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public abstract class AbstractQuickSearchComboBar
extends JPanel {
    QuickSearchPopup displayer = new QuickSearchPopup(this);
    WeakReference<TopComponent> caller;
    Color origForeground;
    protected final KeyStroke keyStroke;
    protected JTextComponent command;

    public AbstractQuickSearchComboBar(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
        this.initComponents();
        this.setShowHint(true);
        this.command.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.textChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.textChanged();
            }

            private void textChanged() {
                if (AbstractQuickSearchComboBar.this.command.isFocusOwner()) {
                    AbstractQuickSearchComboBar.this.displayer.maybeEvaluate(AbstractQuickSearchComboBar.this.command.getText());
                }
            }
        });
        if (this.command.getDocument() instanceof AbstractDocument) {
            AbstractDocument abstractDocument = (AbstractDocument)this.command.getDocument();
            abstractDocument.setDocumentFilter(new InvalidSearchTextDocumentFilter());
        }
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    protected abstract JTextComponent createCommandField();

    protected abstract JComponent getInnerComponent();

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
        this.setName("Form");
        this.setOpaque(false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AbstractQuickSearchComboBar.this.formFocusLost(focusEvent);
            }
        });
        this.command = this.createCommandField();
        String string = "";
        if (!SearchResultRender.getKeyStrokeAsText(this.keyStroke).isEmpty()) {
            string = "(" + SearchResultRender.getKeyStrokeAsText(this.keyStroke) + ")";
        }
        this.command.setToolTipText(NbBundle.getMessage(AbstractQuickSearchComboBar.class, (String)"AbstractQuickSearchComboBar.command.toolTipText", (Object[])new Object[]{string}));
        this.command.setName("command");
        this.command.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AbstractQuickSearchComboBar.this.commandFocusGained(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AbstractQuickSearchComboBar.this.commandFocusLost(focusEvent);
            }
        });
        this.command.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                AbstractQuickSearchComboBar.this.commandKeyPressed(keyEvent);
            }
        });
        this.command.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AbstractQuickSearchComboBar.this.displayer.explicitlyInvoked();
            }
        });
    }

    private void formFocusLost(FocusEvent focusEvent) {
        this.displayer.setVisible(false);
    }

    private void commandKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 40) {
            this.displayer.selectNext();
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 38) {
            this.displayer.selectPrev();
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 10) {
            keyEvent.consume();
            this.invokeSelectedItem();
        } else if (keyEvent.getKeyCode() == 27) {
            this.returnFocus(true);
            this.displayer.clearModel();
        } else if (keyEvent.getKeyCode() == 121 && keyEvent.isShiftDown()) {
            keyEvent.consume();
            this.maybeShowPopup(null);
        }
    }

    public void invokeSelectedItem() {
        Runnable runnable;
        JList jList = this.displayer.getList();
        ResultsModel.ItemResult itemResult = (ResultsModel.ItemResult)jList.getSelectedValue();
        if (itemResult != null && (runnable = itemResult.getAction()) instanceof CategoryResult) {
            CategoryResult categoryResult = (CategoryResult)runnable;
            this.evaluate(categoryResult.getCategory());
            return;
        }
        if (jList.getModel().getSize() > 0) {
            this.returnFocus(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractQuickSearchComboBar.this.displayer.invoke();
                }
            });
        }
    }

    private void returnFocus(boolean bl) {
        TopComponent topComponent;
        this.displayer.setVisible(false);
        if (this.caller != null && (topComponent = (TopComponent)this.caller.get()) != null) {
            topComponent.requestActive();
            topComponent.requestFocus();
            return;
        }
        if (bl) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        }
    }

    private void commandFocusLost(FocusEvent focusEvent) {
        this.displayer.setVisible(false);
        this.setShowHint(true);
    }

    private void commandFocusGained(FocusEvent focusEvent) {
        this.caller = new WeakReference<TopComponent>(TopComponent.getRegistry().getActivated());
        this.setShowHint(false);
        CommandEvaluator.dropTemporaryCat();
    }

    protected void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent != null && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        HashSet<ProviderModel.Category> hashSet = new HashSet<ProviderModel.Category>();
        hashSet.addAll(CommandEvaluator.getEvalCats());
        AllMenuItem allMenuItem = new AllMenuItem(hashSet);
        jPopupMenu.add(allMenuItem);
        for (ProviderModel.Category category : ProviderModel.getInstance().getCategories()) {
            if ("Recent".equals(category.getName())) continue;
            CategoryCheckBoxMenuItem categoryCheckBoxMenuItem = new CategoryCheckBoxMenuItem(category, hashSet);
            jPopupMenu.add(categoryCheckBoxMenuItem);
        }
        jPopupMenu.show(this.getInnerComponent(), 0, this.getInnerComponent().getHeight() - 1);
    }

    private void updateCats(Set<ProviderModel.Category> set) {
        CommandEvaluator.setEvalCats(set);
        CommandEvaluator.dropTemporaryCat();
        this.setShowHint(!this.command.isFocusOwner());
    }

    private void updateCheckBoxes(Container container, Set<ProviderModel.Category> set) {
        Container container2 = container.getParent();
        for (Component component : container2.getComponents()) {
            if (!(component instanceof CategoryCheckBoxMenuItem)) continue;
            CategoryCheckBoxMenuItem categoryCheckBoxMenuItem = (CategoryCheckBoxMenuItem)component;
            categoryCheckBoxMenuItem.setSelected(set.contains(categoryCheckBoxMenuItem.category));
            categoryCheckBoxMenuItem.setTooltipText();
        }
    }

    public void evaluate(ProviderModel.Category category) {
        if (category != null) {
            CommandEvaluator.setTemporaryCat(category);
        } else {
            CommandEvaluator.dropTemporaryCat();
        }
        this.displayer.maybeEvaluate(this.command.getText());
    }

    public void setNoResults(boolean bl) {
        if (this.command == null || this.origForeground == null) {
            return;
        }
        if (this.command.getForeground().equals(this.command.getDisabledTextColor())) {
            return;
        }
        this.command.setForeground(bl ? Color.RED : this.origForeground);
    }

    private void setShowHint(boolean bl) {
        if (this.origForeground == null) {
            this.origForeground = this.command.getForeground();
        }
        if (bl) {
            this.command.setForeground(this.command.getDisabledTextColor());
            Set<ProviderModel.Category> set = CommandEvaluator.getEvalCats();
            if (set.size() < 3 && !CommandEvaluator.isTemporaryCatSpecified()) {
                ProviderModel.Category category = null;
                for (ProviderModel.Category category2 : set) {
                    if (category != null && !"Recent".equals(category.getName())) continue;
                    category = category2;
                }
                this.command.setText(this.getHintText(category));
            } else {
                this.command.setText(this.getHintText(null));
            }
        } else {
            this.command.setForeground(this.origForeground);
            this.command.setText("");
        }
    }

    private String getHintText(ProviderModel.Category category) {
        StringBuilder stringBuilder = new StringBuilder();
        if (category != null) {
            stringBuilder.append(NbBundle.getMessage(AbstractQuickSearchComboBar.class, (String)"MSG_DiscoverabilityHint2", (Object)category.getDisplayName()));
        } else {
            stringBuilder.append(NbBundle.getMessage(AbstractQuickSearchComboBar.class, (String)"MSG_DiscoverabilityHint"));
        }
        String string = SearchResultRender.getKeyStrokeAsText(this.keyStroke);
        if (!string.isEmpty()) {
            stringBuilder.append(" (");
            stringBuilder.append(string);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.command.requestFocus();
    }

    public JTextComponent getCommand() {
        return this.command;
    }

    public int getBottomLineY() {
        return this.getInnerComponent().getY() + this.getInnerComponent().getHeight();
    }

    static Color getComboBorderColor() {
        Color color = UIManager.getColor(Utilities.isWindows() ? "Nb.ScrollPane.Border.color" : "TextField.shadow");
        return color != null ? color : AbstractQuickSearchComboBar.getPopupBorderColor();
    }

    static Color getPopupBorderColor() {
        Color color = UIManager.getColor("controlShadow");
        return color != null ? color : Color.GRAY;
    }

    static Color getTextBackground() {
        Color color = UIManager.getColor("TextPane.background");
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            color = UIManager.getColor("NbExplorerView.background");
        }
        return color != null ? color : Color.WHITE;
    }

    static Color getResultBackground() {
        return AbstractQuickSearchComboBar.getTextBackground();
    }

    static Color getCategoryTextColor() {
        Color color = UIManager.getColor("textInactiveText");
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            color = UIManager.getColor("Table.foreground");
        }
        return color != null ? color : Color.DARK_GRAY;
    }

    protected int computePrefWidth() {
        FontMetrics fontMetrics = this.command.getFontMetrics(this.command.getFont());
        ProviderModel providerModel = ProviderModel.getInstance();
        int n = 0;
        for (ProviderModel.Category category : providerModel.getCategories()) {
            if ("Recent".equals(category.getName())) continue;
            n = Math.max(n, fontMetrics.stringWidth(this.getHintText(category)));
        }
        return Math.min(350, n);
    }

    private static String dispalyNameFor(ProviderModel.Category category) {
        if (null != category.getCommandPrefix()) {
            return NbBundle.getMessage(AbstractQuickSearchComboBar.class, (String)"LBL_CategoryAndCommandPrefix", (Object)category.getDisplayName(), (Object)category.getCommandPrefix());
        }
        return category.getDisplayName();
    }

    private void showMenuPath(MenuElement[] menuElementArray) {
        if (menuElementArray != null && menuElementArray.length > 1 && menuElementArray[0] instanceof JPopupMenu) {
            ((JPopupMenu)menuElementArray[0]).setVisible(true);
            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
        }
    }

    private class AllMenuItem
    extends JMenuItem
    implements ActionListener {
        private Set<ProviderModel.Category> evalCats;
        private int totalCount;
        private MenuElement[] selectedPath = null;

        public AllMenuItem(Set<ProviderModel.Category> set) {
            this.evalCats = set;
            this.totalCount = ProviderModel.getInstance().getCategories().size();
            this.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AllMenuItem.this.isShowing() && AllMenuItem.this.model.isArmed()) {
                        AllMenuItem.access$1402(AllMenuItem.this, MenuSelectionManager.defaultManager().getSelectedPath());
                    }
                }
            });
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.evalCats.size() == this.totalCount) {
                Iterator<ProviderModel.Category> iterator = this.evalCats.iterator();
                while (iterator.hasNext()) {
                    ProviderModel.Category category = iterator.next();
                    if ("Recent".equals(category.getName())) continue;
                    iterator.remove();
                }
            } else {
                this.evalCats.addAll(ProviderModel.getInstance().getCategories());
            }
            AbstractQuickSearchComboBar.this.updateCats(this.evalCats);
            AbstractQuickSearchComboBar.this.updateCheckBoxes(this, this.evalCats);
        }

        @Override
        public void doClick(int n) {
            super.doClick(n);
            AbstractQuickSearchComboBar.this.showMenuPath(this.selectedPath);
        }

        @Override
        public String getText() {
            if (this.evalCats == null || this.evalCats.size() != this.totalCount) {
                return NbBundle.getMessage(this.getClass(), (String)"LBL_AllCategories");
            }
            return NbBundle.getMessage(this.getClass(), (String)"LBL_NoCategory");
        }

        static /* synthetic */ MenuElement[] access$1402(AllMenuItem allMenuItem, MenuElement[] menuElementArray) {
            allMenuItem.selectedPath = menuElementArray;
            return menuElementArray;
        }
    }

    private class CategoryCheckBoxMenuItem
    extends JCheckBoxMenuItem
    implements ActionListener {
        private MenuElement[] selectedPath;
        private ProviderModel.Category category;
        private final Set<ProviderModel.Category> evalCats;

        public CategoryCheckBoxMenuItem(ProviderModel.Category category, Set<ProviderModel.Category> set) {
            super(AbstractQuickSearchComboBar.dispalyNameFor(category), set.contains(category));
            this.selectedPath = null;
            this.category = category;
            this.evalCats = set;
            this.setTooltipText();
            this.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (CategoryCheckBoxMenuItem.this.isShowing() && CategoryCheckBoxMenuItem.this.model.isArmed()) {
                        CategoryCheckBoxMenuItem.access$802(CategoryCheckBoxMenuItem.this, MenuSelectionManager.defaultManager().getSelectedPath());
                    }
                }
            });
            this.addActionListener(this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    CategoryCheckBoxMenuItem.this.mouseClickedOnItem(mouseEvent);
                }
            });
        }

        @Override
        public void doClick(int n) {
            super.doClick(n);
            this.setTooltipText();
            AbstractQuickSearchComboBar.this.showMenuPath(this.selectedPath);
        }

        private void mouseClickedOnItem(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                mouseEvent.consume();
                if (this.isSelected()) {
                    Iterator<ProviderModel.Category> iterator = this.evalCats.iterator();
                    while (iterator.hasNext()) {
                        ProviderModel.Category category = iterator.next();
                        if ("Recent".equals(category.getName())) continue;
                        iterator.remove();
                    }
                    this.evalCats.add(this.category);
                } else {
                    this.evalCats.addAll(ProviderModel.getInstance().getCategories());
                    this.evalCats.remove(this.category);
                }
                AbstractQuickSearchComboBar.this.updateCheckBoxes(this, this.evalCats);
                AbstractQuickSearchComboBar.this.updateCats(this.evalCats);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isSelected()) {
                this.evalCats.add(this.category);
            } else {
                this.evalCats.remove(this.category);
            }
            AbstractQuickSearchComboBar.this.updateCats(this.evalCats);
        }

        private void setTooltipText() throws MissingResourceException {
            boolean bl = this.evalCats.contains(this.category);
            String string = bl ? "MSG_RightClickEnablesAllOthers" : "MSG_RightClickDisablesOthers";
            StringBuilder stringBuilder = new StringBuilder("<html>");
            stringBuilder.append(NbBundle.getMessage(AbstractQuickSearchComboBar.class, (String)string));
            if (null != this.category.getCommandPrefix()) {
                stringBuilder.append("<br/>");
                stringBuilder.append(NbBundle.getMessage(AbstractQuickSearchComboBar.class, (String)"LBL_TooltipCommandPrefix", (Object)this.category.getCommandPrefix()));
            }
            stringBuilder.append("</html>");
            this.setToolTipText(stringBuilder.toString());
        }

        @Override
        public Point getToolTipLocation(MouseEvent mouseEvent) {
            Point point = new Point((mouseEvent.getX() - 25) / 5 * 5, (mouseEvent.getY() + 15) / 5 * 5);
            return point;
        }

        static /* synthetic */ MenuElement[] access$802(CategoryCheckBoxMenuItem categoryCheckBoxMenuItem, MenuElement[] menuElementArray) {
            categoryCheckBoxMenuItem.selectedPath = menuElementArray;
            return menuElementArray;
        }
    }

    static class InvalidSearchTextDocumentFilter
    extends DocumentFilter {
        private static final int SEARCH_TEXT_LENGTH_LIMIT = 256;
        private static final int SEARCH_NUM_WORDS_LIMIT = 20;

        InvalidSearchTextDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = this.normalizeWhiteSpaces(string);
            if (this.isLengthInLimit(string2, filterBypass, 0)) {
                super.insertString(filterBypass, n, string2, attributeSet);
            } else {
                this.warnAboutInvalidText();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2;
            String string3 = string2 = string == null ? null : this.normalizeWhiteSpaces(string);
            if (string2 == null || this.isLengthInLimit(string2, filterBypass, n2)) {
                super.replace(filterBypass, n, n2, string2, attributeSet);
            } else {
                this.warnAboutInvalidText();
            }
        }

        private boolean isLengthInLimit(String string, DocumentFilter.FilterBypass filterBypass, int n) {
            return this.isLengthInLimit(string, 256 - filterBypass.getDocument().getLength() + n);
        }

        boolean isLengthInLimit(String string, int n) {
            return string.length() <= n && string.split(" ").length <= 20;
        }

        String normalizeWhiteSpaces(String string) {
            String string2 = string.replaceAll("\\s+", " ");
            return string2.length() > 1 ? string2.trim() : string2;
        }

        private void warnAboutInvalidText() {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)Bundle.MSG_INVALID_SEARCH_TEST(), 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
        }
    }
}

