/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.tab;

import com.jrockit.mc.alert.AlertPlugin;
import com.jrockit.mc.console.ui.actions.MBeanAutomaticRefreshAction;
import com.jrockit.mc.console.ui.notification.NotificationPlugin;
import com.jrockit.mc.console.ui.notification.tab.Messages;
import com.jrockit.mc.console.ui.notification.tab.RuleCheckedStateProvider;
import com.jrockit.mc.console.ui.notification.tab.RuleGroup;
import com.jrockit.mc.console.ui.notification.tab.TriggerContentProvider;
import com.jrockit.mc.console.ui.notification.tab.TriggerLabelProvider;
import com.jrockit.mc.console.ui.notification.tab.TriggerMasterDetailsBlock;
import com.jrockit.mc.console.ui.notification.tab.TriggerToolkit;
import com.jrockit.mc.console.ui.notification.wizard.RuleExportWizard;
import com.jrockit.mc.console.ui.notification.wizard.RuleImportWizard;
import com.jrockit.mc.console.ui.notification.wizard.RuleWizardDialog;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.triggers.TriggerRule;
import com.jrockit.mc.rjmx.triggers.internal.NotificationRegistry;
import com.jrockit.mc.ui.checkedstate.CheckedStateManager;
import com.jrockit.mc.ui.checkedstate.ContainerProviderModifier;
import com.jrockit.mc.ui.checkedstate.ICheckedStateModifierProvider;
import com.jrockit.mc.ui.misc.IRefreshable;
import com.jrockit.mc.ui.sections.MCClientSectionPart;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TriggerSectionPart
extends MCClientSectionPart
implements IPartSelectionListener {
    private Button m_addButton;
    private Button m_deleteButton;
    private CheckboxTreeViewer m_viewer;
    private final TriggerMasterDetailsBlock m_master;
    private Button m_exportButton;
    private Button m_importButton;
    private Button m_renameButton;
    private CheckedStateManager m_checkManager;
    private Button m_resetButton;
    private static final int MAX_REMOVE_TRIGGERS_TO_DISPLAY = 5;

    public TriggerSectionPart(Composite parent, FormToolkit toolkit, TriggerMasterDetailsBlock master) {
        super(parent, toolkit, 384, "com.jrockit.mc.console.ui.notification.trigger.table");
        this.m_master = master;
    }

    protected void initializeSection(Section section) {
        this.getSection().setText(Messages.TriggerSectionPart_SECTION_TEXT);
        this.getSection().setDescription(Messages.TriggerSectionPart_SECTION_DESCRIPTION);
    }

    private Object getFirstSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.m_viewer.getSelection();
        return selection.getFirstElement();
    }

    private void selectRule(TriggerRule rule) {
        StructuredSelection s = new StructuredSelection(new Object[]{rule});
        this.m_viewer.setSelection((ISelection)s, true);
        this.getManagedForm().fireSelectionChanged((IFormPart)this, (ISelection)s);
        this.updateButtons();
    }

    private void selectARule() {
        Collection registeredRules = this.getNotificationRepository().getRegisteredRules(this.getConnectionHandle().getServerDescriptor().getGUID());
        Collection availableRules = this.getNotificationRepository().getAvailableRules();
        TriggerRule candidate = null;
        for (TriggerRule rule : registeredRules) {
            candidate = rule;
            if (availableRules.contains(candidate)) break;
        }
        if (candidate != null && availableRules.size() > 0) {
            candidate = (TriggerRule)availableRules.iterator().next();
        }
        if (candidate != null) {
            this.selectRule(candidate);
        }
    }

    public NotificationRegistry getNotificationRepository() {
        return (NotificationRegistry)RJMXPlugin.getDefault().getService(NotificationRegistry.class);
    }

    public Composite createClient(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        Composite client = toolkit.createComposite(parent, 64);
        Color bgColor = parent.getBackground();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        GridData gd = null;
        Tree tree = toolkit.createTree(client, 32);
        tree.setData("name", (Object)"triggers.RulesTree");
        gd = new GridData(4, 4, true, true);
        this.m_viewer = this.createViewer(managedForm, toolkit, tree, client);
        tree.setLayoutData((Object)gd);
        gd = new GridData(4, 1, false, false);
        Composite buttons = this.createButtons(toolkit, client);
        buttons.setBackground(bgColor);
        buttons.setLayoutData((Object)gd);
        client.setBackground(bgColor);
        client.setLayout((Layout)layout);
        bgColor.dispose();
        return client;
    }

    private Composite createButtons(FormToolkit toolkit, Composite client) {
        Composite buttonContainer = toolkit.createComposite(client, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        GridData gd1 = new GridData(4, 1, false, false);
        this.m_addButton = this.createAddButton(toolkit, buttonContainer);
        this.m_addButton.setLayoutData((Object)gd1);
        GridData gd3 = new GridData(4, 1, false, false);
        this.m_renameButton = this.createRenameButton(toolkit, buttonContainer);
        this.m_renameButton.setLayoutData((Object)gd3);
        GridData gd4 = new GridData(4, 1, false, false);
        this.m_deleteButton = this.createDeleteButton(toolkit, buttonContainer);
        this.m_deleteButton.setLayoutData((Object)gd4);
        GridData gd6 = new GridData(4, 1, false, false);
        gd6.verticalIndent = 10;
        this.m_importButton = this.createImport(toolkit, buttonContainer);
        this.m_importButton.setLayoutData((Object)gd6);
        GridData gd7 = new GridData(4, 1, false, false);
        this.m_exportButton = this.createExport(toolkit, buttonContainer);
        this.m_exportButton.setLayoutData((Object)gd7);
        GridData gd8 = new GridData(4, 1, false, false);
        this.m_resetButton = this.createReset(toolkit, buttonContainer);
        this.m_resetButton.setLayoutData((Object)gd8);
        GridData gd9 = new GridData(4, 1, false, false);
        gd9.verticalIndent = 10;
        Button showAlertButton = this.createShowAlertButton(toolkit, buttonContainer);
        showAlertButton.setLayoutData((Object)gd9);
        buttonContainer.setLayout((Layout)layout);
        return buttonContainer;
    }

    private Button createReset(FormToolkit toolkit, Composite buttonContainer) {
        final Button button = toolkit.createButton(buttonContainer, Messages.TriggerSectionPart_TRIGGERS_RESET_BUTTON_TEXT, 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox mb = new MessageBox(button.getShell(), 196);
                mb.setText(Messages.TriggerSectionPart_RESET_TITLE_TEXT);
                mb.setMessage(Messages.TriggerSectionPart_RESET_TO_DEFAULT_QUESTION_TEXT);
                if (mb.open() == 64) {
                    IStatus status = TriggerToolkit.resetTriggers();
                    if (status.getSeverity() != 0) {
                        ErrorDialog.openError((Shell)TriggerSectionPart.this.getSection().getShell(), (String)Messages.TriggerSectionPart_ERROR_MESSAGE_RESETTING_TRIGGERS, null, (IStatus)status);
                    }
                    TriggerSectionPart.this.updateTree();
                    TriggerSectionPart.this.updateButtons();
                }
            }
        });
        return button;
    }

    private void updateTree() {
        this.m_viewer.refresh();
        this.m_checkManager.refresh();
    }

    public void addOrEdit(TriggerRule rule) {
        RuleWizardDialog rwd;
        Display display = Display.getCurrent();
        if (display.isDisposed()) {
            return;
        }
        Shell shell = display.getActiveShell();
        if (shell == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.m_viewer.getSelection();
        String ruleGroupName = Messages.TriggerSectionPart_DEFAULT_RULES_GROUP_NAME_TEXT;
        if (!selection.isEmpty()) {
            Object object = selection.iterator().next();
            if (object instanceof RuleGroup) {
                ruleGroupName = ((RuleGroup)object).getName();
            }
            if (object instanceof TriggerRule) {
                ruleGroupName = ((TriggerRule)object).getRulePath();
            }
        }
        if ((rwd = new RuleWizardDialog(shell, rule, this.getConnectionHandle(), ruleGroupName)).open() != 0) {
            return;
        }
        if (rule == null) {
            rule = rwd.getNewRule();
            if (rule != null) {
                this.getNotificationRepository().addNotificationRule(rule);
            }
        } else {
            this.m_master.flush();
        }
        this.updateTree();
        this.selectRule(rule);
    }

    public void rename(RuleGroup group) {
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.TriggerSectionPart_RENAME_RULE_GROUP_TITLE, Messages.TriggerSectionPart_ENTER_NEW_GROUP_NAME_TEXT, group.getName(), null);
        if (dialog.open() == 0) {
            String newName = dialog.getValue();
            for (TriggerRule rule : group.getRules()) {
                rule.setRulePath(newName);
            }
        }
        this.m_master.flush();
        this.updateTree();
    }

    public void rename(final TriggerRule rule) {
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.TriggerSectionPart_DIALOG_RENAME_RULE_TITLE, Messages.TriggerSectionPart_DIALOG_RENAME_RULE_MESSAGE_TEXT, rule.getName(), new IInputValidator(){

            public String isValid(String newText) {
                for (TriggerRule aRule : TriggerSectionPart.this.getNotificationRepository().getAvailableRules()) {
                    if (!aRule.getName().equals(newText) || aRule == rule) continue;
                    return Messages.TriggerSectionPart_DIALOG_RULE_EXISTS_MESSAGE_TEXT;
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            String newName = dialog.getValue();
            if (!rule.getName().equals(newName)) {
                rule.setName(newName);
            }
        }
        this.m_master.flush();
        this.m_viewer.refresh();
    }

    private Button createShowAlertButton(FormToolkit toolkit, Composite buttonContainer) {
        Button button = toolkit.createButton(buttonContainer, Messages.TriggerSectionPart_BUTTON_SHOW_ALERTS_TEXT0, 0);
        button.setImage(NotificationPlugin.getDefault().getImage("alert_obj.png"));
        button.addSelectionListener((SelectionListener)new ShowAlertsButtonSelectionListener());
        return button;
    }

    private Button createAddButton(FormToolkit toolkit, Composite buttonContainer) {
        Button button = toolkit.createButton(buttonContainer, Messages.TriggerSectionPart_BUTTON_ADD_TEXT, 8);
        button.setToolTipText(Messages.TriggerSectionPart_BUTTON_ADD_TOOLTIP);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TriggerSectionPart.this.addOrEdit(null);
            }
        });
        return button;
    }

    private Button createImport(FormToolkit toolkit, final Composite buttonContainer) {
        Button button = toolkit.createButton(buttonContainer, Messages.TriggerSectionPart_INMPORT_TRIGGERS_BUTTON_TEXT, 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TriggerSectionPart.this.showWizardPage(buttonContainer.getShell(), (IWorkbenchWizard)new RuleImportWizard());
                TriggerSectionPart.this.updateTree();
            }
        });
        return button;
    }

    private Button createExport(FormToolkit toolkit, final Composite buttonContainer) {
        Button button = toolkit.createButton(buttonContainer, Messages.TriggerSectionPart_EXPORT_TRIGGER_BUTTON_TEXT_NAME, 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TriggerSectionPart.this.showWizardPage(buttonContainer.getShell(), (IWorkbenchWizard)new RuleExportWizard());
            }
        });
        return button;
    }

    public void showWizardPage(Shell shell, IWorkbenchWizard wizard) {
        IWorkbench wb = ((IWorkbenchPart)this.getManagedForm().getContainer()).getSite().getWorkbenchWindow().getWorkbench();
        wizard.init(wb, (IStructuredSelection)this.m_viewer.getSelection());
        WizardDialog wd = new WizardDialog(shell, (IWizard)wizard);
        wd.open();
    }

    private Button createRenameButton(FormToolkit toolkit, Composite buttonContainer) {
        Button button = toolkit.createButton(buttonContainer, Messages.TriggerSectionPart_BUTTON_RENAME_TEXT, 8);
        button.setToolTipText(Messages.TriggerSectionPart_TOOLTIP_RENAME_RULE_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selected = TriggerSectionPart.this.getFirstSelected();
                if (selected instanceof TriggerRule) {
                    TriggerSectionPart.this.rename((TriggerRule)selected);
                }
                if (selected instanceof RuleGroup) {
                    TriggerSectionPart.this.rename((RuleGroup)selected);
                }
            }
        });
        return button;
    }

    private boolean askConfirmation(Shell shell, TriggerRule ... rules) {
        LinkedList<String> names = new LinkedList<String>();
        TriggerRule[] triggerRuleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            TriggerRule rule = triggerRuleArray[n2];
            names.add(rule.getName());
            ++n2;
        }
        Collections.sort(names);
        StringBuilder namesBuilder = new StringBuilder();
        int index = 0;
        for (String name : names) {
            if (index < 5) {
                namesBuilder.append("\n");
                namesBuilder.append(name);
            } else if (index == 5) {
                namesBuilder.append("\n...");
                break;
            }
            ++index;
        }
        String messageText = NLS.bind((String)Messages.TriggerSectionPart_CONFIRM_REMOVE_TRIGGER_SINGULAR, (Object)namesBuilder.toString());
        if (names.size() > 1) {
            messageText = NLS.bind((String)Messages.TriggerSectionPart_CONFIRM_REMOVE_TRIGGER_PLURAL, (Object)names.size(), (Object)namesBuilder.toString());
        }
        return MessageDialog.openConfirm((Shell)shell, (String)Messages.TriggerSectionPart_CONFIRM_REMOVE_TITLE, (String)messageText);
    }

    private void askConfirmationAndDelete(Shell shell, TriggerRule ... rules) {
        if (rules.length > 0 && this.askConfirmation(shell, rules)) {
            TriggerRule[] triggerRuleArray = rules;
            int n = rules.length;
            int n2 = 0;
            while (n2 < n) {
                TriggerRule rule = triggerRuleArray[n2];
                this.getNotificationRepository().removeNotificationRule(rule);
                ++n2;
            }
        }
    }

    private Button createDeleteButton(FormToolkit toolkit, final Composite buttonContainer) {
        Button button = toolkit.createButton(buttonContainer, Messages.TriggerSectionPart_BUTTON_DELETE_TEXT, 8);
        button.setToolTipText(Messages.TriggerSectionPart_BUTTON_DELETE_TOOLTIP);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selected = TriggerSectionPart.this.getFirstSelected();
                if (selected instanceof TriggerRule) {
                    TriggerSectionPart.this.askConfirmationAndDelete(buttonContainer.getShell(), new TriggerRule[]{(TriggerRule)selected});
                } else if (selected instanceof RuleGroup) {
                    List<TriggerRule> rules = ((RuleGroup)selected).getRules();
                    TriggerSectionPart.this.askConfirmationAndDelete(buttonContainer.getShell(), rules.toArray(new TriggerRule[rules.size()]));
                }
                TriggerSectionPart.this.m_viewer.refresh();
                TriggerSectionPart.this.updateButtons();
            }
        });
        return button;
    }

    void updateButtons() {
        Object selected = this.getFirstSelected();
        this.m_deleteButton.setEnabled(selected instanceof TriggerRule || selected instanceof RuleGroup);
        this.m_renameButton.setEnabled(selected instanceof TriggerRule || selected instanceof RuleGroup);
        this.m_exportButton.setEnabled(this.m_viewer.getTree().getItemCount() > 0);
    }

    public void dispose() {
        super.dispose();
    }

    public void initializePart() {
        super.initializePart();
        if (!this.getConnectionHandle().isConnected()) {
            return;
        }
        this.initializeDefaultTriggers();
        this.setupRefreshAction();
        this.setupExpansionStateHandling();
        this.selectARule();
    }

    private void setupRefreshAction() {
        this.getMCToolBarManager().add((IAction)new MBeanAutomaticRefreshAction(this.getConnectionHandle(), new IRefreshable(){

            public boolean refresh() {
                TriggerSectionPart.this.updateViewer();
                return true;
            }
        }));
    }

    private IConnectionHandle getConnectionHandle() {
        return (IConnectionHandle)this.getManagedForm().getInput();
    }

    private void setupExpansionStateHandling() {
        TriggerToolkit.retrieveExpansionState((TreeViewer)this.m_viewer);
        TriggerToolkit.storeExpansionState((TreeViewer)this.m_viewer);
        this.m_viewer.getTree().getParent().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TriggerToolkit.storeExpansionState((TreeViewer)TriggerSectionPart.this.m_viewer);
            }
        });
    }

    private void initializeDefaultTriggers() {
        if (!TriggerToolkit.hasDefaultTriggersBeenLoaded()) {
            IStatus status = TriggerToolkit.resetTriggers();
            TriggerToolkit.setDefaultTriggersLoaded();
            if (status.getSeverity() == 0) {
                this.m_viewer.refresh();
            }
        }
    }

    public void refreshPart() {
        super.refreshPart();
        this.updateViewer();
        this.updateButtons();
    }

    private CheckboxTreeViewer createViewer(IManagedForm managedForm, FormToolkit toolkit, Tree tree, Composite client) {
        TriggerContentProvider triggerContentProvider = new TriggerContentProvider();
        CheckboxTreeViewer viewer = new CheckboxTreeViewer(tree);
        viewer.setContentProvider((IContentProvider)triggerContentProvider);
        viewer.setSorter(new ViewerSorter());
        viewer.setLabelProvider((IBaseLabelProvider)new TriggerLabelProvider(this.getConnectionHandle()));
        viewer.setInput((Object)this.getNotificationRepository());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TriggerSectionPart.this.getManagedForm().fireSelectionChanged((IFormPart)TriggerSectionPart.this, event.getSelection());
                TriggerSectionPart.this.updateButtons();
            }
        });
        this.m_checkManager = new CheckedStateManager(viewer);
        this.m_checkManager.addModifierProvider((ICheckedStateModifierProvider)new RuleCheckedStateProvider(this.getConnectionHandle()));
        this.m_checkManager.addModifierProvider((ICheckedStateModifierProvider)new ContainerProviderModifier(this.m_checkManager));
        return viewer;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (selection instanceof StructuredSelection) {
            this.refreshSelection((StructuredSelection)selection);
        }
    }

    private void refreshSelection(StructuredSelection structuredSelection) {
        for (Object object : structuredSelection) {
            if (!(object instanceof TriggerRule)) continue;
            this.m_viewer.refresh(object, true);
        }
    }

    public void updateViewer() {
        this.m_checkManager.getViewer().refresh();
        this.m_checkManager.refresh();
    }

    private static class ShowAlertsButtonSelectionListener
    extends SelectionAdapter {
        private ShowAlertsButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            AlertPlugin.getDefault().showDialog(true);
        }
    }
}

