/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.util;

import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import java.util.Date;

public final class TimeRangeToolkit {
    private TimeRangeToolkit() {
        throw new Error("Don't instantiate");
    }

    public static long cropRange(ITimeRange cropRange, ITimeRange range) {
        if (cropRange.getStartTimestamp() == -4611686018427387904L) {
            return Long.MAX_VALUE;
        }
        if (cropRange.getEndTimestamp() == 0x3FFFFFFFFFFFFFFFL) {
            return Long.MAX_VALUE;
        }
        long maxStart = Math.max(range.getStartTimestamp(), cropRange.getStartTimestamp());
        long minEnd = Math.min(range.getEndTimestamp(), cropRange.getEndTimestamp());
        long duration = minEnd - maxStart;
        return duration < 0L ? 0L : duration;
    }

    public static String formatRange(ITimeRange timeRange) {
        return String.valueOf('[') + TimeRangeToolkit.getTimeAsString(timeRange.getStartTimestamp()) + ", " + TimeRangeToolkit.getTimeAsString(timeRange.getEndTimestamp()) + ']';
    }

    public static long calculateDuration(long startTimestamp, long endTimestamp) {
        if (startTimestamp == -4611686018427387904L || endTimestamp == 0x3FFFFFFFFFFFFFFFL) {
            return Long.MAX_VALUE;
        }
        return endTimestamp - startTimestamp;
    }

    private static String getTimeAsString(long time) {
        if (time == -4611686018427387904L) {
            return "-Infinity";
        }
        if (time == 0x3FFFFFFFFFFFFFFFL) {
            return "+Infinity";
        }
        return String.valueOf(new Date(time / 1000000L).toString()) + ' ' + (double)(time % 1000000L) / 1000.0 + " ms";
    }
}

