/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.model.FLRThread;
import com.jrockit.mc.flightrecorder.internal.model.RootTrackGroup;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Chunk;
import com.jrockit.mc.flightrecorder.internal.parser.binary.EventCollection;
import com.jrockit.mc.flightrecorder.provider.EventStorage;
import com.jrockit.mc.flightrecorder.provider.EventType;
import com.jrockit.mc.flightrecorder.provider.Producer;
import com.jrockit.mc.flightrecorder.provider.Repository;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IRepository;
import com.jrockit.mc.flightrecorder.util.DisjointBuilder;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RepositoryBuilder {
    private long recordingStart = Long.MAX_VALUE;
    private long recordingEnd = 0L;
    private final Map<IEventType, Map<FLRThread, List<EventCollection>>> eventsMap = new HashMap<IEventType, Map<FLRThread, List<EventCollection>>>();

    public void addChunk(Chunk chunk) {
        for (Chunk.EventEntry eventEntry : chunk.getEvents()) {
            this.addEventCollection(eventEntry.getThread(), eventEntry.getEventType(), eventEntry.getEvents());
        }
        this.recordingStart = Math.min(this.recordingStart, chunk.getStartTime());
        this.recordingEnd = Math.max(this.recordingEnd, chunk.getEndTime());
    }

    private void addEventCollection(FLRThread thread, IEventType eventType, EventCollection eventCollection) {
        List<EventCollection> eventsList;
        Map<FLRThread, List<EventCollection>> eventTypeMap = this.eventsMap.get(eventType);
        if (eventTypeMap == null) {
            eventTypeMap = new HashMap<FLRThread, List<EventCollection>>();
            this.eventsMap.put(eventType, eventTypeMap);
        }
        if ((eventsList = eventTypeMap.get(thread)) == null) {
            eventsList = new ArrayList<EventCollection>();
            eventTypeMap.put(thread, eventsList);
        }
        eventsList.add(eventCollection);
    }

    public IRepository buildRepository(Collection<Producer> producers) {
        RootTrackGroup trackSystem = new RootTrackGroup();
        ArrayList<EventStorage> allEventStorages = new ArrayList<EventStorage>(100);
        for (Map.Entry<IEventType, Map<FLRThread, List<EventCollection>>> typeEntry : this.eventsMap.entrySet()) {
            EventType eventType = (EventType)typeEntry.getKey();
            for (Map.Entry<FLRThread, List<EventCollection>> threadEntry : typeEntry.getValue().entrySet()) {
                FLRThread thread = threadEntry.getKey();
                List<EventCollection> eventCollections = threadEntry.getValue();
                Iterable<IEvent[]> eventArrays = DisjointBuilder.toArrays(eventCollections, EventCollection.ARRAY_FACTORY);
                for (IEvent[] events : eventArrays) {
                    EventStorage storage = new EventStorage(events);
                    eventType.addEventStorage(storage);
                    trackSystem.addEventStorage(thread, eventType, storage);
                    allEventStorages.add(storage);
                }
            }
        }
        return new Repository(producers, allEventStorages, trackSystem, new TimeRange(this.recordingStart, this.recordingEnd));
    }
}

