/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.Chunk;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ChunkHeader;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ChunkMetadata;
import com.jrockit.mc.flightrecorder.internal.parser.binary.EventParserManager;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IByteInput;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.InvalidFlrFileException;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;
import com.jrockit.mc.flightrecorder.internal.parser.binary.factories.GlobalObjectPool;
import java.util.concurrent.Callable;

public class ChunkLoader
implements Callable<Chunk> {
    private final ThreadLocal<IByteInput> tlInput;
    private final GlobalObjectPool globalObjects;
    private final ChunkHeader header;
    private final ChunkMetadata metaData;

    public ChunkLoader(ChunkHeader header, ChunkMetadata metaData, ThreadLocal<IByteInput> tlInput, GlobalObjectPool globalObjects) {
        this.globalObjects = globalObjects;
        this.tlInput = tlInput;
        this.header = header;
        this.metaData = metaData;
    }

    @Override
    public Chunk call() throws Exception {
        IByteInput input = this.tlInput.get();
        int dataLength = this.header.getMetaDataOffset() + this.header.getMetaDataSize();
        byte[] data = input.read(this.header.getChunkPosition(), dataLength);
        ChunkMetadata metaData = this.getMetadata(data);
        EventParserManager eventParser = new EventParserManager(metaData, data, this.globalObjects);
        int nextEventIndex = this.header.getHeaderSize();
        Offset offset = new Offset(nextEventIndex, data.length);
        while (nextEventIndex < dataLength) {
            offset.set(nextEventIndex);
            nextEventIndex += IntegerParser.readInt(data, offset);
            int eventTypeId = IntegerParser.readInt(data, offset);
            if (eventTypeId == 0 || eventTypeId == 1) continue;
            eventParser.loadEvent(data, offset, eventTypeId);
        }
        return new Chunk(this.header, metaData, eventParser.getEvents(), eventParser.getStartTime(), eventParser.getEndTime());
    }

    private ChunkMetadata getMetadata(byte[] data) throws InvalidFlrFileException {
        return this.metaData != null ? this.metaData : new ChunkMetadata(data, this.header.getMetaDataOffset());
    }
}

