/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.geom.Path2D;
import javax.swing.Icon;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.multitabs.Controller;
import org.netbeans.core.multitabs.TabContainer;
import org.netbeans.core.multitabs.TabDisplayer;
import org.netbeans.core.multitabs.TabDisplayerFactory;
import org.netbeans.core.windows.view.ui.tabcontrol.AbstractTabbedImpl;
import org.netbeans.swing.tabcontrol.ComponentConverter;
import org.netbeans.swing.tabcontrol.DefaultTabDataModel;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.customtabs.Tabbed;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.openide.windows.TopComponent;

public class TabbedImpl
extends AbstractTabbedImpl {
    private final TabContainer container;
    private final Controller controller;
    private final TabDataModel tabModel;
    private ComponentConverter componentConverter = ComponentConverter.DEFAULT;

    public TabbedImpl(WinsysInfoForTabbedContainer winsysInfoForTabbedContainer, int n) {
        this.tabModel = new DefaultTabDataModel();
        TabDisplayer tabDisplayer = TabDisplayerFactory.getDefault().createTabDisplayer(this.tabModel, n);
        this.controller = new Controller(tabDisplayer);
        this.container = new TabContainer(this, tabDisplayer, n);
        this.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TabbedImpl.this.fireStateChanged();
            }
        });
    }

    protected final TabDataModel getTabModel() {
        return this.tabModel;
    }

    protected final SingleSelectionModel getSelectionModel() {
        return this.controller.getSelectionModel();
    }

    protected void requestAttention(int n) {
    }

    protected void cancelRequestAttention(int n) {
    }

    protected void setAttentionHighlight(int n, boolean bl) {
    }

    protected int dropIndexOfPoint(Point point) {
        point = SwingUtilities.convertPoint(this.getComponent(), point, this.getTabDisplayer());
        return this.getTabDisplayer().dropIndexOfPoint(point);
    }

    protected ComponentConverter getComponentConverter() {
        return this.componentConverter;
    }

    protected Shape getDropIndication(TopComponent topComponent, Point point) {
        point = SwingUtilities.convertPoint(this.getComponent(), point, this.getTabDisplayer());
        Path2D.Double double_ = new Path2D.Double();
        Rectangle rectangle = this.getTabDisplayer().dropIndication(topComponent, point);
        if (null != rectangle) {
            rectangle = SwingUtilities.convertRectangle(this.getTabDisplayer(), rectangle, this.container);
            double_.append(rectangle, false);
        }
        double_.append(this.container.getContentArea(), false);
        return double_;
    }

    public void addActionListener(ActionListener actionListener) {
        this.controller.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.controller.removeActionListener(actionListener);
    }

    public int getTabCount() {
        return this.getTabModel().size();
    }

    public int indexOf(Component component) {
        int n = this.getTabModel().size();
        TabDataModel tabDataModel = this.getTabModel();
        for (int i = 0; i < n; ++i) {
            if (this.getComponentConverter().getComponent(tabDataModel.getTab(i)) != component) continue;
            return i;
        }
        return -1;
    }

    public void setTitleAt(int n, String string) {
        this.getTabModel().setText(n, string);
    }

    public void setIconAt(int n, Icon icon) {
        this.getTabModel().setIcon(n, icon);
    }

    public void setToolTipTextAt(int n, String string) {
        TabData tabData = this.getTabModel().getTab(n);
        if (tabData != null) {
            this.getTabModel().setTab(n, new TabData(tabData.getUserObject(), tabData.getIcon(), tabData.getText(), string));
        }
    }

    public void setActive(boolean bl) {
    }

    public int tabForCoordinate(Point point) {
        point = SwingUtilities.convertPoint(this.getComponent(), point, this.getTabDisplayer());
        TabData tabData = this.getTabDisplayer().getTabAt(point);
        if (null == tabData) {
            return -1;
        }
        return this.tabModel.indexOf(tabData);
    }

    public Image createImageOfTab(int n) {
        return null;
    }

    public Component getComponent() {
        return this.container;
    }

    public Rectangle getTabBounds(int n) {
        Rectangle rectangle = this.getTabDisplayer().getTabBounds(n);
        if (null != rectangle) {
            rectangle = SwingUtilities.convertRectangle(this.getTabDisplayer(), rectangle, this.container);
        }
        return rectangle;
    }

    public Rectangle getTabsArea() {
        Rectangle rectangle = this.container.getTabDisplayer().getTabsArea();
        rectangle = SwingUtilities.convertRectangle(this.getTabDisplayer(), rectangle, this.container);
        return rectangle;
    }

    public boolean isTransparent() {
        return false;
    }

    public void setTransparent(boolean bl) {
    }

    public void makeBusy(TopComponent topComponent, boolean bl) {
        int n = this.indexOf((Component)topComponent);
        BusyTabsSupport.getDefault().makeTabBusy((Tabbed)this, n, bl);
    }

    private TabDisplayer getTabDisplayer() {
        return this.container.getTabDisplayer();
    }
}

