/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CellTipManager;
import org.netbeans.lib.profiler.ui.components.FlatToolBar;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.threads.CustomTimeLineViewport;
import org.netbeans.lib.profiler.ui.threads.ThreadNameCellRenderer;
import org.netbeans.lib.profiler.ui.threads.ThreadStateCellRenderer;
import org.netbeans.lib.profiler.ui.threads.ThreadStateHeaderRenderer;
import org.netbeans.lib.profiler.ui.threads.ThreadStateIcon;
import org.netbeans.modules.profiler.api.icons.Icons;

public class ThreadsPanel
extends JPanel
implements AdjustmentListener,
ActionListener,
TableColumnModelListener,
DataManagerListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.threads.Bundle");
    private static final String VIEW_THREADS_ALL = messages.getString("ThreadsPanel_ViewThreadsAll");
    private static final String VIEW_THREADS_LIVE = messages.getString("ThreadsPanel_ViewThreadsLive");
    private static final String VIEW_THREADS_FINISHED = messages.getString("ThreadsPanel_ViewThreadsFinished");
    private static final String VIEW_THREADS_SELECTION = messages.getString("ThreadsPanel_ViewThreadsSelection");
    private static final String THREADS_TABLE = messages.getString("ThreadsPanel_ThreadsTable");
    private static final String ENABLE_THREADS_PROFILING = messages.getString("ThreadsPanel_EnableThreadsProfiling");
    private static final String ZOOM_IN_TOOLTIP = messages.getString("ThreadsPanel_ZoomInToolTip");
    private static final String ZOOM_OUT_TOOLTIP = messages.getString("ThreadsPanel_ZoomOutToolTip");
    private static final String FIXED_SCALE_TOOLTIP = messages.getString("ThreadsPanel_FixedScaleToolTip");
    private static final String SCALE_TO_FIT_TOOLTIP = messages.getString("ThreadsPanel_ScaleToFitToolTip");
    private static final String THREADS_MONITORING_DISABLED_MSG = messages.getString("ThreadsPanel_ThreadsMonitoringDisabledMsg");
    private static final String THREADS_MONITORING_DISABLED_TOOLTIP = messages.getString("ThreadsPanel_ThreadsMonitoringDisabledTooltip");
    private static final String NO_PROFILING_MSG = messages.getString("ThreadsPanel_NoProfilingMsg");
    private static final String THREADS_COLUMN_NAME = messages.getString("ThreadsPanel_ThreadsColumnName");
    private static final String TIMELINE_COLUMN_NAME = messages.getString("ThreadsPanel_TimelineColumnName");
    private static final String SELECTED_THREADS_ITEM = messages.getString("ThreadsPanel_SelectedThreadsItem");
    private static final String THREAD_DETAILS_ITEM = messages.getString("ThreadsPanel_ThreadDetailsItem");
    private static final String TABLE_ACCESS_NAME = messages.getString("ThreadsPanel_TableAccessName");
    private static final String TABLE_ACCESS_DESCR = messages.getString("ThreadsPanel_TableAccessDescr");
    private static final String COMBO_ACCESS_NAME = messages.getString("ThreadsPanel_ComboAccessName");
    private static final String COMBO_ACCESS_DESCR = messages.getString("ThreadsPanel_ComboAccessDescr");
    private static final String ENABLE_THREADS_MONITORING_BUTTON_ACCESS_NAME = messages.getString("ThreadsPanel_EnableThreadsMonitoringAccessName");
    private static final String SHOW_LABEL_TEXT = messages.getString("ThreadsPanel_ShowLabelText");
    private static final int NAME_COLUMN_INDEX = 0;
    private static final int DISPLAY_COLUMN_INDEX = 1;
    private static final int RIGHT_DISPLAY_MARGIN = 20;
    private static final int LEFT_DISPLAY_MARGIN = 20;
    private static final int NAME_COLUMN_WIDTH = 190;
    private static final int MIN_NAME_COLUMN_WIDTH = 55;
    private ArrayList filteredDataToDataIndex = new ArrayList();
    private CustomTimeLineViewport viewPort;
    private DefaultComboBoxModel comboModel;
    private DefaultComboBoxModel comboModelWithSelection;
    private JButton enableThreadsMonitoringButton;
    private JButton scaleToFitButton;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private JComboBox threadsSelectionCombo;
    private JLabel enableThreadsMonitoringLabel1;
    private JLabel enableThreadsMonitoringLabel3;
    private JLabel monitorLegend;
    private JLabel runningLegend;
    private JLabel sleepingLegend;
    private JLabel waitLegend;
    private JLabel parkLegend;
    private JMenuItem showOnlySelectedThreads;
    private JMenuItem showThreadsDetails;
    private JPanel contentPanel;
    private JPanel notificationPanel;
    private JPopupMenu popupMenu;
    private JScrollBar scrollBar;
    private JScrollPane tableScroll;
    private JTable table;
    private ProfilerToolbar buttonsToolBar;
    private ThreadsDataManager manager;
    private ThreadsDetailsCallback detailsCallback;
    private boolean internalChange = false;
    private boolean internalScrollbarChange = false;
    private boolean resetPerformed = true;
    private boolean scaleToFit = false;
    private boolean supportsSleepingState;
    private boolean threadsMonitoringEnabled = false;
    private boolean trackingEnd = true;
    private float zoomResolutionPerPixel = 50.0f;
    private long viewEnd;
    private long viewStart = -1L;

    public ThreadsPanel(ThreadsDataManager threadsDataManager, ThreadsDetailsCallback threadsDetailsCallback, boolean bl) {
        this.manager = threadsDataManager;
        this.detailsCallback = threadsDetailsCallback;
        this.supportsSleepingState = bl;
        this.setOpaque(true);
        this.setBackground(new HTMLTextArea().getBackground());
        this.contentPanel = new JPanel(new CardLayout());
        this.contentPanel.setOpaque(true);
        this.contentPanel.setBackground(new HTMLTextArea().getBackground());
        this.table = this.createViewTable();
        this.table.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.table.getAccessibleContext().setAccessibleName(TABLE_ACCESS_NAME);
        this.table.getAccessibleContext().setAccessibleDescription(TABLE_ACCESS_DESCR);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.table.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ThreadsPanel.this.performDefaultAction();
            }
        });
        this.scrollBar = new ThreadsScrollBar();
        this.zoomInButton = new JButton(Icons.getIcon((String)"GeneralIcons.ZoomIn"));
        this.zoomOutButton = new JButton(Icons.getIcon((String)"GeneralIcons.ZoomOut"));
        this.scaleToFitButton = new JButton(this.scaleToFit ? Icons.getIcon((String)"GeneralIcons.Zoom") : Icons.getIcon((String)"GeneralIcons.ScaleToFit"));
        this.comboModel = new DefaultComboBoxModel<Object>(new Object[]{VIEW_THREADS_ALL, VIEW_THREADS_LIVE, VIEW_THREADS_FINISHED});
        this.comboModelWithSelection = new DefaultComboBoxModel<Object>(new Object[]{VIEW_THREADS_ALL, VIEW_THREADS_LIVE, VIEW_THREADS_FINISHED, VIEW_THREADS_SELECTION});
        this.threadsSelectionCombo = new JComboBox(this.comboModel){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.threadsSelectionCombo.getAccessibleContext().setAccessibleName(COMBO_ACCESS_NAME);
        this.threadsSelectionCombo.getAccessibleContext().setAccessibleDescription(COMBO_ACCESS_DESCR);
        JLabel jLabel = new JLabel(SHOW_LABEL_TEXT);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jLabel.setLabelFor(this.threadsSelectionCombo);
        int n = 0;
        jLabel.setDisplayedMnemonic(jLabel.getText().charAt(n));
        jLabel.setDisplayedMnemonicIndex(n);
        this.buttonsToolBar = ProfilerToolbar.create(true);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        this.popupMenu = this.initPopupMenu();
        this.zoomInButton.setEnabled(!this.scaleToFit);
        this.zoomOutButton.setEnabled(!this.scaleToFit);
        this.zoomInButton.setToolTipText(ZOOM_IN_TOOLTIP);
        this.zoomOutButton.setToolTipText(ZOOM_OUT_TOOLTIP);
        this.scaleToFitButton.setToolTipText(this.scaleToFit ? FIXED_SCALE_TOOLTIP : SCALE_TO_FIT_TOOLTIP);
        this.zoomInButton.getAccessibleContext().setAccessibleName(this.zoomInButton.getToolTipText());
        this.zoomOutButton.getAccessibleContext().setAccessibleName(this.zoomOutButton.getToolTipText());
        this.scaleToFitButton.getAccessibleContext().setAccessibleName(this.scaleToFitButton.getToolTipText());
        this.table.setSelectionMode(2);
        this.table.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.table.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.table.setShowGrid(false);
        this.table.setRowMargin(0);
        this.table.setRowHeight(UIUtils.getDefaultRowHeight() + 4);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setBackground(UIUtils.getProfilerResultsBackground());
                component.setFont(jTable.getFont().deriveFont(1));
                if (component instanceof JComponent) {
                    ((JComponent)component).setBorder(new EmptyBorder(0, 3, 0, 3));
                }
                return component;
            }
        };
        this.table.getTableHeader().setDefaultRenderer(defaultTableCellRenderer);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(3);
        this.table.getColumnModel().getColumn(0).setMinWidth(55);
        this.table.getColumnModel().getColumn(0).setMaxWidth(1000);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(190);
        ThreadStateHeaderRenderer threadStateHeaderRenderer = new ThreadStateHeaderRenderer(this);
        threadStateHeaderRenderer.setBackground(UIUtils.getProfilerResultsBackground());
        this.table.getColumnModel().getColumn(1).setHeaderRenderer(threadStateHeaderRenderer);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.setColumnSelectionAllowed(false);
        tableColumnModel.setColumnMargin(0);
        this.table.setDefaultRenderer(ThreadNameCellRenderer.class, new ThreadNameCellRenderer(this));
        this.table.setDefaultRenderer(ThreadStateCellRenderer.class, new ThreadStateCellRenderer(this));
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBackground(UIUtils.getProfilerResultsBackground());
        this.buttonsToolBar.add(this.zoomInButton);
        this.buttonsToolBar.add(this.zoomOutButton);
        this.buttonsToolBar.add(this.scaleToFitButton);
        this.buttonsToolBar.addSeparator();
        this.buttonsToolBar.add(jLabel);
        this.buttonsToolBar.add(this.threadsSelectionCombo);
        jPanel2.add((Component)this.scrollBar, "East");
        ThreadStateIcon threadStateIcon = new ThreadStateIcon(1, 18, 9);
        ThreadStateIcon threadStateIcon2 = new ThreadStateIcon(2, 18, 9);
        ThreadStateIcon threadStateIcon3 = new ThreadStateIcon(3, 18, 9);
        ThreadStateIcon threadStateIcon4 = new ThreadStateIcon(4, 18, 9);
        ThreadStateIcon threadStateIcon5 = new ThreadStateIcon(5, 18, 9);
        this.runningLegend = new JLabel(CommonConstants.THREAD_STATUS_RUNNING_STRING, threadStateIcon, 10);
        this.runningLegend.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.sleepingLegend = new JLabel(CommonConstants.THREAD_STATUS_SLEEPING_STRING, threadStateIcon2, 10);
        this.sleepingLegend.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.waitLegend = new JLabel(CommonConstants.THREAD_STATUS_WAIT_STRING, threadStateIcon4, 10);
        this.waitLegend.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.parkLegend = new JLabel(CommonConstants.THREAD_STATUS_PARK_STRING, threadStateIcon5, 10);
        this.parkLegend.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.monitorLegend = new JLabel(CommonConstants.THREAD_STATUS_MONITOR_STRING, threadStateIcon3, 10);
        this.monitorLegend.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JPanel jPanel3 = new JPanel(new FlowLayout(4, 7, 8));
        jPanel3.setOpaque(false);
        jPanel3.add(this.runningLegend);
        jPanel3.add(this.sleepingLegend);
        if (!bl) {
            this.sleepingLegend.setVisible(false);
        }
        jPanel3.add(this.waitLegend);
        jPanel3.add(this.parkLegend);
        jPanel3.add(this.monitorLegend);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setOpaque(false);
        jPanel4.add((Component)UIUtils.createHorizontalLine(jPanel4.getBackground()), "North");
        jPanel4.add((Component)jPanel3, "East");
        JPanel jPanel5 = new JPanel();
        jPanel5.setOpaque(false);
        jPanel5.setLayout(new BorderLayout());
        this.tableScroll = new JScrollPane();
        this.tableScroll.setOpaque(false);
        this.tableScroll.setCorner("UPPER_RIGHT_CORNER", new JPanel());
        this.tableScroll.getCorner("UPPER_RIGHT_CORNER").setBackground(UIUtils.getProfilerResultsBackground());
        this.viewPort = new CustomTimeLineViewport(this);
        this.viewPort.setView(this.table);
        this.viewPort.setBackground(UIUtils.getProfilerResultsBackground());
        this.tableScroll.setViewport(this.viewPort);
        this.tableScroll.setBorder(BorderFactory.createEmptyBorder());
        this.tableScroll.setViewportBorder(BorderFactory.createEmptyBorder());
        this.tableScroll.setHorizontalScrollBarPolicy(31);
        this.tableScroll.setVerticalScrollBarPolicy(20);
        jPanel5.add((Component)this.tableScroll, "Center");
        jPanel5.add((Component)jPanel2, "South");
        jPanel.add((Component)jPanel5, "Center");
        jPanel.add((Component)jPanel4, "South");
        this.notificationPanel = new JPanel(new FlowLayout(3, 0, 15));
        this.notificationPanel.setBorder(jPanel5.getBorder());
        this.notificationPanel.setBackground(this.table.getBackground());
        UIUtils.decorateProfilerPanel(this.notificationPanel);
        CompoundBorder compoundBorder = new CompoundBorder(new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), new FlatToolBar.FlatMarginBorder());
        this.enableThreadsMonitoringLabel1 = new JLabel(THREADS_MONITORING_DISABLED_MSG);
        this.enableThreadsMonitoringLabel1.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 3));
        this.enableThreadsMonitoringLabel1.setForeground(Color.DARK_GRAY);
        this.enableThreadsMonitoringButton = new JButton(Icons.getIcon((String)"ProfilerIcons.ViewThreads32"));
        this.enableThreadsMonitoringButton.setToolTipText(THREADS_MONITORING_DISABLED_TOOLTIP);
        this.enableThreadsMonitoringButton.setContentAreaFilled(false);
        this.enableThreadsMonitoringButton.setMargin(new Insets(3, 3, 3, 3));
        this.enableThreadsMonitoringButton.setVerticalTextPosition(3);
        this.enableThreadsMonitoringButton.setHorizontalTextPosition(0);
        this.enableThreadsMonitoringButton.setRolloverEnabled(true);
        this.enableThreadsMonitoringButton.setBorder(compoundBorder);
        this.enableThreadsMonitoringButton.getAccessibleContext().setAccessibleName(ENABLE_THREADS_MONITORING_BUTTON_ACCESS_NAME);
        this.enableThreadsMonitoringLabel3 = new JLabel(NO_PROFILING_MSG);
        this.enableThreadsMonitoringLabel3.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 0));
        this.enableThreadsMonitoringLabel3.setForeground(Color.DARK_GRAY);
        this.enableThreadsMonitoringLabel3.setVisible(false);
        this.notificationPanel.add(this.enableThreadsMonitoringLabel1);
        this.notificationPanel.add(this.enableThreadsMonitoringButton);
        this.notificationPanel.add(this.enableThreadsMonitoringLabel3);
        this.setLayout(new BorderLayout());
        this.contentPanel.add((Component)this.notificationPanel, ENABLE_THREADS_PROFILING);
        this.contentPanel.add((Component)jPanel, THREADS_TABLE);
        this.add((Component)this.contentPanel, "Center");
        this.scrollBar.addAdjustmentListener(this);
        this.zoomInButton.addActionListener(this);
        this.zoomOutButton.addActionListener(this);
        this.scaleToFitButton.addActionListener(this);
        this.threadsSelectionCombo.addActionListener(this);
        this.showOnlySelectedThreads.addActionListener(this);
        if (threadsDetailsCallback != null) {
            this.showThreadsDetails.addActionListener(this);
        }
        this.table.getColumnModel().addColumnModelListener(this);
        this.table.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ThreadsPanel.this.refreshViewData();
                ThreadsPanel.this.updateScrollbar();
                ThreadsPanel.this.updateZoomButtonsEnabledState();
                ThreadsPanel.this.revalidate();
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) && (n = ThreadsPanel.this.table.getSelectedRow()) != -1) {
                    Rectangle rectangle = ThreadsPanel.this.table.getCellRect(n, 0, false);
                    ThreadsPanel.this.popupMenu.show(keyEvent.getComponent(), rectangle.x + ((ThreadsPanel)ThreadsPanel.this).table.getSize().width > 50 ? 50 : 5, rectangle.y);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                if ((mouseEvent.getModifiers() & 4) != 0 && (n = ThreadsPanel.this.table.rowAtPoint(mouseEvent.getPoint())) != -1 && !ThreadsPanel.this.table.isRowSelected(n)) {
                    if (mouseEvent.isControlDown()) {
                        ThreadsPanel.this.table.addRowSelectionInterval(n, n);
                    } else {
                        ThreadsPanel.this.table.setRowSelectionInterval(n, n);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = ThreadsPanel.this.table.rowAtPoint(mouseEvent.getPoint());
                if (n != -1) {
                    if (ThreadsPanel.this.table.getSelectedRowCount() == 1) {
                        ThreadsPanel.this.table.getSelectionModel().setSelectionInterval(n, n);
                    }
                    if ((mouseEvent.getModifiers() & 4) != 0) {
                        ThreadsPanel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2) {
                        ThreadsPanel.this.performDefaultAction();
                    }
                }
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && ThreadsPanel.this.isShowing()) {
                    ThreadsPanel.this.dataChanged();
                }
            }
        });
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(this.table.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        this.table.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet<AWTKeyStroke>(this.table.getFocusTraversalKeys(1));
        hashSet.add(KeyStroke.getKeyStroke(9, 1));
        this.table.setFocusTraversalKeys(1, hashSet);
        this.updateScrollbar();
        this.updateZoomButtonsEnabledState();
        threadsDataManager.addDataListener((DataManagerListener)this);
    }

    public Component getToolbar() {
        return this.buttonsToolBar.getComponent();
    }

    public BufferedImage getCurrentViewScreenshot(boolean bl) {
        if (bl) {
            return UIUtils.createScreenshot(this.tableScroll);
        }
        return UIUtils.createScreenshot(this.table);
    }

    public long getDataEnd() {
        return this.manager.getEndTime();
    }

    public long getDataStart() {
        return this.manager.getStartTime();
    }

    public int getDisplayColumnWidth() {
        return this.table.getTableHeader().getHeaderRect((int)1).width;
    }

    public String getThreadClassName(int n) {
        return this.manager.getThreadClassName(n);
    }

    public ThreadData getThreadData(int n) {
        return this.manager.getThreadData(n);
    }

    public String getThreadName(int n) {
        return this.manager.getThreadName(n);
    }

    public long getViewEnd() {
        return this.viewEnd;
    }

    public long getViewStart() {
        return this.viewStart;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.internalChange) {
            return;
        }
        if (actionEvent.getSource() == this.scaleToFitButton) {
            if (!this.scaleToFit) {
                this.scrollBar.setVisible(true);
                this.scaleToFitButton.setIcon(Icons.getIcon((String)"GeneralIcons.Zoom"));
                this.scaleToFit = true;
            } else {
                this.scaleToFit = false;
                this.scaleToFitButton.setIcon(Icons.getIcon((String)"GeneralIcons.ScaleToFit"));
                this.scrollBar.setVisible(false);
                this.scrollBar.setValues(0, 0, 0, 0);
            }
            this.refreshViewData();
            this.updateScrollbar();
            this.updateZoomButtonsEnabledState();
            this.table.getTableHeader().repaint();
            this.viewPort.repaint();
        } else if (actionEvent.getSource() == this.zoomInButton) {
            this.zoomInButton.setEnabled((double)this.zoomResolutionPerPixel > 0.1);
            this.zoomResolutionPerPixel /= 2.0f;
            this.refreshViewData();
            this.updateScrollbar();
            this.updateZoomButtonsEnabledState();
            this.table.getTableHeader().repaint();
            this.viewPort.repaint();
        } else if (actionEvent.getSource() == this.zoomOutButton) {
            this.zoomResolutionPerPixel *= 2.0f;
            this.refreshViewData();
            this.updateScrollbar();
            this.updateZoomButtonsEnabledState();
            this.table.getTableHeader().repaint();
            this.viewPort.repaint();
        } else if (actionEvent.getSource() == this.threadsSelectionCombo) {
            if (this.threadsSelectionCombo.getModel() == this.comboModelWithSelection && this.threadsSelectionCombo.getSelectedItem() != VIEW_THREADS_SELECTION) {
                this.internalChange = true;
                Object object = this.threadsSelectionCombo.getSelectedItem();
                this.threadsSelectionCombo.setModel(this.comboModel);
                this.threadsSelectionCombo.setSelectedItem(object);
                this.internalChange = false;
            }
            this.table.clearSelection();
            this.dataChanged();
        } else if (actionEvent.getSource() == this.showOnlySelectedThreads) {
            for (int i = this.filteredDataToDataIndex.size() - 1; i >= 0; --i) {
                if (this.table.isRowSelected(i)) continue;
                this.filteredDataToDataIndex.remove(i);
            }
            this.threadsSelectionCombo.setModel(this.comboModelWithSelection);
            this.threadsSelectionCombo.setSelectedItem(VIEW_THREADS_SELECTION);
            this.table.clearSelection();
        } else if (actionEvent.getSource() == this.showThreadsDetails) {
            this.performDefaultAction();
        }
    }

    public void addSaveViewAction(AbstractAction abstractAction) {
        Component component = this.buttonsToolBar.add(abstractAction);
        this.buttonsToolBar.remove(component);
        this.buttonsToolBar.add(component, 0);
        this.buttonsToolBar.add(new JToolBar.Separator(), 1);
    }

    public void addThreadsMonitoringActionListener(ActionListener actionListener) {
        this.enableThreadsMonitoringButton.addActionListener(actionListener);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (!this.internalScrollbarChange) {
            if (this.scrollBar.getValue() + this.scrollBar.getVisibleAmount() == this.scrollBar.getMaximum()) {
                this.trackingEnd = true;
            } else {
                this.trackingEnd = false;
                this.viewStart = this.manager.getStartTime() + (long)this.scrollBar.getValue();
                this.viewEnd = this.viewStart + (long)(this.zoomResolutionPerPixel * (float)this.table.getTableHeader().getHeaderRect((int)1).width);
                this.repaint();
            }
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        this.refreshViewData();
        this.updateScrollbar();
        this.updateZoomButtonsEnabledState();
        if (this.viewPort != null) {
            this.viewPort.repaint();
        }
        this.scrollBar.invalidate();
        this.revalidate();
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    public void dataChanged() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                ThreadsPanel.this.refreshUI();
            }
        });
    }

    public void dataReset() {
        this.filteredDataToDataIndex.clear();
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                ThreadsPanel.this.refreshUI();
                ThreadsPanel.this.updateSupportsSleepingState(ThreadsPanel.this.manager.supportsSleepingStateMonitoring());
            }
        });
    }

    public boolean fitsVisibleArea() {
        return !this.tableScroll.getVerticalScrollBar().isVisible();
    }

    public boolean hasView() {
        return !this.notificationPanel.isShowing();
    }

    public void profilingSessionFinished() {
        this.enableThreadsMonitoringButton.setEnabled(false);
        this.enableThreadsMonitoringLabel1.setVisible(false);
        this.enableThreadsMonitoringButton.setVisible(false);
        this.enableThreadsMonitoringLabel3.setVisible(true);
    }

    public void profilingSessionStarted() {
        this.enableThreadsMonitoringButton.setEnabled(true);
        this.enableThreadsMonitoringLabel1.setVisible(true);
        this.enableThreadsMonitoringButton.setVisible(true);
        this.enableThreadsMonitoringLabel3.setVisible(false);
    }

    public void removeThreadsMonitoringActionListener(ActionListener actionListener) {
        this.enableThreadsMonitoringButton.removeActionListener(actionListener);
    }

    @Override
    public void requestFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ThreadsPanel.this.table != null) {
                    ThreadsPanel.this.table.requestFocus();
                }
            }
        });
    }

    public void threadsMonitoringDisabled() {
        this.threadsMonitoringEnabled = false;
        ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, ENABLE_THREADS_PROFILING);
        this.updateZoomButtonsEnabledState();
        this.threadsSelectionCombo.setEnabled(false);
    }

    public void threadsMonitoringEnabled() {
        this.threadsMonitoringEnabled = true;
        ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, THREADS_TABLE);
        this.updateZoomButtonsEnabledState();
        this.threadsSelectionCombo.setEnabled(true);
    }

    boolean supportsSleepingState() {
        return this.supportsSleepingState;
    }

    private JTable createViewTable() {
        return new JExtendedTable(new ThreadsTableModel()){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = this.rowAtPoint(mouseEvent.getPoint());
                int n2 = this.columnAtPoint(mouseEvent.getPoint());
                if (this.getColumnClass(n2) != ThreadNameCellRenderer.class) {
                    CellTipManager.sharedInstance().setEnabled(false);
                    return;
                }
                if (n == this.lastRow && n2 == this.lastColumn) {
                    return;
                }
                this.lastRow = n;
                this.lastColumn = n2;
                if (n < 0 || n2 < 0) {
                    CellTipManager.sharedInstance().setEnabled(false);
                    return;
                }
                Component component = ((ThreadNameCellRenderer)this.getCellRenderer(n, n2)).getTableCellRendererComponentPersistent(this, this.getValueAt(n, n2), false, false, n, n2);
                Rectangle rectangle = this.getCellRect(n, n2, false);
                if (component == null) {
                    CellTipManager.sharedInstance().setEnabled(false);
                    return;
                }
                int n3 = ((ThreadNameCellRenderer)component).getHorizontalAlignment();
                this.rendererRect = n3 == 11 || n3 == 4 ? new Rectangle(rectangle.x + rectangle.width - component.getPreferredSize().width, rectangle.y, component.getPreferredSize().width, component.getPreferredSize().height) : new Rectangle(rectangle.x, rectangle.y, component.getPreferredSize().width, component.getPreferredSize().height);
                if (this.rendererRect.x >= rectangle.x && this.rendererRect.x + this.rendererRect.width <= rectangle.x + rectangle.width) {
                    CellTipManager.sharedInstance().setEnabled(false);
                    return;
                }
                while (this.cellTip.getComponentCount() > 0) {
                    this.cellTip.remove(0);
                }
                this.cellTip.add(component, "Center");
                this.cellTip.setPreferredSize(new Dimension(this.rendererRect.width + 2, this.getRowHeight(n) + 2));
                CellTipManager.sharedInstance().setEnabled(true);
            }
        };
    }

    private JPopupMenu initPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.showOnlySelectedThreads = new JMenuItem(SELECTED_THREADS_ITEM);
        if (this.detailsCallback != null) {
            Font font = jPopupMenu.getFont().deriveFont(1);
            this.showThreadsDetails = new JMenuItem(THREAD_DETAILS_ITEM);
            this.showThreadsDetails.setFont(font);
            jPopupMenu.add(this.showThreadsDetails);
            jPopupMenu.add(new JSeparator());
        }
        jPopupMenu.add(this.showOnlySelectedThreads);
        return jPopupMenu;
    }

    private void performDefaultAction() {
        int[] nArray = this.table.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)this.filteredDataToDataIndex.get(nArray[i]);
        }
        this.detailsCallback.showDetails(nArray);
    }

    private void refreshUI() {
        if (!this.isShowing()) {
            return;
        }
        this.updateFilteredData();
        this.refreshViewData();
        this.updateScrollbar();
        this.updateZoomButtonsEnabledState();
        this.table.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void refreshViewData() {
        if (this.scaleToFit) {
            long l = this.manager.getEndTime() - this.manager.getStartTime();
            int n = this.table.getTableHeader().getHeaderRect((int)1).width;
            float f = (float)l / (float)Math.max(n - 20 - 20, 1);
            this.viewStart = this.manager.getStartTime() - (long)(f * 20.0f);
            this.viewEnd = this.manager.getEndTime() + (long)(f * 20.0f);
        } else {
            long l = (long)(this.zoomResolutionPerPixel * 20.0f);
            long l2 = (long)(this.zoomResolutionPerPixel * 20.0f);
            long l3 = (long)(this.zoomResolutionPerPixel * (float)this.table.getTableHeader().getHeaderRect((int)1).width);
            if (this.viewStart == -1L) {
                this.viewStart = this.manager.getStartTime() - l2;
                this.viewEnd = this.viewStart + l3;
            }
            if (this.trackingEnd) {
                this.viewEnd = this.manager.getEndTime() + l;
                this.viewStart = this.viewEnd - l3;
                if (this.viewStart < this.manager.getStartTime() - l2) {
                    this.viewStart = this.manager.getStartTime() - l2;
                    this.viewEnd = this.viewStart + l3;
                }
            } else {
                if (this.viewStart < this.manager.getStartTime()) {
                    this.viewStart = this.manager.getStartTime() - l;
                }
                this.viewEnd = this.viewStart + l3;
            }
        }
    }

    private void updateFilteredData() {
        if (this.threadsSelectionCombo.getSelectedItem() == VIEW_THREADS_SELECTION) {
            return;
        }
        this.filteredDataToDataIndex.clear();
        for (int i = 0; i < this.manager.getThreadsCount(); ++i) {
            byte by;
            ThreadData threadData;
            if (this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_ALL)) {
                this.filteredDataToDataIndex.add(i);
                continue;
            }
            if (this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_LIVE)) {
                threadData = this.manager.getThreadData(i);
                if (threadData.size() <= 0 || (by = threadData.getLastState()) == 0) continue;
                this.filteredDataToDataIndex.add(i);
                continue;
            }
            if (!this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_FINISHED)) continue;
            threadData = this.manager.getThreadData(i);
            if (threadData.size() > 0) {
                by = threadData.getLastState();
                if (by != 0) continue;
                this.filteredDataToDataIndex.add(i);
                continue;
            }
            this.filteredDataToDataIndex.add(i);
        }
    }

    private void updateScrollbar() {
        this.internalScrollbarChange = true;
        if (this.scrollBar.isVisible() == this.scaleToFit) {
            this.scrollBar.setVisible(!this.scaleToFit);
        }
        if (!this.scaleToFit) {
            int n = (int)(this.zoomResolutionPerPixel * 20.0f);
            int n2 = (int)(this.zoomResolutionPerPixel * 20.0f);
            int n3 = (int)(this.viewStart - this.manager.getStartTime()) + n2;
            int n4 = (int)(this.viewEnd - this.viewStart);
            int n5 = (int)(this.manager.getEndTime() - this.manager.getStartTime()) + n;
            boolean bl = true;
            if (n3 == 0 && n5 - (n3 + n4) <= 0) {
                bl = false;
            }
            if (this.scrollBar.isVisible() != bl) {
                this.scrollBar.setVisible(bl);
            }
            if (bl) {
                this.scrollBar.setValues(n3, n4, -n2, n5);
                this.scrollBar.setBlockIncrement((int)((float)n4 * 0.95f));
                this.scrollBar.setUnitIncrement(Math.max((int)(this.zoomResolutionPerPixel * 5.0f), 1));
            }
        }
        this.internalScrollbarChange = false;
    }

    private void updateSupportsSleepingState(boolean bl) {
        if (this.supportsSleepingState != bl) {
            this.supportsSleepingState = bl;
            this.sleepingLegend.setVisible(bl);
        }
    }

    private void updateZoomButtonsEnabledState() {
        if (!this.threadsMonitoringEnabled) {
            this.zoomInButton.setEnabled(false);
            this.zoomOutButton.setEnabled(false);
            this.scaleToFitButton.setEnabled(false);
        } else {
            if (this.scaleToFit) {
                this.zoomInButton.setEnabled(false);
                this.zoomOutButton.setEnabled(false);
            } else {
                this.zoomInButton.setEnabled((double)this.zoomResolutionPerPixel > 0.1);
                int n = this.table.getTableHeader().getHeaderRect((int)1).width;
                this.zoomOutButton.setEnabled(this.zoomResolutionPerPixel * (float)n < 2.0f * (float)(this.manager.getEndTime() - this.manager.getStartTime()));
            }
            this.scaleToFitButton.setEnabled(true);
            this.scaleToFitButton.setToolTipText(this.scaleToFit ? FIXED_SCALE_TOOLTIP : SCALE_TO_FIT_TOOLTIP);
        }
    }

    private class ThreadsTableModel
    extends AbstractTableModel {
        private ThreadsTableModel() {
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return ThreadNameCellRenderer.class;
                }
                case 1: {
                    return ThreadStateCellRenderer.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return THREADS_COLUMN_NAME;
                }
                case 1: {
                    return TIMELINE_COLUMN_NAME;
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return ThreadsPanel.this.filteredDataToDataIndex.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return (Integer)ThreadsPanel.this.filteredDataToDataIndex.get(n);
                }
                case 1: {
                    return ThreadsPanel.this.getThreadData((Integer)ThreadsPanel.this.filteredDataToDataIndex.get(n));
                }
            }
            return null;
        }
    }

    class ThreadsScrollBar
    extends JScrollBar {
        public ThreadsScrollBar() {
            super(0);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(((ThreadsPanel)ThreadsPanel.this).table.getTableHeader().getHeaderRect((int)1).width, dimension.height);
        }
    }

    public static interface ThreadsDetailsCallback {
        public void showDetails(int[] var1);
    }
}

