/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.threads.ThreadsPanel;
import org.netbeans.lib.profiler.ui.threads.TimeLineUtils;

public class ThreadStateHeaderRenderer
extends JPanel
implements TableCellRenderer,
Serializable {
    private ThreadsPanel viewManager;
    private long dataEnd;
    private long dataStart;
    private long viewEnd;
    private long viewStart;
    private static JLabel MARK_NOMILLIS_LABEL;
    private static JLabel MARK_MILLIS_LABEL;
    private static JLabel LEGEND_LABEL;

    public ThreadStateHeaderRenderer(ThreadsPanel threadsPanel) {
        this.viewManager = threadsPanel;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean isOpaque() {
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
        return !bl && super.isOpaque();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.getFont().getSize() + 11);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.viewStart = this.viewManager.getViewStart();
        this.viewEnd = this.viewManager.getViewEnd();
        this.dataStart = this.viewManager.getDataStart();
        this.dataEnd = this.viewManager.getDataEnd();
        return this;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintResizableMark(graphics);
        this.paintTimeMarks(graphics);
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void validate() {
    }

    private void paintResizableMark(Graphics graphics) {
        int n;
        int n2;
        graphics.setColor(Color.BLACK);
        for (n2 = n = 4; n2 < this.getSize().height - n; n2 += 2) {
            graphics.drawLine(1, n2, 1, n2);
        }
        for (n2 = n + 1; n2 < this.getSize().height - n - 1; n2 += 2) {
            graphics.drawLine(0, n2, 0, n2);
        }
        graphics.setClip(4, 0, this.getWidth() - 3, this.getHeight());
    }

    private void paintTimeMarkString(Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl;
        if (MARK_NOMILLIS_LABEL == null) {
            MARK_NOMILLIS_LABEL = new JLabel();
            MARK_NOMILLIS_LABEL.setHorizontalAlignment(0);
            MARK_NOMILLIS_LABEL.setOpaque(true);
            MARK_NOMILLIS_LABEL.setBackground(UIUtils.getProfilerResultsBackground());
            MARK_NOMILLIS_LABEL.setFont(MARK_NOMILLIS_LABEL.getFont().deriveFont(1));
            MARK_MILLIS_LABEL = new JLabel();
            MARK_MILLIS_LABEL.setHorizontalAlignment(0);
            MARK_MILLIS_LABEL.setOpaque(true);
            MARK_MILLIS_LABEL.setBackground(UIUtils.getProfilerResultsBackground());
            MARK_MILLIS_LABEL.setFont(MARK_MILLIS_LABEL.getFont().deriveFont(1));
            MARK_MILLIS_LABEL.setFont(MARK_MILLIS_LABEL.getFont().deriveFont((float)(MARK_MILLIS_LABEL.getFont().getSize() - 2)));
        }
        String string = TimeLineUtils.getTimeMarkNoMillisString(n, n2);
        String string2 = TimeLineUtils.getTimeMarkMillisString(n, n2);
        boolean bl2 = bl = !string2.isEmpty();
        if (bl) {
            string2 = "." + string2;
        }
        MARK_NOMILLIS_LABEL.setText(string);
        if (bl) {
            MARK_MILLIS_LABEL.setText(string2);
        }
        Dimension dimension = MARK_NOMILLIS_LABEL.getPreferredSize();
        dimension.width += 2;
        ++dimension.height;
        Dimension dimension2 = bl ? MARK_MILLIS_LABEL.getPreferredSize() : new Dimension();
        dimension2.width += 2;
        ++dimension2.height;
        int n5 = dimension.width;
        int n6 = n5 + dimension2.width;
        int n7 = dimension.height;
        int n8 = n3 - n6 / 2;
        int n9 = n4 + (this.getHeight() - n7) / 2;
        graphics.translate(n8, n9);
        MARK_NOMILLIS_LABEL.setSize(dimension);
        MARK_NOMILLIS_LABEL.paint(graphics);
        graphics.translate(-n8, -n9);
        if (bl) {
            graphics.translate(n8 + n5, n9);
            MARK_MILLIS_LABEL.setSize(dimension2);
            MARK_MILLIS_LABEL.paint(graphics);
            graphics.translate(-n8 - n5, -n9);
        }
    }

    private void paintTimeMarks(Graphics graphics) {
        if (LEGEND_LABEL == null) {
            LEGEND_LABEL = new JLabel();
            LEGEND_LABEL.setHorizontalAlignment(0);
            LEGEND_LABEL.setOpaque(true);
            LEGEND_LABEL.setBackground(UIUtils.getProfilerResultsBackground());
        }
        if (this.viewEnd - this.viewStart > 0L) {
            int n = (int)(this.viewStart - this.dataStart);
            int n2 = (int)(this.viewEnd - this.dataStart);
            float f = (float)this.getWidth() / (float)(this.viewEnd - this.viewStart);
            int n3 = TimeLineUtils.getOptimalUnits(f);
            int n4 = Math.max((int)(Math.ceil((double)n / (double)n3) * (double)n3), 0);
            for (int i = n4 - n3; i <= n2 + n3; i += n3) {
                if (i < 0) continue;
                float f2 = i - n;
                int n5 = (int)(f2 * f);
                this.paintTimeTicks(graphics, (int)(f2 * f), (int)((f2 + (float)n3) * f), TimeLineUtils.getTicksCount(n3));
                graphics.setColor(TimeLineUtils.BASE_TIMELINE_COLOR);
                graphics.drawLine(n5, 0, n5, 4);
                graphics.setColor(TimeLineUtils.MAIN_TIMELINE_COLOR);
                graphics.drawLine(n5, 5, n5, this.getHeight() - 1);
                this.paintTimeMarkString(graphics, i, n3, n5, 0);
            }
            String string = TimeLineUtils.getUnitsLegend(n2, n3);
            LEGEND_LABEL.setText(string);
            Dimension dimension = LEGEND_LABEL.getPreferredSize();
            dimension.width += 8;
            dimension.height += 4;
            if (dimension.width <= this.getWidth()) {
                graphics.translate(this.getWidth() - dimension.width, (this.getHeight() - dimension.height) / 2);
                LEGEND_LABEL.setSize(dimension.width, dimension.height);
                LEGEND_LABEL.paint(graphics);
                graphics.translate(-this.getWidth() + dimension.width, -(this.getHeight() - dimension.height) / 2);
            }
        }
    }

    private void paintTimeTicks(Graphics graphics, int n, int n2, int n3) {
        float f = (float)(n2 - n) / (float)n3;
        for (int i = 1; i < n3; ++i) {
            int n4 = n + (int)((float)i * f);
            graphics.setColor(TimeLineUtils.BASE_TIMELINE_COLOR);
            graphics.drawLine(n4, 0, n4, 2);
            graphics.setColor(TimeLineUtils.TICK_TIMELINE_COLOR);
            graphics.drawLine(n4, 3, n4, this.getHeight() - 1);
        }
    }
}

