/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.Component;
import javax.swing.JTable;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.threads.ThreadStateIcon;
import org.netbeans.lib.profiler.ui.threads.ThreadsPanel;

public class ThreadNameCellRenderer
extends LabelTableCellRenderer {
    private static final int THREAD_ICON_SIZE = 9;
    private static ThreadStateIcon noneIcon = new ThreadStateIcon(-100, 9, 9);
    private static ThreadStateIcon unknownIcon = new ThreadStateIcon(-1, 9, 9);
    private static ThreadStateIcon zombieIcon = new ThreadStateIcon(0, 9, 9);
    private static ThreadStateIcon runningIcon = new ThreadStateIcon(1, 9, 9);
    private static ThreadStateIcon sleepingIcon = new ThreadStateIcon(2, 9, 9);
    private static ThreadStateIcon monitorIcon = new ThreadStateIcon(3, 9, 9);
    private static ThreadStateIcon waitIcon = new ThreadStateIcon(4, 9, 9);
    private static ThreadStateIcon parkIcon = new ThreadStateIcon(5, 9, 9);
    private ThreadsPanel viewManager;

    public ThreadNameCellRenderer(ThreadsPanel threadsPanel) {
        this.viewManager = threadsPanel;
    }

    @Override
    public Component getTableCellRendererComponentPersistent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        return new ThreadNameCellRenderer(this.viewManager).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    @Override
    protected void setValue(JTable jTable, Object object, int n, int n2) {
        super.setValue(jTable, object, n, n2);
        if (object == null) {
            this.label.setText("");
            this.label.setIcon(zombieIcon);
        } else {
            int n3 = (Integer)object;
            ThreadData threadData = this.viewManager.getThreadData(n3);
            this.label.setText(this.viewManager.getThreadName(n3));
            if (threadData.size() > 0) {
                byte by = threadData.getLastState();
                switch (by) {
                    case -1: {
                        this.label.setIcon(unknownIcon);
                        break;
                    }
                    case 0: {
                        this.label.setIcon(zombieIcon);
                        break;
                    }
                    case 1: {
                        this.label.setIcon(runningIcon);
                        break;
                    }
                    case 2: {
                        if (this.viewManager.supportsSleepingState()) {
                            this.label.setIcon(sleepingIcon);
                            break;
                        }
                        this.label.setIcon(runningIcon);
                        break;
                    }
                    case 3: {
                        this.label.setIcon(monitorIcon);
                        break;
                    }
                    case 4: {
                        this.label.setIcon(waitIcon);
                        break;
                    }
                    case 5: {
                        this.label.setIcon(parkIcon);
                    }
                }
            } else {
                this.label.setIcon(zombieIcon);
            }
        }
    }
}

